/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authz;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.nutanix.devplatform.models.PrettyModeViews;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authz.ApiVersion;
import com.nutanix.dp1.iam.iam.v4.authz.HttpMethod;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.validation.constraints.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssociatedEndpoint
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(AssociatedEndpoint.class);
    @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$")
    private @Pattern(regexp="^((http[s]?|nfs):/)?/?([^:/\\s]*)((/\\w+)*(:[0-9]+)*?/)([\\w\\-\\.]+[^#?\\s]+)(.*)?(#[\\w\\-]+)?$") String endpointUrl = null;
    @JsonProperty(value="apiVersion")
    public ApiVersion apiVersion = null;
    @JsonProperty(value="httpMethod")
    public HttpMethod httpMethod = null;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $reserved;
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final String $objectType = this.initialize$objectType();
    @JsonView(value={PrettyModeViews.StandardView.class})
    protected final Map<String, Object> $unknownFields;

    public AssociatedEndpoint() {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
    }

    public AssociatedEndpoint(ApiVersion apiVersion, String endpointUrl, HttpMethod httpMethod) {
        this.$reserved = new LinkedHashMap<String, Object>();
        this.$reserved.put("$fv", this.initialize$fv());
        this.$unknownFields = new LinkedHashMap<String, Object>();
        this.setApiVersion(apiVersion);
        this.setEndpointUrl(endpointUrl);
        this.setHttpMethod(httpMethod);
    }

    protected String initialize$objectType() {
        return "iam.v4.authz.AssociatedEndpoint";
    }

    protected String initialize$fv() {
        return "v4.r0";
    }

    @JsonAnySetter
    private void setUndeserializedFields(String name, Object value) {
        this.$unknownFields.put(name, value);
    }

    public void setEndpointUrl(String endpointUrl) {
        if (this.endpointUrl == null) {
            this.endpointUrl = endpointUrl;
        } else {
            log.warn("Read-only property endpointUrl already contains a non-null value and cannot be set again");
        }
    }

    public static AssociatedEndpointBuilder AssociatedEndpointBuilder() {
        return new AssociatedEndpointBuilder();
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="httpMethod")
    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssociatedEndpoint)) {
            return false;
        }
        AssociatedEndpoint other = (AssociatedEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        ApiVersion this$apiVersion = this.getApiVersion();
        ApiVersion other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !((Object)((Object)this$apiVersion)).equals((Object)other$apiVersion)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        return !(this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssociatedEndpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        ApiVersion $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : ((Object)((Object)$apiVersion)).hashCode());
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        return result;
    }

    public String toString() {
        return "AssociatedEndpoint(endpointUrl=" + this.getEndpointUrl() + ", apiVersion=" + (Object)((Object)this.getApiVersion()) + ", httpMethod=" + (Object)((Object)this.getHttpMethod()) + ")";
    }

    @Override
    public Map<String, Object> get$reserved() {
        return this.$reserved;
    }

    @Override
    public String get$objectType() {
        return this.$objectType;
    }

    public Map<String, Object> get$unknownFields() {
        return this.$unknownFields;
    }

    public static class AssociatedEndpointBuilder {
        private ApiVersion apiVersion;
        private String endpointUrl;
        private HttpMethod httpMethod;

        AssociatedEndpointBuilder() {
        }

        public AssociatedEndpointBuilder apiVersion(ApiVersion apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public AssociatedEndpointBuilder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public AssociatedEndpointBuilder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public AssociatedEndpoint build() {
            return new AssociatedEndpoint(this.apiVersion, this.endpointUrl, this.httpMethod);
        }

        public String toString() {
            return "AssociatedEndpoint.AssociatedEndpointBuilder(apiVersion=" + (Object)((Object)this.apiVersion) + ", endpointUrl=" + this.endpointUrl + ", httpMethod=" + (Object)((Object)this.httpMethod) + ")";
        }
    }
}

