/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import java.io.Serializable;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tenant
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Tenant.class);
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(max=255)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(max=255) String name = null;

    public Tenant() {
    }

    public Tenant(String tenantId, String extId, List<ApiLink> links, String name) {
        super(tenantId, extId, links);
        this.setName(name);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.Tenant";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public static TenantBuilder TenantBuilder() {
        return new TenantBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tenant)) {
            return false;
        }
        Tenant other = (Tenant)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Tenant;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "Tenant(name=" + this.getName() + ")";
    }

    public static class TenantBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;

        TenantBuilder() {
        }

        public TenantBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public TenantBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public TenantBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public TenantBuilder name(String name) {
            this.name = name;
            return this;
        }

        public Tenant build() {
            return new Tenant(this.tenantId, this.extId, this.links, this.name);
        }

        public String toString() {
            return "Tenant.TenantBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ")";
        }
    }
}

