/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.nutanix.dp1.iam.annotations.IamJsonDeserializer;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.deserializers.IamOneOfDeserializer;
import com.nutanix.dp1.iam.iam.v4.authn.ApiKeyDetails;
import com.nutanix.dp1.iam.iam.v4.authn.CreationType;
import com.nutanix.dp1.iam.iam.v4.authn.KeyKind;
import com.nutanix.dp1.iam.iam.v4.authn.KeyStatus;
import com.nutanix.dp1.iam.iam.v4.authn.ObjectKeyDetails;
import com.nutanix.dp1.iam.serializers.IamOneOfSerializer;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Key
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(Key.class);
    private OffsetDateTime createdTime = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String lastUpdatedBy = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    private @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String createdBy = null;
    private OffsetDateTime lastUpdatedTime = null;
    private OffsetDateTime lastUsedTime = null;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String $keyDetailsItemDiscriminator = null;
    private OneOfKeyDetailsWrapper keyDetails = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String name = null;
    @Size(max=1000)
    @JsonProperty(value="description")
    public @Size(max=1000) String description = null;
    @JsonProperty(value="keyType")
    public KeyKind keyType = null;
    @JsonProperty(value="creationType")
    public CreationType creationType = null;
    @JsonProperty(value="expiryTime")
    public OffsetDateTime expiryTime = null;
    @JsonProperty(value="status")
    public KeyStatus status = null;
    @Size(min=3, max=255)
    @JsonProperty(value="assignedTo")
    public @Size(min=3, max=255) String assignedTo = null;

    public Key() {
    }

    public Key(String tenantId, String extId, List<ApiLink> links, String name, String description, KeyKind keyType, OffsetDateTime createdTime, String lastUpdatedBy, CreationType creationType, OffsetDateTime expiryTime, KeyStatus status, String createdBy, OffsetDateTime lastUpdatedTime, String assignedTo, OffsetDateTime lastUsedTime, Object keyDetails) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setDescription(description);
        this.setKeyType(keyType);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedBy(lastUpdatedBy);
        this.setCreationType(creationType);
        this.setExpiryTime(expiryTime);
        this.setStatus(status);
        this.setCreatedBy(createdBy);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setAssignedTo(assignedTo);
        this.setLastUsedTime(lastUsedTime);
        this.setKeyDetailsInWrapper(keyDetails);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.Key";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        if (this.lastUpdatedBy == null) {
            this.lastUpdatedBy = lastUpdatedBy;
        } else {
            log.warn("Read-only property lastUpdatedBy already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUsedTime(OffsetDateTime lastUsedTime) {
        if (this.lastUsedTime == null) {
            this.lastUsedTime = lastUsedTime;
        } else {
            log.warn("Read-only property lastUsedTime already contains a non-null value and cannot be set again");
        }
    }

    public String get$keyDetailsItemDiscriminator() {
        if (this.keyDetails != null && this.$keyDetailsItemDiscriminator == null) {
            this.$keyDetailsItemDiscriminator = this.keyDetails.getDiscriminator();
        }
        return this.$keyDetailsItemDiscriminator;
    }

    @JsonSerialize(using=IamOneOfSerializer.class)
    public Object getKeyDetails() {
        if (this.keyDetails == null) {
            log.debug("OneOf property keyDetails was never set. Returning null...");
            return null;
        }
        return this.keyDetails.getValue();
    }

    @JsonIgnore
    public void setKeyDetailsInWrapper(Object value) {
        if (value == null) {
            return;
        }
        if (this.keyDetails == null) {
            this.keyDetails = new OneOfKeyDetailsWrapper();
            this.keyDetails.setValue(value);
            this.$keyDetailsItemDiscriminator = this.keyDetails.getDiscriminator();
        } else {
            log.warn("Read-only property keyDetails already contains a non-null value and cannot be set again");
        }
    }

    public static KeyBuilder KeyBuilder() {
        return new KeyBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        String this$lastUpdatedBy = this.getLastUpdatedBy();
        String other$lastUpdatedBy = other.getLastUpdatedBy();
        if (this$lastUpdatedBy == null ? other$lastUpdatedBy != null : !this$lastUpdatedBy.equals(other$lastUpdatedBy)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        OffsetDateTime this$lastUsedTime = this.getLastUsedTime();
        OffsetDateTime other$lastUsedTime = other.getLastUsedTime();
        if (this$lastUsedTime == null ? other$lastUsedTime != null : !((Object)this$lastUsedTime).equals(other$lastUsedTime)) {
            return false;
        }
        Object this$keyDetails = this.getKeyDetails();
        Object other$keyDetails = other.getKeyDetails();
        if (this$keyDetails == null ? other$keyDetails != null : !this$keyDetails.equals(other$keyDetails)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        KeyKind this$keyType = this.getKeyType();
        KeyKind other$keyType = other.getKeyType();
        if (this$keyType == null ? other$keyType != null : !((Object)((Object)this$keyType)).equals((Object)other$keyType)) {
            return false;
        }
        CreationType this$creationType = this.getCreationType();
        CreationType other$creationType = other.getCreationType();
        if (this$creationType == null ? other$creationType != null : !((Object)((Object)this$creationType)).equals((Object)other$creationType)) {
            return false;
        }
        OffsetDateTime this$expiryTime = this.getExpiryTime();
        OffsetDateTime other$expiryTime = other.getExpiryTime();
        if (this$expiryTime == null ? other$expiryTime != null : !((Object)this$expiryTime).equals(other$expiryTime)) {
            return false;
        }
        KeyStatus this$status = this.getStatus();
        KeyStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$assignedTo = this.getAssignedTo();
        String other$assignedTo = other.getAssignedTo();
        return !(this$assignedTo == null ? other$assignedTo != null : !this$assignedTo.equals(other$assignedTo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Key;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        String $lastUpdatedBy = this.getLastUpdatedBy();
        result = result * 59 + ($lastUpdatedBy == null ? 43 : $lastUpdatedBy.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        OffsetDateTime $lastUsedTime = this.getLastUsedTime();
        result = result * 59 + ($lastUsedTime == null ? 43 : ((Object)$lastUsedTime).hashCode());
        Object $keyDetails = this.getKeyDetails();
        result = result * 59 + ($keyDetails == null ? 43 : $keyDetails.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        KeyKind $keyType = this.getKeyType();
        result = result * 59 + ($keyType == null ? 43 : ((Object)((Object)$keyType)).hashCode());
        CreationType $creationType = this.getCreationType();
        result = result * 59 + ($creationType == null ? 43 : ((Object)((Object)$creationType)).hashCode());
        OffsetDateTime $expiryTime = this.getExpiryTime();
        result = result * 59 + ($expiryTime == null ? 43 : ((Object)$expiryTime).hashCode());
        KeyStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $assignedTo = this.getAssignedTo();
        result = result * 59 + ($assignedTo == null ? 43 : $assignedTo.hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public OffsetDateTime getLastUsedTime() {
        return this.lastUsedTime;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public KeyKind getKeyType() {
        return this.keyType;
    }

    public CreationType getCreationType() {
        return this.creationType;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public KeyStatus getStatus() {
        return this.status;
    }

    public String getAssignedTo() {
        return this.assignedTo;
    }

    public void setKeyDetails(OneOfKeyDetailsWrapper keyDetails) {
        this.keyDetails = keyDetails;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="keyType")
    public void setKeyType(KeyKind keyType) {
        this.keyType = keyType;
    }

    @JsonProperty(value="creationType")
    public void setCreationType(CreationType creationType) {
        this.creationType = creationType;
    }

    @JsonProperty(value="expiryTime")
    public void setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
    }

    @JsonProperty(value="status")
    public void setStatus(KeyStatus status) {
        this.status = status;
    }

    @JsonProperty(value="assignedTo")
    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    @Override
    public String toString() {
        return "Key(createdTime=" + this.getCreatedTime() + ", lastUpdatedBy=" + this.getLastUpdatedBy() + ", createdBy=" + this.getCreatedBy() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", lastUsedTime=" + this.getLastUsedTime() + ", keyDetails=" + this.getKeyDetails() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", keyType=" + (Object)((Object)this.getKeyType()) + ", creationType=" + (Object)((Object)this.getCreationType()) + ", expiryTime=" + this.getExpiryTime() + ", status=" + (Object)((Object)this.getStatus()) + ", assignedTo=" + this.getAssignedTo() + ")";
    }

    public static class KeyBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String description;
        private KeyKind keyType;
        private OffsetDateTime createdTime;
        private String lastUpdatedBy;
        private CreationType creationType;
        private OffsetDateTime expiryTime;
        private KeyStatus status;
        private String createdBy;
        private OffsetDateTime lastUpdatedTime;
        private String assignedTo;
        private OffsetDateTime lastUsedTime;
        private Object keyDetails;

        KeyBuilder() {
        }

        public KeyBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public KeyBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public KeyBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public KeyBuilder name(String name) {
            this.name = name;
            return this;
        }

        public KeyBuilder description(String description) {
            this.description = description;
            return this;
        }

        public KeyBuilder keyType(KeyKind keyType) {
            this.keyType = keyType;
            return this;
        }

        public KeyBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public KeyBuilder lastUpdatedBy(String lastUpdatedBy) {
            this.lastUpdatedBy = lastUpdatedBy;
            return this;
        }

        public KeyBuilder creationType(CreationType creationType) {
            this.creationType = creationType;
            return this;
        }

        public KeyBuilder expiryTime(OffsetDateTime expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public KeyBuilder status(KeyStatus status) {
            this.status = status;
            return this;
        }

        public KeyBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public KeyBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public KeyBuilder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            return this;
        }

        public KeyBuilder lastUsedTime(OffsetDateTime lastUsedTime) {
            this.lastUsedTime = lastUsedTime;
            return this;
        }

        public KeyBuilder keyDetails(Object keyDetails) {
            this.keyDetails = keyDetails;
            return this;
        }

        public Key build() {
            return new Key(this.tenantId, this.extId, this.links, this.name, this.description, this.keyType, this.createdTime, this.lastUpdatedBy, this.creationType, this.expiryTime, this.status, this.createdBy, this.lastUpdatedTime, this.assignedTo, this.lastUsedTime, this.keyDetails);
        }

        public String toString() {
            return "Key.KeyBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", description=" + this.description + ", keyType=" + (Object)((Object)this.keyType) + ", createdTime=" + this.createdTime + ", lastUpdatedBy=" + this.lastUpdatedBy + ", creationType=" + (Object)((Object)this.creationType) + ", expiryTime=" + this.expiryTime + ", status=" + (Object)((Object)this.status) + ", createdBy=" + this.createdBy + ", lastUpdatedTime=" + this.lastUpdatedTime + ", assignedTo=" + this.assignedTo + ", lastUsedTime=" + this.lastUsedTime + ", keyDetails=" + this.keyDetails + ")";
        }
    }

    @JsonDeserialize(using=OneOfKeyDetailsWrapperJsonDeserializer.class)
    public static class OneOfKeyDetailsWrapper {
        @JsonIgnore
        private ApiKeyDetails oneOfType0;
        @JsonIgnore
        private ObjectKeyDetails oneOfType1;
        private String discriminator;
        @JsonIgnore
        private String $objectType;

        public OneOfKeyDetailsWrapper() {
        }

        public OneOfKeyDetailsWrapper(ApiKeyDetails data) {
            this.oneOfType0 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        public OneOfKeyDetailsWrapper(ObjectKeyDetails data) {
            this.oneOfType1 = data;
            this.discriminator = data.get$objectType();
            this.$objectType = data.get$objectType();
        }

        @JsonGetter
        public Object getValue() {
            if (this.oneOfType0 != null && this.oneOfType0.get$objectType().equals(this.discriminator)) {
                return this.oneOfType0;
            }
            if (this.oneOfType1 != null && this.oneOfType1.get$objectType().equals(this.discriminator)) {
                return this.oneOfType1;
            }
            throw new IllegalArgumentException("Unrecognized discriminator:" + this.discriminator);
        }

        public void setValue(Object value) {
            if (value == null) {
                log.warn("null passed to setValue function. OneOf's value will not be set.");
                return;
            }
            if (value instanceof ApiKeyDetails) {
                this.oneOfType0 = (ApiKeyDetails)value;
                this.discriminator = this.oneOfType0.get$objectType();
                this.$objectType = this.oneOfType0.get$objectType();
                return;
            }
            if (value instanceof ObjectKeyDetails) {
                this.oneOfType1 = (ObjectKeyDetails)value;
                this.discriminator = this.oneOfType1.get$objectType();
                this.$objectType = this.oneOfType1.get$objectType();
                return;
            }
            throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfKeyDetailsWrapper:" + value.getClass().getName());
        }

        public String getDiscriminator() {
            return this.discriminator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OneOfKeyDetailsWrapper)) {
                return false;
            }
            OneOfKeyDetailsWrapper other = (OneOfKeyDetailsWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ApiKeyDetails this$oneOfType0 = this.oneOfType0;
            ApiKeyDetails other$oneOfType0 = other.oneOfType0;
            if (this$oneOfType0 == null ? other$oneOfType0 != null : !((Object)this$oneOfType0).equals(other$oneOfType0)) {
                return false;
            }
            ObjectKeyDetails this$oneOfType1 = this.oneOfType1;
            ObjectKeyDetails other$oneOfType1 = other.oneOfType1;
            if (this$oneOfType1 == null ? other$oneOfType1 != null : !((Object)this$oneOfType1).equals(other$oneOfType1)) {
                return false;
            }
            String this$discriminator = this.getDiscriminator();
            String other$discriminator = other.getDiscriminator();
            return !(this$discriminator == null ? other$discriminator != null : !this$discriminator.equals(other$discriminator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OneOfKeyDetailsWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ApiKeyDetails $oneOfType0 = this.oneOfType0;
            result = result * 59 + ($oneOfType0 == null ? 43 : ((Object)$oneOfType0).hashCode());
            ObjectKeyDetails $oneOfType1 = this.oneOfType1;
            result = result * 59 + ($oneOfType1 == null ? 43 : ((Object)$oneOfType1).hashCode());
            String $discriminator = this.getDiscriminator();
            result = result * 59 + ($discriminator == null ? 43 : $discriminator.hashCode());
            return result;
        }

        public String toString() {
            return "Key.OneOfKeyDetailsWrapper(oneOfType0=" + this.oneOfType0 + ", oneOfType1=" + this.oneOfType1 + ", discriminator=" + this.getDiscriminator() + ")";
        }

        @IamJsonDeserializer
        private static class OneOfKeyDetailsWrapperJsonDeserializer
        extends IamOneOfDeserializer<OneOfKeyDetailsWrapper> {
            private static final TypeFactory TYPE_FACTORY = TypeFactory.defaultInstance();
            private static final JavaType ONE_OF_TYPE0 = TYPE_FACTORY.constructType(ApiKeyDetails.class);
            private static final JavaType ONE_OF_TYPE1 = TYPE_FACTORY.constructType(ObjectKeyDetails.class);

            public OneOfKeyDetailsWrapperJsonDeserializer() {
                super(TYPE_FACTORY.constructType(OneOfKeyDetailsWrapper.class));
            }

            @Override
            protected void setDataObject(OneOfKeyDetailsWrapper oneOfObject, Object nestedObject) {
                if (oneOfObject == null) {
                    throw new IllegalArgumentException("Instance of OneOfKeyDetailsWrapper provided is null");
                }
                if (ONE_OF_TYPE0.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                if (ONE_OF_TYPE1.getRawClass().isAssignableFrom(nestedObject.getClass())) {
                    oneOfObject.setValue(nestedObject);
                    if (oneOfObject.getValue() != null) {
                        return;
                    }
                }
                throw new IllegalArgumentException("Attempting to set unsupported object type in OneOfKeyDetailsWrapper:" + nestedObject.getClass().getName());
            }

            @Override
            public String getPackagePrefix() {
                return "com.nutanix.dp1.iam";
            }
        }
    }
}

