/*
 * Decompiled with CFR 0.152.
 */
package com.nutanix.dp1.iam.iam.v4.authn;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nutanix.dp1.iam.common.v1.response.ApiLink;
import com.nutanix.dp1.iam.common.v1.response.ExternalizableAbstractModel;
import com.nutanix.dp1.iam.deserializers.IamObjectTypeTypedObject;
import com.nutanix.dp1.iam.iam.v4.authn.CertRevocationInfo;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertAuthProvider
extends ExternalizableAbstractModel
implements Serializable,
IamObjectTypeTypedObject {
    private static final Logger log = LoggerFactory.getLogger(CertAuthProvider.class);
    private OffsetDateTime createdTime = null;
    private OffsetDateTime lastUpdatedTime = null;
    private String createdBy = null;
    @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$")
    @Size(min=1, max=255)
    @JsonProperty(value="name")
    public @Pattern(regexp="^[^<>;'()&+%/\\\\\"`]*$") @Size(min=1, max=255) String name = null;
    @Size(min=64)
    @JsonProperty(value="clientCaChain")
    public @Size(min=64) String clientCaChain = null;
    @JsonProperty(value="isCertAuthEnabled")
    public Boolean isCertAuthEnabled = null;
    @JsonProperty(value="isCacEnabled")
    public Boolean isCacEnabled = null;
    @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$")
    @JsonProperty(value="dirSvcExtID")
    public @Pattern(regexp="^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$") String dirSvcExtID = null;
    @Size(min=1, max=255)
    @JsonProperty(value="caCertFileName")
    public @Size(min=1, max=255) String caCertFileName = null;
    @JsonProperty(value="certRevocationInfo")
    public CertRevocationInfo certRevocationInfo = null;

    public CertAuthProvider() {
    }

    public CertAuthProvider(String tenantId, String extId, List<ApiLink> links, String name, String clientCaChain, Boolean isCertAuthEnabled, Boolean isCacEnabled, String dirSvcExtID, String caCertFileName, CertRevocationInfo certRevocationInfo, OffsetDateTime createdTime, OffsetDateTime lastUpdatedTime, String createdBy) {
        super(tenantId, extId, links);
        this.setName(name);
        this.setClientCaChain(clientCaChain);
        this.setIsCertAuthEnabled(isCertAuthEnabled);
        this.setIsCacEnabled(isCacEnabled);
        this.setDirSvcExtID(dirSvcExtID);
        this.setCaCertFileName(caCertFileName);
        this.setCertRevocationInfo(certRevocationInfo);
        this.setCreatedTime(createdTime);
        this.setLastUpdatedTime(lastUpdatedTime);
        this.setCreatedBy(createdBy);
    }

    @Override
    protected String initialize$objectType() {
        return "iam.v4.authn.CertAuthProvider";
    }

    @Override
    protected String initialize$fv() {
        return "v4.r0";
    }

    public void setCreatedTime(OffsetDateTime createdTime) {
        if (this.createdTime == null) {
            this.createdTime = createdTime;
        } else {
            log.warn("Read-only property createdTime already contains a non-null value and cannot be set again");
        }
    }

    public void setLastUpdatedTime(OffsetDateTime lastUpdatedTime) {
        if (this.lastUpdatedTime == null) {
            this.lastUpdatedTime = lastUpdatedTime;
        } else {
            log.warn("Read-only property lastUpdatedTime already contains a non-null value and cannot be set again");
        }
    }

    public void setCreatedBy(String createdBy) {
        if (this.createdBy == null) {
            this.createdBy = createdBy;
        } else {
            log.warn("Read-only property createdBy already contains a non-null value and cannot be set again");
        }
    }

    public static CertAuthProviderBuilder CertAuthProviderBuilder() {
        return new CertAuthProviderBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CertAuthProvider)) {
            return false;
        }
        CertAuthProvider other = (CertAuthProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetDateTime this$createdTime = this.getCreatedTime();
        OffsetDateTime other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !((Object)this$createdTime).equals(other$createdTime)) {
            return false;
        }
        OffsetDateTime this$lastUpdatedTime = this.getLastUpdatedTime();
        OffsetDateTime other$lastUpdatedTime = other.getLastUpdatedTime();
        if (this$lastUpdatedTime == null ? other$lastUpdatedTime != null : !((Object)this$lastUpdatedTime).equals(other$lastUpdatedTime)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$clientCaChain = this.getClientCaChain();
        String other$clientCaChain = other.getClientCaChain();
        if (this$clientCaChain == null ? other$clientCaChain != null : !this$clientCaChain.equals(other$clientCaChain)) {
            return false;
        }
        Boolean this$isCertAuthEnabled = this.getIsCertAuthEnabled();
        Boolean other$isCertAuthEnabled = other.getIsCertAuthEnabled();
        if (this$isCertAuthEnabled == null ? other$isCertAuthEnabled != null : !((Object)this$isCertAuthEnabled).equals(other$isCertAuthEnabled)) {
            return false;
        }
        Boolean this$isCacEnabled = this.getIsCacEnabled();
        Boolean other$isCacEnabled = other.getIsCacEnabled();
        if (this$isCacEnabled == null ? other$isCacEnabled != null : !((Object)this$isCacEnabled).equals(other$isCacEnabled)) {
            return false;
        }
        String this$dirSvcExtID = this.getDirSvcExtID();
        String other$dirSvcExtID = other.getDirSvcExtID();
        if (this$dirSvcExtID == null ? other$dirSvcExtID != null : !this$dirSvcExtID.equals(other$dirSvcExtID)) {
            return false;
        }
        String this$caCertFileName = this.getCaCertFileName();
        String other$caCertFileName = other.getCaCertFileName();
        if (this$caCertFileName == null ? other$caCertFileName != null : !this$caCertFileName.equals(other$caCertFileName)) {
            return false;
        }
        CertRevocationInfo this$certRevocationInfo = this.getCertRevocationInfo();
        CertRevocationInfo other$certRevocationInfo = other.getCertRevocationInfo();
        return !(this$certRevocationInfo == null ? other$certRevocationInfo != null : !((Object)this$certRevocationInfo).equals(other$certRevocationInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CertAuthProvider;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OffsetDateTime $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : ((Object)$createdTime).hashCode());
        OffsetDateTime $lastUpdatedTime = this.getLastUpdatedTime();
        result = result * 59 + ($lastUpdatedTime == null ? 43 : ((Object)$lastUpdatedTime).hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $clientCaChain = this.getClientCaChain();
        result = result * 59 + ($clientCaChain == null ? 43 : $clientCaChain.hashCode());
        Boolean $isCertAuthEnabled = this.getIsCertAuthEnabled();
        result = result * 59 + ($isCertAuthEnabled == null ? 43 : ((Object)$isCertAuthEnabled).hashCode());
        Boolean $isCacEnabled = this.getIsCacEnabled();
        result = result * 59 + ($isCacEnabled == null ? 43 : ((Object)$isCacEnabled).hashCode());
        String $dirSvcExtID = this.getDirSvcExtID();
        result = result * 59 + ($dirSvcExtID == null ? 43 : $dirSvcExtID.hashCode());
        String $caCertFileName = this.getCaCertFileName();
        result = result * 59 + ($caCertFileName == null ? 43 : $caCertFileName.hashCode());
        CertRevocationInfo $certRevocationInfo = this.getCertRevocationInfo();
        result = result * 59 + ($certRevocationInfo == null ? 43 : ((Object)$certRevocationInfo).hashCode());
        return result;
    }

    public OffsetDateTime getCreatedTime() {
        return this.createdTime;
    }

    public OffsetDateTime getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getName() {
        return this.name;
    }

    public String getClientCaChain() {
        return this.clientCaChain;
    }

    public Boolean getIsCertAuthEnabled() {
        return this.isCertAuthEnabled;
    }

    public Boolean getIsCacEnabled() {
        return this.isCacEnabled;
    }

    public String getDirSvcExtID() {
        return this.dirSvcExtID;
    }

    public String getCaCertFileName() {
        return this.caCertFileName;
    }

    public CertRevocationInfo getCertRevocationInfo() {
        return this.certRevocationInfo;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="clientCaChain")
    public void setClientCaChain(String clientCaChain) {
        this.clientCaChain = clientCaChain;
    }

    @JsonProperty(value="isCertAuthEnabled")
    public void setIsCertAuthEnabled(Boolean isCertAuthEnabled) {
        this.isCertAuthEnabled = isCertAuthEnabled;
    }

    @JsonProperty(value="isCacEnabled")
    public void setIsCacEnabled(Boolean isCacEnabled) {
        this.isCacEnabled = isCacEnabled;
    }

    @JsonProperty(value="dirSvcExtID")
    public void setDirSvcExtID(String dirSvcExtID) {
        this.dirSvcExtID = dirSvcExtID;
    }

    @JsonProperty(value="caCertFileName")
    public void setCaCertFileName(String caCertFileName) {
        this.caCertFileName = caCertFileName;
    }

    @JsonProperty(value="certRevocationInfo")
    public void setCertRevocationInfo(CertRevocationInfo certRevocationInfo) {
        this.certRevocationInfo = certRevocationInfo;
    }

    @Override
    public String toString() {
        return "CertAuthProvider(createdTime=" + this.getCreatedTime() + ", lastUpdatedTime=" + this.getLastUpdatedTime() + ", createdBy=" + this.getCreatedBy() + ", name=" + this.getName() + ", clientCaChain=" + this.getClientCaChain() + ", isCertAuthEnabled=" + this.getIsCertAuthEnabled() + ", isCacEnabled=" + this.getIsCacEnabled() + ", dirSvcExtID=" + this.getDirSvcExtID() + ", caCertFileName=" + this.getCaCertFileName() + ", certRevocationInfo=" + this.getCertRevocationInfo() + ")";
    }

    public static class CertAuthProviderBuilder {
        private String tenantId;
        private String extId;
        private List<ApiLink> links;
        private String name;
        private String clientCaChain;
        private Boolean isCertAuthEnabled;
        private Boolean isCacEnabled;
        private String dirSvcExtID;
        private String caCertFileName;
        private CertRevocationInfo certRevocationInfo;
        private OffsetDateTime createdTime;
        private OffsetDateTime lastUpdatedTime;
        private String createdBy;

        CertAuthProviderBuilder() {
        }

        public CertAuthProviderBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public CertAuthProviderBuilder extId(String extId) {
            this.extId = extId;
            return this;
        }

        public CertAuthProviderBuilder links(List<ApiLink> links) {
            this.links = links;
            return this;
        }

        public CertAuthProviderBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CertAuthProviderBuilder clientCaChain(String clientCaChain) {
            this.clientCaChain = clientCaChain;
            return this;
        }

        public CertAuthProviderBuilder isCertAuthEnabled(Boolean isCertAuthEnabled) {
            this.isCertAuthEnabled = isCertAuthEnabled;
            return this;
        }

        public CertAuthProviderBuilder isCacEnabled(Boolean isCacEnabled) {
            this.isCacEnabled = isCacEnabled;
            return this;
        }

        public CertAuthProviderBuilder dirSvcExtID(String dirSvcExtID) {
            this.dirSvcExtID = dirSvcExtID;
            return this;
        }

        public CertAuthProviderBuilder caCertFileName(String caCertFileName) {
            this.caCertFileName = caCertFileName;
            return this;
        }

        public CertAuthProviderBuilder certRevocationInfo(CertRevocationInfo certRevocationInfo) {
            this.certRevocationInfo = certRevocationInfo;
            return this;
        }

        public CertAuthProviderBuilder createdTime(OffsetDateTime createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public CertAuthProviderBuilder lastUpdatedTime(OffsetDateTime lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public CertAuthProviderBuilder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public CertAuthProvider build() {
            return new CertAuthProvider(this.tenantId, this.extId, this.links, this.name, this.clientCaChain, this.isCertAuthEnabled, this.isCacEnabled, this.dirSvcExtID, this.caCertFileName, this.certRevocationInfo, this.createdTime, this.lastUpdatedTime, this.createdBy);
        }

        public String toString() {
            return "CertAuthProvider.CertAuthProviderBuilder(tenantId=" + this.tenantId + ", extId=" + this.extId + ", links=" + this.links + ", name=" + this.name + ", clientCaChain=" + this.clientCaChain + ", isCertAuthEnabled=" + this.isCertAuthEnabled + ", isCacEnabled=" + this.isCacEnabled + ", dirSvcExtID=" + this.dirSvcExtID + ", caCertFileName=" + this.caCertFileName + ", certRevocationInfo=" + this.certRevocationInfo + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdBy=" + this.createdBy + ")";
        }
    }
}

