/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry.backoff;

import com.nurkiewicz.asyncretry.RetryContext;
import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.backoff.BackoffWrapper;

public class BoundedMaxBackoff
extends BackoffWrapper {
    public static final long DEFAULT_MAX_DELAY_MILLIS = 10000L;
    private final long maxDelayMillis;

    public BoundedMaxBackoff(Backoff target) {
        this(target, 10000L);
    }

    public BoundedMaxBackoff(Backoff target, long maxDelayMillis) {
        super(target);
        this.maxDelayMillis = maxDelayMillis;
    }

    @Override
    public long delayMillis(RetryContext context) {
        return Math.min(this.target.delayMillis(context), this.maxDelayMillis);
    }
}

