/*
 * Decompiled with CFR 0.152.
 */
package com.nurkiewicz.asyncretry;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.nurkiewicz.asyncretry.AsyncRetryContext;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.RetryJob;
import com.nurkiewicz.asyncretry.function.RetryCallable;

public class AsyncRetryJob<V>
extends RetryJob<V> {
    private final RetryCallable<ListenableFuture<V>> userTask;

    public AsyncRetryJob(RetryCallable<ListenableFuture<V>> userTask, AsyncRetryExecutor parent) {
        this(userTask, parent, new AsyncRetryContext(parent.getRetryPolicy()), SettableFuture.create());
    }

    public AsyncRetryJob(RetryCallable<ListenableFuture<V>> userTask, AsyncRetryExecutor parent, AsyncRetryContext context, SettableFuture<V> future) {
        super(context, parent, future);
        this.userTask = userTask;
    }

    @Override
    public void run(final long startTime) {
        try {
            Futures.addCallback(this.userTask.call(this.context), (FutureCallback)new FutureCallback<V>(){

                public void onSuccess(V result) {
                    AsyncRetryJob.this.complete(result, System.currentTimeMillis() - startTime);
                }

                public void onFailure(Throwable throwable) {
                    AsyncRetryJob.this.handleThrowable(throwable, System.currentTimeMillis() - startTime);
                }
            });
        }
        catch (Throwable t) {
            this.handleThrowable(t, System.currentTimeMillis() - startTime);
        }
    }

    @Override
    protected RetryJob<V> nextTask(AsyncRetryContext nextRetryContext) {
        return new AsyncRetryJob<V>(this.userTask, this.parent, nextRetryContext, this.future);
    }
}

