/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Conversions;
import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.SQLContext;
import com.nuodb.jdbc.Value;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;

public class ValueDate
extends Value {
    java.sql.Date value;

    public ValueDate() {
    }

    public ValueDate(java.sql.Date val) {
        this.value = val;
    }

    public ValueDate(Object val) {
        if (val instanceof java.sql.Date) {
            this.value = (java.sql.Date)val;
        } else if (val instanceof Date) {
            this.value = new java.sql.Date(((Date)val).getTime());
        } else {
            throw new IllegalArgumentException("Unable to convert: " + val.getClass().getName() + " into a Date");
        }
    }

    @Override
    int getType() {
        return 9;
    }

    @Override
    String getString() throws SQLException {
        throw new SQLException("Date requires a TimeZone");
    }

    @Override
    String getString(SQLContext context) {
        return ValueDate.getDateFormatter(context.getTimeZone()).format(Instant.ofEpochMilli(this.value.getTime()));
    }

    @Override
    Timestamp getTimestamp() throws SQLException {
        return this.getTimestamp(null);
    }

    @Override
    Timestamp getTimestamp(SQLContext context) throws SQLException {
        return new Timestamp(this.value.getTime());
    }

    @Override
    java.sql.Date getDate() {
        return this.value;
    }

    @Override
    java.sql.Date getDate(SQLContext context) throws SQLException {
        return this.getDate();
    }

    @Override
    Object getObject() {
        return this.getDate();
    }

    @Override
    void encodeValue(EncodedDataStream dataStream) throws SQLException {
        dataStream.encodeDate(this.value);
    }

    @Override
    public byte[] getBytes() {
        return Conversions.toBytes(this.value.getTime());
    }
}

