/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.EncodedDataStream;
import com.nuodb.jdbc.Utils;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;

public class RemParameterMetaData
implements ParameterMetaData {
    private Parameter[] parameters;

    public RemParameterMetaData(EncodedDataStream dataStream) throws SQLException {
        int count = dataStream.getInt();
        if (count > 0) {
            this.parameters = new Parameter[count];
            for (int i = 0; i < count; ++i) {
                this.parameters[i] = new Parameter();
                this.parameters[i].isNullable = dataStream.getInt() == 0 ? 0 : 1;
                this.parameters[i].scale = dataStream.getInt();
                this.parameters[i].precision = dataStream.getInt();
                this.parameters[i].jdbcType = dataStream.getInt();
            }
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameters != null ? this.parameters.length : 0;
    }

    @Override
    public int isNullable(int i) throws SQLException {
        return this.getParameter((int)i).isNullable;
    }

    @Override
    public boolean isSigned(int i) throws SQLException {
        return this.getParameter((int)i).isSigned;
    }

    @Override
    public int getPrecision(int i) throws SQLException {
        return this.getParameter((int)i).precision;
    }

    @Override
    public int getScale(int i) throws SQLException {
        return this.getParameter((int)i).scale;
    }

    @Override
    public int getParameterType(int i) throws SQLException {
        return this.getParameter((int)i).jdbcType;
    }

    @Override
    public String getParameterTypeName(int i) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public String getParameterClassName(int i) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public int getParameterMode(int i) throws SQLException {
        Utils.notYetImplemented();
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> aClass) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> aClass) throws SQLException {
        Utils.notYetImplemented();
        return false;
    }

    private Parameter getParameter(int pos) throws SQLException {
        if (pos < 1 || this.parameters == null || pos > this.parameters.length) {
            throw new SQLException(MessageFormat.format("Parameter index {0} is out of bounds. Valid range 1-{1}", pos, this.getParameterCount()));
        }
        return this.parameters[pos - 1];
    }

    class Parameter {
        int isNullable;
        boolean isSigned = true;
        int precision;
        int scale;
        int jdbcType;

        Parameter() {
        }
    }
}

