/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.RemEncodedStream;
import com.nuodb.jdbc.RemPreparedStatement;
import com.nuodb.jdbc.TypeInfo;
import com.nuodb.jdbc.Utils;
import com.nuodb.jdbc.Value;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class RemCallableStatement
extends RemPreparedStatement
implements CallableStatement {
    boolean isLastParamNull = false;
    Map<Integer, OutParameter> outParameters;
    Map<Integer, TypeInfo> typeInfos;
    ParameterDeclaration[] parameterDeclaration;

    RemCallableStatement(RemConnection connect, int statementHandle, int parameterCount) {
        super(connect, statementHandle, parameterCount, false);
        this.parameterDeclaration = new ParameterDeclaration[parameterCount];
    }

    void declareParameter(int parameterIndex, int direction, String name) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.numberParameters) {
            throw new SQLException("invalid parameter index (" + String.valueOf(parameterIndex) + ")");
        }
        this.parameterDeclaration[parameterIndex - 1] = new ParameterDeclaration(direction, name);
    }

    int findParameterByName(String name) throws SQLException {
        for (int i = 0; i < this.parameterDeclaration.length; ++i) {
            if (this.parameterDeclaration[i] == null || !this.parameterDeclaration[i].name.equalsIgnoreCase(name)) continue;
            return i + 1;
        }
        throw new SQLException(String.format("cannot find parameter named '%s'", name));
    }

    @Override
    public boolean execute() throws SQLException {
        int[] directions = new int[this.parameterDeclaration.length];
        for (int i = 0; i < this.parameterDeclaration.length; ++i) {
            if (!(this.parameterDeclaration[i].direction == 0 || this.outParameters != null && this.outParameters.containsKey(i + 1))) {
                throw new SQLException("Parameter " + String.valueOf(i + 1) + " is an OUT parameter but registerOutParameter hasn't been called");
            }
            directions[i] = this.parameterDeclaration[i].direction;
        }
        this.lastResultSet = null;
        RemEncodedStream dataStream = new RemEncodedStream(this.connection.protocolVersion);
        dataStream.startMessage(104);
        this.encodeLastTxnIds(dataStream);
        dataStream.encodeInt(this.handle);
        this.putParameters(dataStream, directions);
        if (this.outParameters == null) {
            dataStream.encodeInt(0);
        } else {
            dataStream.encodeInt(this.outParameters.size());
            for (Map.Entry<Integer, OutParameter> entry : this.outParameters.entrySet()) {
                dataStream.encodeOutParameter(entry.getKey() - 1, entry.getValue());
            }
        }
        this.connection.sendAndReceive(dataStream);
        boolean ret = dataStream.getInt() != 0;
        this.updateRecordsUpdated(dataStream);
        this.updateTimeZone(dataStream);
        this.updateLastCommitInfo(dataStream, this.generatingKeys);
        int outValues = dataStream.getInt();
        for (int i = 0; i < outValues; ++i) {
            int index = dataStream.getInt() + 1;
            if (index < 1 || index > this.numberParameters) {
                throw new SQLException("invalid parameter index (" + String.valueOf(index) + ")");
            }
            this.parameters[index - 1] = dataStream.getValue();
        }
        return ret;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.execute();
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.execute();
        return this.getUpdateCount();
    }

    @Override
    public void clearParameters() throws SQLException {
        super.clearParameters();
        this.outParameters = null;
        this.typeInfos = null;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType, -1);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.numberParameters) {
            throw new SQLException("invalid parameter index (" + String.valueOf(parameterIndex) + ")");
        }
        ParameterDeclaration decl = this.parameterDeclaration[parameterIndex - 1];
        if (decl == null || decl.direction == 0) {
            throw new SQLException("parameter " + String.valueOf(parameterIndex) + " is not an OUT parameter");
        }
        if (this.outParameters == null) {
            this.outParameters = new HashMap<Integer, OutParameter>();
        }
        if (this.typeInfos == null) {
            this.typeInfos = new HashMap<Integer, TypeInfo>();
        }
        OutParameter paramMapping = new OutParameter();
        paramMapping.type = sqlType;
        paramMapping.scale = -1;
        this.outParameters.put(parameterIndex, paramMapping);
        this.typeInfos.put(parameterIndex, new TypeInfo(sqlType, scale));
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.isLastParamNull;
    }

    Value getValue(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.numberParameters) {
            throw new SQLException("invalid parameter index (" + String.valueOf(parameterIndex) + ")");
        }
        return this.parameters[parameterIndex - 1];
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getString();
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return false;
        }
        return value.getBoolean();
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return 0;
        }
        return value.getByte();
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return 0;
        }
        return value.getShort();
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return 0;
        }
        return value.getInt();
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return 0L;
        }
        return value.getLong();
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return 0.0f;
        }
        return value.getFloat();
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return 0.0;
        }
        return value.getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return BigDecimal.ZERO;
        }
        BigDecimal decimal = value.getBigDecimal();
        decimal.setScale(scale);
        return decimal;
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getBytes(this.connection.getSQLContext());
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getDate(this.connection.getSQLContext());
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getTime(this.connection.getSQLContext());
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getTimestamp(this.connection.getSQLContext());
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        TypeInfo typeInfo = this.typeInfos.get(parameterIndex);
        return value.getObject(typeInfo, this.connection.getSQLContext());
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        try {
            return type.getDeclaredConstructor(String.class).newInstance(value.getString(this.connection.getSQLContext()));
        }
        catch (Exception e) {
            throw new SQLException("cannot convert value to requested class " + type, e);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return BigDecimal.ZERO;
        }
        return value.getBigDecimal();
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getBlob(this.connection.getSQLContext());
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getClob(this.connection.getSQLContext());
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        Utils.notYetImplemented();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registerOutParameter(this.findParameterByName(parameterName), sqlType);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(this.findParameterByName(parameterName), sqlType, scale);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(this.findParameterByName(parameterName), sqlType, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        this.setURL(this.findParameterByName(parameterName), val);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setNull(this.findParameterByName(parameterName), sqlType);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.setBoolean(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.setByte(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.setShort(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.setInt(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.setLong(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.setFloat(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.setDouble(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.setBigDecimal(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.setString(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.setBytes(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.setDate(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.setTime(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.setTimestamp(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setAsciiStream(this.findParameterByName(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.setBinaryStream(this.findParameterByName(parameterName), x, length);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.setObject(this.findParameterByName(parameterName), x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.setObject(this.findParameterByName(parameterName), x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.setObject(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.setCharacterStream(this.findParameterByName(parameterName), reader, length);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.setDate(this.findParameterByName(parameterName), x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.setTime(this.findParameterByName(parameterName), x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(this.findParameterByName(parameterName), x, cal);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(this.findParameterByName(parameterName), sqlType, typeName);
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        return this.getString(this.findParameterByName(parameterName));
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        return this.getBoolean(this.findParameterByName(parameterName));
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        return this.getByte(this.findParameterByName(parameterName));
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        return this.getShort(this.findParameterByName(parameterName));
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        return this.getInt(this.findParameterByName(parameterName));
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        return this.getLong(this.findParameterByName(parameterName));
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        return this.getFloat(this.findParameterByName(parameterName));
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        return this.getDouble(this.findParameterByName(parameterName));
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        return this.getBytes(this.findParameterByName(parameterName));
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        return this.getDate(this.findParameterByName(parameterName));
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        return this.getTime(this.findParameterByName(parameterName));
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this.getTimestamp(this.findParameterByName(parameterName));
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        return this.getObject(this.findParameterByName(parameterName));
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        return this.getObject(this.findParameterByName(parameterName), type);
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this.getBigDecimal(this.findParameterByName(parameterName));
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findParameterByName(parameterName), map);
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        return this.getRef(this.findParameterByName(parameterName));
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        return this.getBlob(this.findParameterByName(parameterName));
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        return this.getClob(this.findParameterByName(parameterName));
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        return this.getArray(this.findParameterByName(parameterName));
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this.getDate(this.findParameterByName(parameterName), cal);
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this.getTime(this.findParameterByName(parameterName), cal);
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findParameterByName(parameterName), cal);
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        return this.getURL(this.findParameterByName(parameterName));
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        return this.getRowId(this.findParameterByName(parameterName));
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.setRowId(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.setNString(this.findParameterByName(parameterName), value);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.setNCharacterStream(this.findParameterByName(parameterName), value, length);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.setNClob(this.findParameterByName(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setClob(this.findParameterByName(parameterName), reader, length);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.setBlob(this.findParameterByName(parameterName), inputStream, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.setNClob(this.findParameterByName(parameterName), reader, length);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        return this.getNClob(this.findParameterByName(parameterName));
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setSQLXML(this.findParameterByName(parameterName), xmlObject);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        return this.getSQLXML(this.findParameterByName(parameterName));
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        return this.getNString(this.findParameterByName(parameterName));
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        Utils.notYetImplemented();
        return null;
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getNCharacterStream(this.findParameterByName(parameterName));
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        Value value = this.getValue(parameterIndex);
        boolean bl = this.isLastParamNull = value == null || value.getType() == 0;
        if (this.isLastParamNull) {
            return null;
        }
        return value.getCharacterStream(this.connection.getSQLContext());
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(this.findParameterByName(parameterName));
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.setBlob(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.setClob(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setAsciiStream(this.findParameterByName(parameterName), x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        this.setBinaryStream(this.findParameterByName(parameterName), x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(this.findParameterByName(parameterName), reader, length);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.setAsciiStream(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.setBinaryStream(this.findParameterByName(parameterName), x);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(this.findParameterByName(parameterName), reader);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.setNCharacterStream(this.findParameterByName(parameterName), value);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.setClob(this.findParameterByName(parameterName), reader);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.setBlob(this.findParameterByName(parameterName), inputStream);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.setNClob(this.findParameterByName(parameterName), reader);
    }

    private class ParameterDeclaration {
        int direction;
        String name;

        public ParameterDeclaration(int direction, String name) {
            this.direction = direction;
            this.name = name;
        }
    }

    class OutParameter {
        int type;
        int scale;

        OutParameter() {
        }
    }
}

