/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.impl.concurrent.NamedThreadFactory;
import com.nuodb.jdbc.Connection;
import com.nuodb.jdbc.ConnectionUrl;
import com.nuodb.jdbc.Host;
import com.nuodb.jdbc.RemConnection;
import com.nuodb.jdbc.SQLState;
import com.nuodb.jdbc.logger.Logger;
import com.nuodb.jdbc.logger.LoggerException;
import com.nuodb.jdbc.logger.LoggerManager;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLTransientConnectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Driver
implements java.sql.Driver {
    public static final String USER_PROPERTY = "user";
    public static final String PASSWORD_PROPERTY = "password";
    public static final String SCHEMA_PROPERTY = "schema";
    public static final String DIRECT_PROPERTY = "direct";
    public static final String ISOLATION_PROPERTY = "isolation";
    public static final String TIMEZONE_PROPERTY = "TimeZone";
    public static final String SQLENGINE_PROPERTY = "SQLEngine";
    static final String PREFIX = "jdbc:com.nuodb:";
    public static final String URLDELIMITER_PROPERTY = "url-delimiter";

    protected String getPrefix() {
        return PREFIX;
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(this.getPrefix());
    }

    @Override
    public Connection connect(String url, Properties properties) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        return this.connect(this.getConnectionUrl(url, properties), null);
    }

    protected Connection connect(ConnectionUrl connectionUrl, RemConnection.ErrorHandler errorHandler) throws SQLException {
        return this.connect(connectionUrl, errorHandler, this.getLogger(connectionUrl.getProperties()));
    }

    protected Connection connect(ConnectionUrl connectionUrl, RemConnection.ErrorHandler errorHandler, Logger logger) throws SQLException {
        ExecutorService executor = Executors.newFixedThreadPool(1, new NamedThreadFactory("jdbc-driver"));
        ConnectCallable connectCallable = new ConnectCallable(connectionUrl, errorHandler, logger);
        try {
            FutureTask<Connection> connect = new FutureTask<Connection>(connectCallable);
            executor.execute(connect);
            int timeout = DriverManager.getLoginTimeout();
            timeout = timeout == 0 ? Integer.MAX_VALUE : timeout;
            Connection connection = connect.get(timeout, TimeUnit.SECONDS);
            return connection;
        }
        catch (InterruptedException exception) {
            executor.shutdownNow();
            connectCallable.cancel();
            Thread.currentThread().interrupt();
            throw new SQLNonTransientConnectionException(exception);
        }
        catch (ExecutionException exception) {
            Throwable cause = exception.getCause();
            String message = cause.getMessage();
            if (message == null) {
                message = cause.toString();
            }
            String state = SQLState.COMMUNICATION_LINK_ERROR.getState();
            if (cause instanceof SQLTransientConnectionException) {
                throw new SQLTransientConnectionException(message, state);
            }
            throw new SQLNonTransientConnectionException(message, state);
        }
        catch (TimeoutException exception) {
            executor.shutdownNow();
            connectCallable.cancel();
            throw new SQLNonTransientConnectionException(exception);
        }
        finally {
            if (!executor.isShutdown()) {
                executor.shutdownNow();
            }
        }
    }

    protected ConnectionUrl getConnectionUrl(String url, Properties properties) {
        return new ConnectionUrl(this.getPrefix(), url, properties);
    }

    protected Logger getLogger(Properties properties) throws SQLException {
        Logger logger;
        try {
            logger = LoggerManager.getLoggerManager(properties).getLoggerFactory().getLogger();
        }
        catch (LoggerException exception) {
            throw new SQLException(exception);
        }
        return logger;
    }

    protected void connect(RemConnection connection, ConnectionUrl connectionUrl, Host host, Logger logger, RemConnection.ErrorHandler errorHandler) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Attempting to connect to %s host", host));
        }
        try {
            connection.openDatabase(host.getHost(), host.getPort(), connectionUrl.getDatabase(), connectionUrl.getProperties(), connectionUrl.getUrl(host));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Connected to %s host", host));
            }
        }
        catch (SQLException exception) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Connection to %s host failed", host), exception);
            }
            throw exception;
        }
    }

    protected RemConnection getConnection(RemConnection.ErrorHandler errorHandler, Logger logger) {
        return new RemConnection(errorHandler, logger);
    }

    @Override
    public int getMajorVersion() {
        return 24;
    }

    @Override
    public int getMinorVersion() {
        return 2;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties properties = this.getConnectionUrl(url, info).getProperties();
        DriverPropertyInfo userInfo = new DriverPropertyInfo(USER_PROPERTY, properties.getProperty(USER_PROPERTY));
        userInfo.description = "The user name to authenticate with.";
        userInfo.required = true;
        DriverPropertyInfo passwordInfo = new DriverPropertyInfo(PASSWORD_PROPERTY, properties.getProperty(PASSWORD_PROPERTY));
        passwordInfo.description = "The user's password.";
        passwordInfo.required = true;
        DriverPropertyInfo schemaInfo = new DriverPropertyInfo(SCHEMA_PROPERTY, properties.getProperty(SCHEMA_PROPERTY));
        schemaInfo.description = "The default schema name to use on calls to the database.";
        DriverPropertyInfo isolationInfo = new DriverPropertyInfo(ISOLATION_PROPERTY, properties.getProperty(ISOLATION_PROPERTY));
        isolationInfo.description = "The default transaction isolation level for the connection to use.";
        isolationInfo.required = false;
        DriverPropertyInfo timezoneInfo = new DriverPropertyInfo(TIMEZONE_PROPERTY, properties.getProperty(TIMEZONE_PROPERTY));
        timezoneInfo.description = "The default time zone for the connection to use (aka the session time zone).";
        timezoneInfo.required = false;
        DriverPropertyInfo sqlEngineInfo = new DriverPropertyInfo(SQLENGINE_PROPERTY, properties.getProperty(SQLENGINE_PROPERTY));
        sqlEngineInfo.description = "The SQL engine for the connection to use.";
        sqlEngineInfo.required = false;
        return new DriverPropertyInfo[]{userInfo, passwordInfo, schemaInfo, isolationInfo, timezoneInfo};
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return LoggerManager.getParentLogger();
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException exception) {
            System.out.println("Error in com.nuodb.jdbc.Driver static initializer: " + exception);
        }
    }

    class ConnectCallable
    implements Callable<Connection> {
        private ConnectionUrl connectionUrl;
        private RemConnection.ErrorHandler errorHandler;
        private Logger logger;
        private RemConnection connection;

        public ConnectCallable(ConnectionUrl connectionUrl, RemConnection.ErrorHandler errorHandler, Logger logger) {
            this.connectionUrl = connectionUrl;
            this.errorHandler = errorHandler;
            this.logger = logger;
        }

        public void cancel() {
            if (this.connection != null) {
                this.connection.closeSocket();
            }
        }

        @Override
        public Connection call() throws Exception {
            Collection<Host> hosts = this.connectionUrl.getHosts();
            if (hosts == null || hosts.isEmpty()) {
                throw new SQLException("Invalid database connection string: broker missing");
            }
            String database = this.connectionUrl.getDatabase();
            if (database == null) {
                throw new SQLException("Invalid database connection string: database name missing");
            }
            ArrayList<String> messages = new ArrayList<String>();
            for (Host host : hosts) {
                try {
                    this.connection = Driver.this.getConnection(this.errorHandler, this.logger);
                    Driver.this.connect(this.connection, this.connectionUrl, host, this.logger, this.errorHandler);
                    return this.connection;
                }
                catch (SQLTransientConnectionException exception) {
                    throw exception;
                }
                catch (SQLException exception) {
                    messages.add(exception.getMessage());
                }
            }
            throw new SQLException(String.format("Could not connect to any host %s. Errors are %s", hosts, messages));
        }
    }
}

