/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.jdbc;

import com.nuodb.jdbc.Host;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class ConnectionUrl {
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private Properties properties = new Properties();
    private Collection<Host> hosts = new ArrayList<Host>();
    private String database;
    private String prefix;
    public static final String DEFAULT_URLDELIMITER = ",";

    public ConnectionUrl(String prefix, String url, Properties overrides) {
        this.prefix = prefix;
        int p1 = url.indexOf("://") + 3;
        String addresses = null;
        if (p1 > 0) {
            int p2 = url.indexOf(47, p1);
            int p3 = url.indexOf(63, p1);
            if (p2 > 0) {
                addresses = url.substring(p1, p2);
                this.database = url.substring(p2 + 1, p3 > 0 ? p3 : url.length());
            } else {
                p2 = url.indexOf(64, p1);
                if (p2 > 0) {
                    this.database = url.substring(p1, p2);
                    addresses = url.substring(p2 + 1, p3 > 0 ? p3 : url.length());
                }
            }
            if (p3 > 0) {
                String parameterList = url.substring(p3 + 1);
                for (String parameter : parameterList.split("&")) {
                    String value;
                    String[] parameterPair = parameter.split("=");
                    if (parameterPair.length != 2) continue;
                    try {
                        value = URLDecoder.decode(parameterPair[1], StandardCharsets.UTF_8.name());
                    }
                    catch (UnsupportedEncodingException e) {
                        value = parameterPair[1];
                    }
                    this.parameters.put(parameterPair[0], value);
                }
            }
        }
        if (addresses != null) {
            String delimiter = overrides.getProperty("url-delimiter", DEFAULT_URLDELIMITER);
            for (String address : addresses.split(Pattern.quote(delimiter))) {
                this.hosts.add(new Host(address));
            }
        }
        this.properties.putAll(this.parameters);
        if (overrides != null) {
            this.properties.putAll((Map<?, ?>)overrides);
        }
    }

    public String getUrl() {
        return this.getUrl(this.hosts);
    }

    public String getUrl(Host host) {
        return this.getUrl(Collections.singleton(host));
    }

    public String getUrl(Collection<Host> hosts) {
        StringBuilder url = new StringBuilder();
        url.append(this.prefix);
        url.append("//");
        boolean hasBrokers = false;
        for (Host host : hosts) {
            if (hasBrokers) {
                url.append(',');
            }
            url.append(host);
            hasBrokers = true;
        }
        url.append('/');
        if (this.database != null) {
            url.append(this.database);
        }
        if (!this.parameters.isEmpty()) {
            url.append('?');
            boolean hasParameters = false;
            for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
                if (hasParameters) {
                    url.append('&');
                }
                url.append(parameter.getKey());
                url.append('=');
                url.append(parameter.getValue());
                hasParameters = true;
            }
        }
        return url.toString();
    }

    public Collection<Host> getHosts() {
        return this.hosts;
    }

    public String getDatabase() {
        return this.database;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getUrl();
    }
}

