/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.xml;

import com.nuodb.impl.util.Preconditions;
import com.nuodb.impl.util.StringUtils;
import com.nuodb.impl.xml.Doc;
import com.nuodb.xml.Attribute;
import com.nuodb.xml.XmlException;

class AttributeImpl
implements Attribute {
    AttributeImpl sibling;
    String name;
    String value;

    public AttributeImpl(String attributeName, String attributeValue) {
        Preconditions.checkArgument(!StringUtils.isBlank(attributeName), "blank attribute name");
        this.name = attributeName;
        this.setValue(attributeValue);
    }

    public AttributeImpl(Attribute attribute) {
        this(attribute.getName(), attribute.getValue());
    }

    public AttributeImpl(Doc doc) throws XmlException {
        this.parse(doc);
    }

    public void parse(Doc doc) throws XmlException {
        this.name = doc.getToken();
        if (doc.match('=')) {
            this.setValue(doc.getToken());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String v) {
        Preconditions.checkArgument(v != null, "null value for attribute: " + this.name);
        this.value = v;
    }

    @Override
    public void print() {
        System.out.print(" " + this.name + "=\"" + this.value + "\"");
    }

    public void gen(StringBuilder buffer) {
        buffer.append(this.name);
        buffer.append("=\"");
        buffer.append(this.value);
        buffer.append("\"");
    }
}

