/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.util.regex.Pattern;

public class StackFrameInfo {
    public static final String SHORT = "short";
    public static final String LONG = "long";
    public static final String SHORT_FORMAT = "{className}.{methodName}()";
    public static final String LONG_FORMAT = "{className}.{methodName}({shortClassName}:{lineNumber})";
    private static final String CLASS_NAME = Pattern.quote("{className}");
    private static final String METHOD_NAME = Pattern.quote("{methodName}");
    private static final String SHORT_CLASS_NAME = Pattern.quote("{shortClassName}");
    private static final String LINE_NUMBER = Pattern.quote("{lineNumber}");
    private String format;
    private String className;
    private String shortClassName;
    private String methodName;
    private int lineNumber;
    private String classNameEscaped;
    private String shortClassNameEscaped;
    private String methodNameEscaped;

    public StackFrameInfo(int index) {
        this(index, null);
    }

    public StackFrameInfo(int index, String format) {
        this.init(new Exception().getStackTrace()[index]);
        this.format = format == null ? LONG_FORMAT : format;
    }

    public StackFrameInfo(String callerClassName) {
        this(callerClassName, null);
    }

    public StackFrameInfo(String callerClassName, String format) {
        StackTraceElement result = null;
        StackTraceElement[] elements = new Exception().getStackTrace();
        for (int i = elements.length - 1; i >= 0; --i) {
            int caller;
            StackTraceElement element = elements[i];
            if (!element.getClassName().equals(callerClassName) || (caller = i + 1) >= elements.length) continue;
            result = elements[caller];
            break;
        }
        this.init(result);
        this.format = format == null ? LONG_FORMAT : format;
    }

    private void init(StackTraceElement element) {
        this.className = element.getClassName();
        this.classNameEscaped = StackFrameInfo.escape(this.className);
        int index = this.className.lastIndexOf(".");
        this.shortClassName = index != -1 ? this.className.substring(index + 1) : this.className;
        this.shortClassNameEscaped = StackFrameInfo.escape(this.className);
        this.methodName = element.getMethodName();
        this.methodNameEscaped = StackFrameInfo.escape(this.methodName);
        this.lineNumber = element.getLineNumber();
    }

    private static String escape(String input) {
        return input.replaceAll("\\$", "\\\\\\$");
    }

    public String getClassName() {
        return this.className;
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFormat() {
        return this.format;
    }

    public String format() {
        return this.format(this.format);
    }

    public String format(String format) {
        if (SHORT.equals(format)) {
            format = SHORT_FORMAT;
        } else if (LONG.equals(format)) {
            format = LONG_FORMAT;
        }
        String result = format.replaceAll(CLASS_NAME, this.classNameEscaped);
        result = result.replaceAll(METHOD_NAME, this.methodNameEscaped);
        result = result.replaceAll(SHORT_CLASS_NAME, this.shortClassNameEscaped);
        result = result.replaceAll(LINE_NUMBER, Integer.toString(this.lineNumber));
        return result;
    }

    public String toString() {
        return this.format();
    }
}

