/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class NuoLogFormatter
extends Formatter {
    static final DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final String lineSeparator = System.lineSeparator();

    @Override
    public String format(LogRecord record) {
        int pos;
        StringBuffer sb = new StringBuffer();
        sb.append(this.prefix());
        sb.append(" ");
        sb.append(record.getLevel().getLocalizedName());
        sb.append(" ");
        String name = record.getSourceClassName();
        if (name == null) {
            name = record.getLoggerName();
        } else if (name.contains(".") && (pos = name.lastIndexOf(".")) > 0) {
            name = name.substring(pos + 1, name.length());
        }
        sb.append(name);
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
        }
        sb.append(" (").append(Thread.currentThread().getName()).append(")");
        sb.append(" ");
        sb.append(this.formatMessage(record));
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    public String prefix() {
        return NuoLogFormatter.now();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String now() {
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            return df.format(new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatDate(long millis) {
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            return df.format(millis);
        }
    }
}

