/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.descriptions;

import com.nuodb.descriptions.Template;
import com.nuodb.impl.util.Preconditions;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;

public class TemplateImpl
implements Template {
    public static final String TEMPLATE_TAG_NAME = "Template";
    public static final String TEMPLATE_NAME_ATTR_NAME = "TemplateName";
    public static final String VERSION_ATTR_NAME = "Version";
    public static final String SUMMARY_TAG_NAME = "Summary";
    public static final String OPTIONS_TAG_NAME = "Options";
    public static final String REQUIREMENTS_TAG_NAME = "Requirements";
    private final String name;
    private final int version;
    private final String summary;
    private final String options;
    private final String requirements;

    public static Template getUnmanagedTemplate() {
        return new TemplateImpl("UnmanagedTemplate", -1, "", "{}", "[]");
    }

    public static Template decode(Tag templateTag) throws XmlException {
        return new TemplateTagDecoder(templateTag).decode();
    }

    public static Tag encode(Template template) {
        Tag templateTag = TagFactory.createTag(TEMPLATE_TAG_NAME);
        templateTag.addAttribute(TEMPLATE_NAME_ATTR_NAME, template.getName());
        if (template.getVersion() != -1) {
            templateTag.addAttribute(VERSION_ATTR_NAME, template.getVersion());
        }
        if (template.getSummary() != null) {
            templateTag.addChild(SUMMARY_TAG_NAME).setText(template.getSummary());
        }
        if (template.getOptions() != null) {
            templateTag.addChild(OPTIONS_TAG_NAME).setText(template.getOptions());
        }
        if (template.getRequirements() != null) {
            templateTag.addChild(REQUIREMENTS_TAG_NAME).setText(template.getRequirements());
        }
        return templateTag;
    }

    public TemplateImpl(String name, int version, String summary, String options, String requirements) {
        this.name = name;
        this.version = version;
        this.summary = summary;
        this.options = options;
        this.requirements = requirements;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getSummary() {
        return this.summary;
    }

    @Override
    public String getOptions() {
        return this.options;
    }

    @Override
    public String getRequirements() {
        return this.requirements;
    }

    public String toString() {
        return String.format("Template[name=%s, version=%s, summary=%s, options=%s, requirements=%s]", this.name, this.version, this.summary, this.options, this.requirements);
    }

    public static class TemplateTagDecoder {
        private final Tag template;

        public TemplateTagDecoder(Tag templateTag) {
            this(templateTag, false);
        }

        public TemplateTagDecoder(Tag templateTag, boolean checkName) {
            Preconditions.checkArgument(!checkName || templateTag.isNamed(TemplateImpl.TEMPLATE_TAG_NAME), "Invalid template tag: " + templateTag);
            this.template = templateTag;
        }

        public Template decode() throws XmlException {
            return new TemplateImpl(this.getName(), this.getVersion(), this.getSummary(), this.getOptions(), this.getRequirements());
        }

        public String getName() throws XmlException {
            return this.template.getAttribute(TemplateImpl.TEMPLATE_NAME_ATTR_NAME);
        }

        public int getVersion() {
            return this.template.getIntAttribute(TemplateImpl.VERSION_ATTR_NAME, -1);
        }

        public String getSummary() {
            return TemplateTagDecoder.getChildText(this.template, TemplateImpl.SUMMARY_TAG_NAME);
        }

        public String getOptions() {
            return TemplateTagDecoder.getChildText(this.template, TemplateImpl.OPTIONS_TAG_NAME);
        }

        public String getRequirements() {
            return TemplateTagDecoder.getChildText(this.template, TemplateImpl.REQUIREMENTS_TAG_NAME);
        }

        private static String getChildText(Tag tag, String tagName) {
            Tag child = tag.findChild(tagName);
            return child.getText();
        }
    }
}

