/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.descriptions;

import com.nuodb.descriptions.ArchiveJournalDirs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DescriptionArchives {
    private final ConcurrentMap<PeerAndReqKey, ArchiveJournalDirs> archives = new ConcurrentHashMap<PeerAndReqKey, ArchiveJournalDirs>();

    public DescriptionArchives() {
    }

    public DescriptionArchives(DescriptionArchives other) {
        this.putAll(other);
    }

    private DescriptionArchives(Map<PeerAndReqKey, ArchiveJournalDirs> archives) {
        this.archives.putAll(archives);
    }

    public ArchiveJournalDirs getArchive(String stableId, String reqGroupName) {
        return (ArchiveJournalDirs)this.archives.get(new PeerAndReqKey(stableId, reqGroupName));
    }

    public Map<PeerAndReqKey, ArchiveJournalDirs> getArchives(String stableId) {
        HashMap<PeerAndReqKey, ArchiveJournalDirs> result = new HashMap<PeerAndReqKey, ArchiveJournalDirs>();
        for (Map.Entry elem : this.archives.entrySet()) {
            if (!((PeerAndReqKey)elem.getKey()).getStableId().equals(stableId)) continue;
            result.put((PeerAndReqKey)elem.getKey(), (ArchiveJournalDirs)elem.getValue());
        }
        return result;
    }

    public Map<PeerAndReqKey, ArchiveJournalDirs> getAllArchives() {
        return this.archives;
    }

    public Map<String, ArchiveJournalDirs> getArchivesOld() {
        ConcurrentHashMap<String, ArchiveJournalDirs> result = new ConcurrentHashMap<String, ArchiveJournalDirs>();
        for (Map.Entry elem : this.archives.entrySet()) {
            result.putIfAbsent(((PeerAndReqKey)elem.getKey()).stableId, (ArchiveJournalDirs)elem.getValue());
        }
        return result;
    }

    public Map<String, Map<String, ArchiveJournalDirs>> getAsMapOfMaps() {
        HashMap<String, Map<String, ArchiveJournalDirs>> result = new HashMap<String, Map<String, ArchiveJournalDirs>>();
        for (Map.Entry elem : this.archives.entrySet()) {
            String stableId = ((PeerAndReqKey)elem.getKey()).getStableId();
            if (result.get(stableId) == null) {
                result.put(stableId, new HashMap());
            }
            ((Map)result.get(stableId)).put(((PeerAndReqKey)elem.getKey()).getReqGroup(), (ArchiveJournalDirs)elem.getValue());
        }
        return result;
    }

    public Set<PeerAndReqKey> keySet() {
        return this.archives.keySet();
    }

    public Set<Map.Entry<PeerAndReqKey, ArchiveJournalDirs>> entrySet() {
        return this.archives.entrySet();
    }

    public int size() {
        return this.archives.size();
    }

    public void clear() {
        this.archives.clear();
    }

    public void putAll(DescriptionArchives other) {
        this.archives.putAll(other.getAllArchives());
    }

    public ArchiveJournalDirs get(String stableId, String group) {
        return (ArchiveJournalDirs)this.archives.get(new PeerAndReqKey(stableId, group));
    }

    public boolean containsKey(PeerAndReqKey peerGroupKey) {
        return this.archives.containsKey(peerGroupKey);
    }

    public boolean containsKey(String stableId, String reqName) {
        return this.containsKey(new PeerAndReqKey(stableId, reqName));
    }

    public boolean containsKeyValue(PeerAndReqKey key, ArchiveJournalDirs dirs) {
        return this.archives.containsKey(key) && ((ArchiveJournalDirs)this.archives.get(key)).equals(dirs);
    }

    public boolean containsStableId(String stableId) {
        for (PeerAndReqKey key : this.archives.keySet()) {
            if (!key.getStableId().equals(stableId)) continue;
            return true;
        }
        return false;
    }

    public boolean findArchive(String stableId, String path, String reqName) {
        for (Map.Entry elem : this.archives.entrySet()) {
            ArchiveJournalDirs dirs;
            if (!((PeerAndReqKey)elem.getKey()).getStableId().equals(stableId) || (dirs = (ArchiveJournalDirs)elem.getValue()) == null || reqName != null && !reqName.equals(dirs.getRequirementsName()) || !dirs.getArchiveDir().equals(path)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.archives.isEmpty();
    }

    public void put(String stableId, String group, ArchiveJournalDirs dirs) {
        this.archives.put(new PeerAndReqKey(stableId, group), dirs);
    }

    public ArchiveJournalDirs putIfAbsent(String stableId, ArchiveJournalDirs dirs) {
        PeerAndReqKey newKey = new PeerAndReqKey(stableId, dirs.getRequirementsName());
        ArchiveJournalDirs existing = this.archives.putIfAbsent(newKey, dirs);
        for (Map.Entry<PeerAndReqKey, ArchiveJournalDirs> elem : this.getArchives(stableId).entrySet()) {
            if (!elem.getValue().getArchiveDir().equals(dirs.getArchiveDir()) && !elem.getValue().getJournalDir().equals(dirs.getJournalDir()) || newKey.equals(elem.getKey())) continue;
            throw new IllegalArgumentException(String.format("new archive [%s] collides with existing [%s]", dirs, elem.getValue()));
        }
        return existing;
    }

    public void remove(PeerAndReqKey key) {
        this.archives.remove(key);
    }

    public ArchiveJournalDirs removeArchive(String stableId, String group) {
        return (ArchiveJournalDirs)this.archives.remove(new PeerAndReqKey(stableId, group));
    }

    public Map<PeerAndReqKey, ArchiveJournalDirs> removeArchives(String stableId) {
        HashMap<PeerAndReqKey, ArchiveJournalDirs> result = new HashMap<PeerAndReqKey, ArchiveJournalDirs>();
        Iterator iterator = this.archives.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry elem = iterator.next();
            if (!((PeerAndReqKey)elem.getKey()).getStableId().equals(stableId)) continue;
            result.put((PeerAndReqKey)elem.getKey(), (ArchiveJournalDirs)elem.getValue());
            iterator.remove();
        }
        return result;
    }

    public String toString() {
        return "DescriptionArchives [" + this.archives + "]";
    }

    public static DescriptionArchives withUnmodifiableMap(DescriptionArchives other) {
        return new DescriptionArchives(Collections.unmodifiableMap(other.getAllArchives()));
    }

    public static class PeerAndReqKey {
        private final String stableId;
        private final String reqName;

        public PeerAndReqKey(String stableId, String reqName) {
            this.stableId = stableId;
            this.reqName = reqName;
        }

        public String getStableId() {
            return this.stableId;
        }

        public String getReqGroup() {
            return this.reqName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.reqName == null ? 0 : this.reqName.hashCode());
            result = 31 * result + (this.stableId == null ? 0 : this.stableId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerAndReqKey other = (PeerAndReqKey)obj;
            if (this.reqName == null ? other.reqName != null : !this.reqName.equals(other.reqName)) {
                return false;
            }
            return !(this.stableId == null ? other.stableId != null : !this.stableId.equals(other.stableId));
        }

        public String toString() {
            return "PeerAndReqKey [stableId=" + this.stableId + ", reqName=" + this.reqName + "]";
        }
    }
}

