/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.agent;

import com.nuodb.agent.TLSCertificate;
import com.nuodb.xml.Tag;
import com.nuodb.xml.TagFactory;
import com.nuodb.xml.XmlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TLSHealthInfo {
    public static final String TLS_HEALTH_CHECK = "TLSHealthCheck";
    public static final String TLS_HEALTH_ERRORS = "TLSHealthErrors";
    public static final String TLS_HEALTH_CERTS = "TLSHealthCerts";
    public final String stableId;
    public final boolean enableTLS;
    public final List<String> errorList;
    public final Map<String, TLSCertificate> certMap;

    public TLSHealthInfo(String stableId, boolean enableTLS, List<String> errorList, Map<String, TLSCertificate> certMap) {
        this.stableId = stableId;
        this.enableTLS = enableTLS;
        this.errorList = errorList;
        this.certMap = certMap;
    }

    public TLSHealthInfo(Tag health) throws XmlException {
        this.stableId = health.getAttribute("StableId");
        this.enableTLS = health.getBooleanAttribute("enableTLS", false);
        this.errorList = new ArrayList<String>();
        for (Tag errorTag : health.findChild(TLS_HEALTH_ERRORS)) {
            this.errorList.add(errorTag.getText());
        }
        this.certMap = new HashMap<String, TLSCertificate>();
        for (Tag peerTag : health.findChild(TLS_HEALTH_CERTS)) {
            String tagStableId = peerTag.getAttribute("StableId");
            TLSCertificate tagCert = new TLSCertificate(peerTag);
            this.certMap.put(tagStableId, tagCert);
        }
    }

    public Tag toTag() {
        Tag health = TagFactory.createTag(TLS_HEALTH_CHECK);
        health.addAttribute("StableId", this.stableId);
        health.addAttribute("enableTLS", Boolean.toString(this.enableTLS));
        Tag errorsTag = health.addChild(TLS_HEALTH_ERRORS);
        for (String error : this.errorList) {
            errorsTag.addChild("Error").setText(error);
        }
        Tag certsTag = health.addChild(TLS_HEALTH_CERTS);
        for (Map.Entry<String, TLSCertificate> entry : this.certMap.entrySet()) {
            String certStableId = entry.getKey();
            TLSCertificate certificate = entry.getValue();
            Tag tag = certificate.toPeerTag();
            tag.addAttribute("StableId", certStableId);
            certsTag.addChild(tag);
        }
        return health;
    }
}

