/*
 * Decompiled with CFR 0.152.
 */
package com.nuance.speechkit;

import com.nuance.speechkit.Audio;
import com.nuance.speechkit.DetectionType;
import com.nuance.speechkit.GrammarDefinition;
import com.nuance.speechkit.Interpretation;
import com.nuance.speechkit.Language;
import com.nuance.speechkit.Recognition;
import com.nuance.speechkit.RecognitionType;
import com.nuance.speechkit.ResultDeliveryType;
import com.nuance.speechkit.Session;
import com.nuance.speechkit.TransactionException;
import com.nuance.speechkit.Voice;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public interface Transaction {
    public void cancel();

    public Session getSession();

    public String getSessionID();

    public float getAudioLevel();

    public void stopRecording();

    public static abstract class Listener {
        public void onStartedRecording(Transaction transaction) {
        }

        public void onFinishedRecording(Transaction transaction) {
        }

        public void onRecognition(Transaction transaction, Recognition recognition) {
        }

        public void onInterpretation(Transaction transaction, Interpretation interpretation) {
        }

        public void onServiceResponse(Transaction transaction, JSONObject jSONObject) {
        }

        public void onAudio(Transaction transaction, Audio audio) {
        }

        public void onSuccess(Transaction transaction, String string) {
        }

        public void onError(Transaction transaction, String string, TransactionException transactionException) {
        }
    }

    public static class Options {
        HashMap<String, Object> a = new HashMap();

        public void setDetection(DetectionType detectionType) {
            this.a.put("detectionType", (Object)detectionType);
        }

        public void setLanguage(Language language) {
            this.a.put("language", language);
        }

        public void setVoice(Voice voice) {
            this.a.put("voice", voice);
        }

        public void setCoreLanguageModel(String string) {
            this.a.put("model", string);
        }

        public void setRecognitionType(RecognitionType recognitionType) {
            this.a.put("recognitionType", recognitionType);
        }

        public void setAutoplay(boolean bl) {
            this.a.put("autoplay", bl);
        }

        public void setEarcons(Audio audio, Audio audio2, Audio audio3, Audio audio4) {
            this.a.put("startEarcon", audio);
            this.a.put("stopEarcon", audio2);
            this.a.put("errorEarcon", audio3);
            this.a.put("cancelEarcon", audio4);
        }

        public void setResultDeliveryType(ResultDeliveryType resultDeliveryType) {
            this.a.put("resultDeliveryType", resultDeliveryType);
        }

        public void setSubscriberID(String string) {
            this.a.put("subscriberId", string);
        }

        public DetectionType getDetection() {
            return (DetectionType)((Object)this.a.get("detectionType"));
        }

        public Language getLanguage() {
            return (Language)this.a.get("language");
        }

        public Voice getVoice() {
            return (Voice)this.a.get("voice");
        }

        public String getCoreLanguageModel() {
            return (String)this.a.get("model");
        }

        public RecognitionType getRecognitionType() {
            return (RecognitionType)this.a.get("recognitionType");
        }

        List<GrammarDefinition> a() {
            return (List)this.a.get("grammars");
        }

        public boolean getAutoplay() {
            Object object = this.a.get("autoplay");
            if (object == null) {
                return true;
            }
            return (Boolean)object;
        }

        public Audio getStartEarcon() {
            return (Audio)this.a.get("startEarcon");
        }

        public Audio getStopEarcon() {
            return (Audio)this.a.get("stopEarcon");
        }

        public Audio getErrorEarcon() {
            return (Audio)this.a.get("errorEarcon");
        }

        public Audio getCancelEarcon() {
            return (Audio)this.a.get("cancelEarcon");
        }

        public ResultDeliveryType getResultDeliveryType() {
            return (ResultDeliveryType)this.a.get("resultDeliveryType");
        }

        public String getSubscriberID() {
            return (String)this.a.get("subscriberId");
        }

        Options a(Options options) {
            for (Map.Entry<String, Object> entry : this.a.entrySet()) {
                if (options.a.containsKey(entry.getKey())) continue;
                options.a.put(entry.getKey(), entry.getValue());
            }
            return options;
        }
    }
}

