/*
 * Decompiled with CFR 0.152.
 */
package com.nu.art.cyborg.maps.google;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.res.Resources;
import android.location.Location;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.cyborg.googlemapsmodule.R;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.GoogleMapOptions;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.UiSettings;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.MapStyleOptions;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.nu.art.core.generics.Processor;
import com.nu.art.cyborg.core.CyborgController;
import com.nu.art.cyborg.maps.google.OnGoogleMapListener;
import com.nu.art.cyborg.maps.google.OnMapReadyListener;
import com.nu.art.cyborg.modules.LocationModule;
import java.util.ArrayList;
import java.util.Random;

public class Controller_GoogleMap
extends CyborgController
implements LocationModule.OnLocationUpdatedListener,
OnMapReadyCallback,
GoogleMap.OnMapClickListener,
GoogleMap.OnMapLongClickListener,
GoogleMap.OnMarkerClickListener,
GoogleMap.OnInfoWindowClickListener {
    private MapFragment mapFragment;
    private GoogleMap googleMap;
    private Marker myMarker;
    private ArrayList<MapMarker> markers = new ArrayList();
    private Polyline polyline;
    private int cameraZoom = 16;
    private int mapLayoutId;

    public Controller_GoogleMap() {
        super(R.layout.controller__google_maps_fragment);
    }

    protected void onCreate() {
        super.onCreate();
        this.getActivity().setRequestedOrientation(1);
        this.setMapFragmentId();
    }

    protected void onDestroy() {
        this.getActivity().setRequestedOrientation(2);
    }

    private void setMapFragmentId() {
        Random random = new Random();
        do {
            this.mapLayoutId = Math.abs(random.nextInt());
        } while (this.getActivity().findViewById(this.mapLayoutId) != null);
        FrameLayout fl = new FrameLayout((Context)this.getActivity());
        ((ViewGroup)this.getRootView()).addView((View)fl);
        fl.setId(this.mapLayoutId);
        this.getActivity().findViewById(fl.getId());
    }

    private void removeAllMarkers() {
        this.googleMap.clear();
    }

    public void showMap() {
        this.showMap(null);
    }

    public void showMap(GoogleMapOptions mapOptions) {
        if (this.mapFragment != null) {
            return;
        }
        this.mapFragment = mapOptions == null ? MapFragment.newInstance() : MapFragment.newInstance((GoogleMapOptions)mapOptions);
        this.addMapFragmentToViewHierarchy();
    }

    private void addMapFragmentToViewHierarchy() {
        FragmentManager fm = this.getActivity().getFragmentManager();
        if (this.getActivity().findViewById(this.mapLayoutId) == null) {
            return;
        }
        FragmentTransaction ft = fm.beginTransaction();
        ft.replace(this.mapLayoutId, (Fragment)this.mapFragment, "map-fragment-" + this.mapLayoutId);
        ft.commit();
        this.mapFragment.getMapAsync((OnMapReadyCallback)this);
    }

    public UiSettings getUiSettings() {
        if (this.googleMap == null) {
            this.logError("Need to call showMap() before accessing the map ui settings");
            return null;
        }
        return this.googleMap.getUiSettings();
    }

    public void setMapType(int mapType) {
        this.googleMap.setMapType(mapType);
    }

    public void setMapStyle(MapStyleOptions mapStyle) {
        try {
            boolean success = this.googleMap.setMapStyle(mapStyle);
            if (!success) {
                this.logError("Style parsing failed.");
            }
        }
        catch (Resources.NotFoundException e) {
            this.logError("Can't find map style. Error: ", e);
        }
    }

    public void showMyLocationIndicatorAndButton(GoogleMap.OnMyLocationButtonClickListener locationButtonClickListener) {
        this.googleMap.setMyLocationEnabled(true);
        if (locationButtonClickListener != null) {
            this.googleMap.setOnMyLocationButtonClickListener(locationButtonClickListener);
        }
    }

    public void hideMyLocationIndicatorAndButton() {
        this.googleMap.setMyLocationEnabled(false);
    }

    public void removeMarker(MapMarker marker) {
        this.markers.remove(marker);
    }

    private void updateRoute() {
        PolylineOptions polyline = new PolylineOptions().width(3.0f).color(-65536);
        for (MapMarker marker : this.markers) {
            polyline.add(marker.position);
        }
        this.updateRoutesOnMap(polyline);
    }

    public void onLocationUpdated(Location location) {
    }

    public void onLocationUpdateError() {
    }

    public void onMapReady(GoogleMap googleMap) {
        this.googleMap = googleMap;
        googleMap.setMapType(1);
        this.googleMap.setOnMapClickListener((GoogleMap.OnMapClickListener)this);
        this.googleMap.setOnMapLongClickListener((GoogleMap.OnMapLongClickListener)this);
        this.googleMap.setOnMarkerClickListener((GoogleMap.OnMarkerClickListener)this);
        this.googleMap.setOnInfoWindowClickListener((GoogleMap.OnInfoWindowClickListener)this);
        this.dispatchEvent("Map is ready.", OnMapReadyListener.class, (Processor)new Processor<OnMapReadyListener>(){

            public void process(OnMapReadyListener listener) {
                listener.onMapReady(Controller_GoogleMap.this.getRootView().getId());
            }
        });
    }

    public void setDefaultCameraZoom(int cameraZoom) {
        this.cameraZoom = cameraZoom;
    }

    public CameraPosition getCameraPosition() {
        return this.googleMap.getCameraPosition();
    }

    public void setCameraLocation(LatLng position, boolean animate) {
        this.setCameraLocation(position, this.cameraZoom, animate);
    }

    public void setCameraLocation(LatLng position, int cameraZoom, boolean animate) {
        if (position == null) {
            return;
        }
        CameraUpdate newLocation = CameraUpdateFactory.newLatLngZoom((LatLng)position, (float)cameraZoom);
        if (animate) {
            this.googleMap.animateCamera(newLocation);
        } else {
            this.googleMap.moveCamera(newLocation);
        }
    }

    public Marker addMarker(MapMarker mapMarker) {
        MarkerOptions markerOptions = new MarkerOptions().position(mapMarker.position).title(mapMarker.title).icon(mapMarker.iconRes == 0 ? BitmapDescriptorFactory.defaultMarker((float)mapMarker.color) : BitmapDescriptorFactory.fromResource((int)mapMarker.iconRes));
        this.markers.add(mapMarker);
        return mapMarker.marker = this.googleMap.addMarker(markerOptions);
    }

    private void updateRoutesOnMap(PolylineOptions rectLine) {
        if (this.polyline != null) {
            this.polyline.remove();
        }
        this.polyline = this.googleMap.addPolyline(rectLine);
    }

    public void onMapClick(final LatLng latLng) {
        this.dispatchEvent("Map event MAP_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onMapClick(Controller_GoogleMap.this.getRootView().getId(), latLng);
            }
        });
    }

    public void onMapLongClick(final LatLng latLng) {
        this.dispatchEvent("Map event MAP_LONG_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onMapLongClick(Controller_GoogleMap.this.getRootView().getId(), latLng);
            }
        });
    }

    public boolean onMarkerClick(final Marker marker) {
        this.dispatchEvent("Map event MAP_MARKER_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onMarkerClick(Controller_GoogleMap.this.getRootView().getId(), marker);
            }
        });
        return true;
    }

    public void onInfoWindowClick(final Marker marker) {
        this.dispatchEvent("Map event MAP_INFO_WINDOW_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onInfoWindowClick(Controller_GoogleMap.this.getRootView().getId(), marker);
            }
        });
    }

    public static class MapMarker {
        public LatLng position;
        private float color;
        private String title;
        private int iconRes;
        private Marker marker;

        public MapMarker(LatLng position, float color, String title, int iconRes) {
            this.position = position;
            this.color = color;
            this.title = title;
            this.iconRes = iconRes;
        }
    }
}

