/*
 * Decompiled with CFR 0.152.
 */
package com.nu.art.cyborg.maps.google;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.location.Location;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.cyborg.googlemapsmodule.R;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.nu.art.core.generics.Processor;
import com.nu.art.cyborg.core.CyborgController;
import com.nu.art.cyborg.maps.google.OnGoogleMapListener;
import com.nu.art.cyborg.maps.google.OnMapReadyListener;
import com.nu.art.cyborg.modules.LocationModule;
import java.util.ArrayList;
import java.util.Random;

public class Controller_GoogleMap
extends CyborgController
implements LocationModule.OnLocationUpdatedListener,
OnMapReadyCallback,
GoogleMap.OnMapClickListener,
GoogleMap.OnMapLongClickListener,
GoogleMap.OnMarkerClickListener,
GoogleMap.OnInfoWindowClickListener {
    private MapFragment mapFragment;
    private GoogleMap mGoogleMap;
    private Marker myMarker;
    private ArrayList<MapMarker> markers = new ArrayList();
    private Polyline polyline;
    private int cameraZoom = 16;
    private int mapLayoutId;

    public Controller_GoogleMap() {
        super(R.layout.controller__google_maps_fragment);
    }

    protected void onCreate() {
        super.onCreate();
        this.getActivity().setRequestedOrientation(1);
        this.setMapFragmentId();
    }

    private void setMapFragmentId() {
        Random random = new Random();
        do {
            this.mapLayoutId = Math.abs(random.nextInt());
        } while (this.getActivity().findViewById(this.mapLayoutId) != null);
        FrameLayout fl = new FrameLayout((Context)this.getActivity());
        ((ViewGroup)this.getRootView()).addView((View)fl);
        fl.setId(this.mapLayoutId);
        this.getActivity().findViewById(fl.getId());
    }

    private void removeAllMarkers() {
    }

    protected void onResume() {
        super.onResume();
        this.addMapFragmentToViewHierarchy();
    }

    private void addMapFragmentToViewHierarchy() {
        if (this.mapFragment != null) {
            return;
        }
        this.mapFragment = MapFragment.newInstance();
        FragmentManager fm = this.getActivity().getFragmentManager();
        if (this.getActivity().findViewById(this.mapLayoutId) == null) {
            return;
        }
        FragmentTransaction ft = fm.beginTransaction();
        ft.replace(this.mapLayoutId, (Fragment)this.mapFragment, "map-fragment-" + this.mapLayoutId);
        ft.commit();
        this.mapFragment.getMapAsync((OnMapReadyCallback)this);
    }

    public void removeMarker(MapMarker marker) {
        this.markers.remove(marker);
    }

    private void updateRoute() {
        PolylineOptions polyline = new PolylineOptions().width(3.0f).color(-65536);
        for (MapMarker marker : this.markers) {
            polyline.add(marker.position);
        }
        this.updateRoutesOnMap(polyline);
    }

    public void onLocationUpdated(Location location) {
        LatLng myPosition = new LatLng(location.getLatitude(), location.getLongitude());
        this.setCameraLocation(myPosition);
    }

    public void onMapReady(GoogleMap googleMap) {
        this.mGoogleMap = googleMap;
        googleMap.setMapType(4);
        this.mGoogleMap.setOnMapClickListener((GoogleMap.OnMapClickListener)this);
        this.mGoogleMap.setOnMapLongClickListener((GoogleMap.OnMapLongClickListener)this);
        this.mGoogleMap.setOnMarkerClickListener((GoogleMap.OnMarkerClickListener)this);
        this.mGoogleMap.setOnInfoWindowClickListener((GoogleMap.OnInfoWindowClickListener)this);
        this.dispatchEvent("Map is ready.", OnMapReadyListener.class, (Processor)new Processor<OnMapReadyListener>(){

            public void process(OnMapReadyListener listener) {
                listener.onMapReady(Controller_GoogleMap.this.getRootView().getId());
            }
        });
    }

    public void setCameraZoom(int cameraZoom) {
        this.cameraZoom = cameraZoom;
    }

    public void setCameraLocation(LatLng position) {
        if (position == null) {
            return;
        }
        CameraUpdate newLocation = CameraUpdateFactory.newLatLngZoom((LatLng)position, (float)this.cameraZoom);
        this.mGoogleMap.moveCamera(newLocation);
    }

    public Marker addMarker(MapMarker mapMarker) {
        MarkerOptions markerOptions = new MarkerOptions().position(mapMarker.position).title(mapMarker.title).icon(BitmapDescriptorFactory.defaultMarker((float)mapMarker.color));
        this.markers.add(mapMarker);
        return mapMarker.marker = this.mGoogleMap.addMarker(markerOptions);
    }

    private void updateRoutesOnMap(PolylineOptions rectLine) {
        if (this.polyline != null) {
            this.polyline.remove();
        }
        this.polyline = this.mGoogleMap.addPolyline(rectLine);
    }

    public void onMapClick(final LatLng latLng) {
        this.dispatchEvent("Map event MAP_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onMapClick(Controller_GoogleMap.this.getRootView().getId(), latLng);
            }
        });
    }

    public void onMapLongClick(final LatLng latLng) {
        this.dispatchEvent("Map event MAP_LONG_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onMapLongClick(Controller_GoogleMap.this.getRootView().getId(), latLng);
            }
        });
    }

    public boolean onMarkerClick(final Marker marker) {
        this.dispatchEvent("Map event MAP_MARKER_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onMarkerClick(Controller_GoogleMap.this.getRootView().getId(), marker);
            }
        });
        return true;
    }

    public void onInfoWindowClick(final Marker marker) {
        this.dispatchEvent("Map event MAP_INFO_WINDOW_CLICK was called.", OnGoogleMapListener.class, (Processor)new Processor<OnGoogleMapListener>(){

            public void process(OnGoogleMapListener listener) {
                listener.onInfoWindowClick(Controller_GoogleMap.this.getRootView().getId(), marker);
            }
        });
    }

    public static class MapMarker {
        public LatLng position;
        private float color;
        private String title;
        private Marker marker;

        public MapMarker(LatLng position, float color, String title) {
            this.position = position;
            this.color = color;
            this.title = title;
        }
    }
}

