/*
 * Decompiled with CFR 0.152.
 */
package com.nu.art.cyborg.maps.google;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.location.Location;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.cyborg.googlemapsmodule.R;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.MapFragment;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.Polyline;
import com.google.android.gms.maps.model.PolylineOptions;
import com.nu.art.core.generics.Processor;
import com.nu.art.cyborg.core.CyborgController;
import com.nu.art.cyborg.maps.google.MyOnMapReadyCallback;
import com.nu.art.cyborg.maps.google.OnMapClicks;
import com.nu.art.cyborg.modules.LocationModule;
import java.util.ArrayList;
import java.util.Random;

public class Controller_GoogleMap
extends CyborgController
implements LocationModule.OnLocationUpdatedListener,
OnMapReadyCallback,
GoogleMap.OnMapClickListener,
GoogleMap.OnMapLongClickListener,
GoogleMap.OnMarkerClickListener,
GoogleMap.OnInfoWindowClickListener {
    private MapFragment mapFragment;
    private GoogleMap mGoogleMap;
    private Marker myMarker;
    private ArrayList<Marker> allNonStickyMarker = new ArrayList();
    private PolylineOptions rectLine;
    private Polyline polyline;
    private int cameraZoom = 16;
    private final String USER_POSITION_INFO = "You're here";
    private final String TARGET_LOCATION_INFO = "Remove marker";
    private final float DEFAULT_TARGET_MARKER_COLOR = 120.0f;
    private final float DEFAULT_USER_MARKER = 210.0f;
    private int mapLayoutId;

    public Controller_GoogleMap() {
        super(R.layout.controller__google_maps_fragment);
    }

    protected void onCreate() {
        super.onCreate();
        this.rectLine = new PolylineOptions().width(3.0f).color(-65536);
        this.getActivity().setRequestedOrientation(1);
        this.setMapFragmentId();
    }

    private void setMapFragmentId() {
        if (this.mGoogleMap != null) {
            this.removeAllMarkers();
        }
        Random random = new Random();
        do {
            this.mapLayoutId = Math.abs(random.nextInt());
        } while (this.getActivity().findViewById(this.mapLayoutId) != null);
        FrameLayout fl = new FrameLayout((Context)this.getActivity());
        ((ViewGroup)this.getRootView()).addView((View)fl);
        fl.setId(this.mapLayoutId);
        this.getActivity().findViewById(fl.getId());
    }

    protected void onResume() {
        super.onResume();
        this.addMapFragmentToViewHierarchy();
    }

    private void addMapFragmentToViewHierarchy() {
        if (this.mapFragment != null) {
            return;
        }
        this.mapFragment = MapFragment.newInstance();
        FragmentManager fm = this.getActivity().getFragmentManager();
        if (this.getActivity().findViewById(this.mapLayoutId) == null) {
            return;
        }
        FragmentTransaction ft = fm.beginTransaction();
        ft.replace(this.mapLayoutId, (Fragment)this.mapFragment, "map-fragment-" + this.mapLayoutId);
        ft.commit();
        this.mapFragment.getMapAsync((OnMapReadyCallback)this);
    }

    public void removeAllMarkers() {
        while (!this.allNonStickyMarker.isEmpty()) {
            this.allNonStickyMarker.remove(0).remove();
        }
        this.updateRoute();
    }

    public void removeMarker(Marker marker) {
        if (this.allNonStickyMarker.remove(marker)) {
            marker.remove();
        }
        this.updateRoute();
    }

    private void updateRoute() {
        this.rectLine = new PolylineOptions().width(5.0f).color(-65536);
        for (int i = 0; i < this.allNonStickyMarker.size(); ++i) {
            Marker marker = this.allNonStickyMarker.get(i);
            this.rectLine.add(marker.getPosition());
            this.addMarker(marker.getPosition(), 120.0f, "Remove marker");
        }
        this.updateRoutesOnMap();
    }

    public void onLocationUpdated(Location location) {
        LatLng myPosition = new LatLng(location.getLatitude(), location.getLongitude());
        this.setCameraLocation(myPosition);
    }

    public void onMapReady(GoogleMap googleMap) {
        this.mGoogleMap = googleMap;
        googleMap.setMapType(4);
        this.mGoogleMap.setOnMapClickListener((GoogleMap.OnMapClickListener)this);
        this.mGoogleMap.setOnMapLongClickListener((GoogleMap.OnMapLongClickListener)this);
        this.mGoogleMap.setOnMarkerClickListener((GoogleMap.OnMarkerClickListener)this);
        this.mGoogleMap.setOnInfoWindowClickListener((GoogleMap.OnInfoWindowClickListener)this);
        this.updateRoute();
        this.dispatchEvent("Map event MAP_READY was called.", MyOnMapReadyCallback.class, (Processor)new Processor<MyOnMapReadyCallback>(){

            public void process(MyOnMapReadyCallback listener) {
                listener.onMapReady(Controller_GoogleMap.this.getRootView().getId());
            }
        });
    }

    public void setCameraZoom(int cameraZoom) {
        this.cameraZoom = cameraZoom;
    }

    public void setCameraLocation(LatLng position) {
        if (position == null) {
            return;
        }
        CameraUpdate newLocation = CameraUpdateFactory.newLatLngZoom((LatLng)position, (float)this.cameraZoom);
        this.mGoogleMap.moveCamera(newLocation);
        this.addStickyMarker(position);
    }

    public void addStickyMarker(LatLng position) {
        if (this.myMarker != null) {
            this.myMarker.remove();
        }
        this.myMarker = this.addMarker(position, 210.0f, "You're here");
    }

    public void addTargetMarker(LatLng position) {
        Marker marker = this.addMarker(position, 120.0f, "Remove marker");
        this.allNonStickyMarker.add(marker);
        this.addMarkerToRoute(marker);
    }

    private Marker addMarker(LatLng position, float color, String title) {
        MarkerOptions markerOptions = new MarkerOptions().position(position).title(title).icon(BitmapDescriptorFactory.defaultMarker((float)color));
        return this.mGoogleMap.addMarker(markerOptions);
    }

    private void addMarkerToRoute(Marker marker) {
        this.rectLine.add(marker.getPosition());
        this.updateRoutesOnMap();
    }

    private void updateRoutesOnMap() {
        if (this.polyline != null) {
            this.polyline.remove();
        }
        this.polyline = this.mGoogleMap.addPolyline(this.rectLine);
    }

    public void onMapClick(final LatLng latLng) {
        this.dispatchEvent("Map event MAP_CLICK was called.", OnMapClicks.class, (Processor)new Processor<OnMapClicks>(){

            public void process(OnMapClicks listener) {
                listener.onMapClick(Controller_GoogleMap.this.getRootView().getId(), latLng);
            }
        });
    }

    public void onMapLongClick(final LatLng latLng) {
        this.dispatchEvent("Map event MAP_LONG_CLICK was called.", OnMapClicks.class, (Processor)new Processor<OnMapClicks>(){

            public void process(OnMapClicks listener) {
                listener.onMapLongClick(Controller_GoogleMap.this.getRootView().getId(), latLng);
            }
        });
    }

    public boolean onMarkerClick(final Marker marker) {
        this.dispatchEvent("Map event MAP_MARKER_CLICK was called.", OnMapClicks.class, (Processor)new Processor<OnMapClicks>(){

            public void process(OnMapClicks listener) {
                listener.onMarkerClick(Controller_GoogleMap.this.getRootView().getId(), marker);
            }
        });
        return true;
    }

    public void onInfoWindowClick(final Marker marker) {
        this.dispatchEvent("Map event MAP_INFO_WINDOW_CLICK was called.", OnMapClicks.class, (Processor)new Processor<OnMapClicks>(){

            public void process(OnMapClicks listener) {
                listener.onInfoWindowClick(Controller_GoogleMap.this.getRootView().getId(), marker);
            }
        });
    }
}

