/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import com.nshmura.strictmodenotifier.LogWatchService;
import com.nshmura.strictmodenotifier.R;
import com.nshmura.strictmodenotifier.StrictModeNotifierSingleThreadFactory;
import com.nshmura.strictmodenotifier.StrictModeReportActivity;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

final class StrictModeNotifierInternals {
    private static final Executor fileIoExecutor = StrictModeNotifierInternals.newSingleThreadExecutor("File-IO");
    private static final int NOTIFICATION_ID = 1;

    StrictModeNotifierInternals() {
    }

    public static void enableReportActivity(Context context) {
        StrictModeNotifierInternals.setEnabled(context, StrictModeReportActivity.class, true);
    }

    public static void startLogWatchService(Context context, Class<? extends LogWatchService> serviceClass) {
        Intent intent = new Intent(context, serviceClass);
        context.startService(intent);
    }

    public static void setEnabled(Context context, final Class<?> componentClass, final boolean enabled) {
        final Context appContext = context.getApplicationContext();
        StrictModeNotifierInternals.executeOnFileIoThread(new Runnable(){

            @Override
            public void run() {
                StrictModeNotifierInternals.setEnabledBlocking(appContext, componentClass, enabled);
            }
        });
    }

    public static void setEnabledBlocking(Context appContext, Class<?> componentClass, boolean enabled) {
        ComponentName component = new ComponentName(appContext, componentClass);
        PackageManager packageManager = appContext.getPackageManager();
        int newState = enabled ? 1 : 2;
        packageManager.setComponentEnabledSetting(component, newState, 1);
    }

    public static void executeOnFileIoThread(Runnable runnable) {
        fileIoExecutor.execute(runnable);
    }

    public static Executor newSingleThreadExecutor(String threadName) {
        return Executors.newSingleThreadExecutor(new StrictModeNotifierSingleThreadFactory(threadName));
    }

    public static void showNotification(Context context, CharSequence contentTitle, CharSequence contentText, boolean headupEnabled, PendingIntent pendingIntent) {
        if (Build.VERSION.SDK_INT < 11) {
            StrictModeNotifierInternals.showNotificationFor9(context, contentTitle, contentText, pendingIntent);
        } else {
            Notification.Builder builder = new Notification.Builder(context).setSmallIcon(R.drawable.strictmode_notifier_ic_notification).setWhen(System.currentTimeMillis()).setContentTitle(contentTitle).setContentText(contentText).setAutoCancel(true).setContentIntent(pendingIntent);
            if (Build.VERSION.SDK_INT < 16) {
                StrictModeNotifierInternals.showNotificationFor11(context, builder);
            } else {
                StrictModeNotifierInternals.showNotificationFor16(context, headupEnabled, pendingIntent, builder);
            }
        }
    }

    private static void showNotificationFor9(Context context, CharSequence contentTitle, CharSequence contentText, PendingIntent pendingIntent) {
        Notification notification = new Notification();
        notification.icon = R.drawable.strictmode_notifier_ic_notification;
        notification.when = System.currentTimeMillis();
        notification.flags |= 0x10;
        try {
            Method method = Notification.class.getMethod("setLatestEventInfo", Context.class, CharSequence.class, CharSequence.class, PendingIntent.class);
            method.invoke((Object)notification, context, contentTitle, contentText, pendingIntent);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        StrictModeNotifierInternals.getNotificationManager(context).notify(1, notification);
    }

    @TargetApi(value=11)
    private static void showNotificationFor11(Context context, Notification.Builder builder) {
        StrictModeNotifierInternals.getNotificationManager(context).notify(1, builder.getNotification());
    }

    @TargetApi(value=16)
    private static void showNotificationFor16(Context context, boolean headupEnabled, PendingIntent pendingIntent, Notification.Builder builder) {
        if (Build.VERSION.SDK_INT >= 21 && headupEnabled) {
            builder.setFullScreenIntent(pendingIntent, true);
        }
        StrictModeNotifierInternals.getNotificationManager(context).notify(1, builder.build());
    }

    private static NotificationManager getNotificationManager(Context context) {
        return (NotificationManager)context.getSystemService("notification");
    }
}

