/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.nshmura.strictmodenotifier.StrictModeViolation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

class ViolationStore {
    private static final String NAME = "strictmode";
    private static final String KEY = "reports";
    private static final int MAX_REPORTS = 50;
    private final Context context;

    ViolationStore(Context context) {
        this.context = context;
    }

    private static Object fromString(String s) throws IOException, ClassNotFoundException {
        byte[] data = Base64.decode((String)s, (int)0);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        Object o = ois.readObject();
        ois.close();
        return o;
    }

    private static String toString(Serializable o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return Base64.encodeToString((byte[])baos.toByteArray(), (int)0);
    }

    public ArrayList<StrictModeViolation> getAll() {
        try {
            String serialized = this.getPrefs().getString(KEY, null);
            if (serialized != null) {
                return (ArrayList)ViolationStore.fromString(serialized);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<StrictModeViolation>();
    }

    public void append(StrictModeViolation report) throws IOException {
        ArrayList<StrictModeViolation> reports = this.getAll();
        if (reports.size() > 50) {
            reports.subList(0, 50);
        }
        reports.add(0, report);
        this.getPrefs().edit().putString(KEY, ViolationStore.toString(reports)).apply();
    }

    public void remove(StrictModeViolation target) {
        ArrayList<StrictModeViolation> reports = this.getAll();
        Integer targetIndex = null;
        for (int i = 0; i < reports.size(); ++i) {
            StrictModeViolation report = reports.get(i);
            if (!report.logKey.equals(target.logKey) || report.time != target.time) continue;
            targetIndex = i;
            break;
        }
        if (targetIndex != null) {
            reports.remove(targetIndex);
            try {
                this.getPrefs().edit().putString(KEY, ViolationStore.toString(reports)).apply();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void clear() {
        this.getPrefs().edit().clear().apply();
    }

    private SharedPreferences getPrefs() {
        return this.context.getSharedPreferences(NAME, 0);
    }
}

