/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CompoundButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ToggleButton;
import com.nshmura.strictmodenotifier.R;
import com.nshmura.strictmodenotifier.ReportActivityUtils;
import com.nshmura.strictmodenotifier.ReportAdapter;
import com.nshmura.strictmodenotifier.StrictModeReportDetailActivity;
import com.nshmura.strictmodenotifier.StrictModeViolation;
import com.nshmura.strictmodenotifier.StringModeConfig;
import com.nshmura.strictmodenotifier.ViolationStore;
import java.io.Serializable;
import java.util.ArrayList;

public class StrictModeReportActivity
extends Activity {
    private static final String EXTRA_REPORT = "EXTRA_REPORT";
    private ReportAdapter adapter;
    private ViolationStore violationStore;

    protected void onCreate(Bundle savedInstanceState) {
        StrictModeViolation report;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.strictmode_notifier_activity_report);
        ReportActivityUtils.setTitle(this, this.getString(R.string.strictmode_notifier_title, new Object[]{this.getPackageName()}));
        this.adapter = new ReportAdapter(this);
        ListView listView = (ListView)this.findViewById(R.id.__list_view);
        listView.setAdapter((ListAdapter)this.adapter);
        this.violationStore = new ViolationStore((Context)this);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                StrictModeViolation report = StrictModeReportActivity.this.adapter.getItem(position);
                StrictModeReportDetailActivity.start((Context)StrictModeReportActivity.this, report);
            }
        });
        ToggleButton toggleButton = (ToggleButton)this.findViewById(R.id.__enable_button);
        toggleButton.setChecked(StringModeConfig.from((Context)this).isEnabled());
        toggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                StringModeConfig.from((Context)StrictModeReportActivity.this).toggle();
            }
        });
        this.findViewById(R.id.__delete_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StrictModeReportActivity.this.violationStore.clear();
                StrictModeReportActivity.this.adapter.clear();
                StrictModeReportActivity.this.adapter.notifyDataSetChanged();
            }
        });
        if (savedInstanceState == null && (report = (StrictModeViolation)this.getIntent().getSerializableExtra(EXTRA_REPORT)) != null) {
            StrictModeReportDetailActivity.start((Context)this, report);
        }
    }

    protected void onResume() {
        super.onResume();
        ArrayList<StrictModeViolation> reports = this.violationStore.getAll();
        this.adapter.clear();
        this.adapter.addAll(reports);
        this.adapter.notifyDataSetChanged();
    }

    public static Intent createIntent(Context context, StrictModeViolation report) {
        Intent intent = new Intent(context, StrictModeReportActivity.class);
        intent.putExtra(EXTRA_REPORT, (Serializable)report);
        return intent;
    }

    public static PendingIntent createPendingIntent(Context context, StrictModeViolation report) {
        Intent intent = StrictModeReportActivity.createIntent(context, report);
        intent.setFlags(0x14000000);
        return PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
    }
}

