/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.nshmura.strictmodenotifier.CustomAction;
import com.nshmura.strictmodenotifier.NotifierConfig;
import com.nshmura.strictmodenotifier.R;
import com.nshmura.strictmodenotifier.StrictModeLog;
import com.nshmura.strictmodenotifier.StrictModeNotifierInternals;
import com.nshmura.strictmodenotifier.StrictModeReportActivity;
import com.nshmura.strictmodenotifier.StrictModeViolation;
import com.nshmura.strictmodenotifier.ViolationStore;
import com.nshmura.strictmodenotifier.ViolationType;
import com.nshmura.strictmodenotifier.ViolationTypeInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class LogWatchService
extends IntentService {
    private static final String THREAD_NAME;
    private static final String TAG;
    private static final String LOGCAT_COMMAND = "logcat -v time -s StrictMode:* System.err:*";
    private static final String PARSE_REGEXP = "(StrictMode|System.err)(\\([ 0-9]+\\))?:";
    private static final CharSequence EXCEPTION_KEY;
    private static final long NOTIFICATION_DELAY = 2000L;
    private static final long LOG_DELAY = 1000L;
    private static final long EXIT_SPAN = 60000L;
    private NotifierConfig notifierConfig = NotifierConfig.getInstance();
    private Process proc;
    private final ViolationStore violationStore;
    private List<StrictModeLog> logs = new ArrayList<StrictModeLog>();
    private Timer timer = null;
    private ViolationType[] values = ViolationType.values();

    public LogWatchService() {
        this(TAG);
    }

    public LogWatchService(String name) {
        super(name);
        this.violationStore = new ViolationStore((Context)this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        return 1;
    }

    protected void onHandleIntent(Intent intent) {
        this.startReadLoop();
    }

    public void onDestroy() {
        super.onDestroy();
        this.log("onDestroy");
        if (this.proc != null) {
            this.proc.destroy();
            this.proc = null;
        }
    }

    protected void notifyViolation(StrictModeViolation violation) {
        List<CustomAction> customActions = this.notifierConfig.getCustomActions();
        for (CustomAction customAction : customActions) {
            customAction.onViolation(violation);
        }
        String notificationTitle = violation.violationType != null ? ViolationTypeInfo.convert(violation.violationType).violationName() : this.getString(R.string.strictmode_notifier_title, new Object[]{this.getPackageName()});
        StrictModeNotifierInternals.showNotification((Context)this, notificationTitle, this.getString(R.string.strictmode_notifier_more_detail), this.notifierConfig.isHeadupEnabled(), StrictModeReportActivity.createPendingIntent((Context)this, violation));
    }

    private void startReadLoop() {
        long startTime;
        do {
            startTime = System.currentTimeMillis();
            this.log("start readLoop");
            this.readLoop();
            this.log("end readLoop");
        } while (System.currentTimeMillis() - startTime > 60000L);
        this.log("exit readLoop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLoop() {
        BufferedReader reader = null;
        try {
            String line;
            Runtime.getRuntime().exec("logcat -c");
            this.proc = Runtime.getRuntime().exec(LOGCAT_COMMAND);
            reader = new BufferedReader(new InputStreamReader(this.proc.getInputStream()), 1024);
            while ((line = reader.readLine()) != null && line.length() != 0) {
                this.log(line);
                StrictModeLog log = this.parseLine(line);
                if (log == null) continue;
                this.storeLog(log);
                this.startReportTimer();
            }
            this.error("error readLoop");
        }
        catch (IOException e) {
            this.error(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private StrictModeLog parseLine(String line) {
        String[] split = line.split(PARSE_REGEXP);
        if (split.length < 2) {
            return null;
        }
        if (split[1].equals("null")) {
            return null;
        }
        return new StrictModeLog(split[0], split[1], System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLog(StrictModeLog log) {
        LogWatchService logWatchService = this;
        synchronized (logWatchService) {
            this.logs.add(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReportTimer() {
        LogWatchService logWatchService = this;
        synchronized (logWatchService) {
            if (this.timer != null) {
                return;
            }
            this.timer = new Timer(true);
        }
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogWatchService logWatchService = LogWatchService.this;
                synchronized (logWatchService) {
                    int count = LogWatchService.this.logs.size();
                    boolean prevIsAt = false;
                    long lastReadTime = 0L;
                    ArrayList<StrictModeLog> targets = new ArrayList<StrictModeLog>();
                    for (int i = 0; i < count; ++i) {
                        StrictModeLog log = (StrictModeLog)LogWatchService.this.logs.get(i);
                        boolean isAt = log.isAt();
                        if (!isAt && prevIsAt && targets.size() > 0) {
                            StrictModeViolation report = LogWatchService.this.createViolation(targets);
                            if (report != null) {
                                LogWatchService.this.notifyViolation(report);
                            }
                            targets.clear();
                        }
                        prevIsAt = isAt;
                        targets.add(log);
                        lastReadTime = log.time;
                    }
                    if (targets.size() > 0 && System.currentTimeMillis() - lastReadTime >= 1000L) {
                        StrictModeViolation report = LogWatchService.this.createViolation(targets);
                        if (report != null) {
                            LogWatchService.this.notifyViolation(report);
                        }
                        targets.clear();
                    }
                    LogWatchService.this.timer = null;
                    if (targets.size() > 0) {
                        LogWatchService.this.logs = targets;
                        LogWatchService.this.startReportTimer();
                    } else {
                        LogWatchService.this.logs.clear();
                    }
                }
            }
        }, 2000L);
    }

    private StrictModeViolation createViolation(List<StrictModeLog> logs) {
        ArrayList<String> stacktreace = new ArrayList<String>(logs.size());
        String title = "";
        String logKey = "";
        long time = 0L;
        for (StrictModeLog log : logs) {
            if (TextUtils.isEmpty((CharSequence)title)) {
                title = log.message;
                logKey = log.tag;
                time = log.time;
            }
            stacktreace.add(log.message);
        }
        ViolationType violationType = this.getViolationType(logs);
        if (violationType == null && logKey.contains(EXCEPTION_KEY)) {
            return null;
        }
        StrictModeViolation violation = new StrictModeViolation(violationType, title, logKey, stacktreace, time);
        if (this.notifierConfig.getIgnoreAction() != null && this.notifierConfig.getIgnoreAction().ignore(violation)) {
            return null;
        }
        try {
            this.violationStore.append(violation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return violation;
    }

    private ViolationType getViolationType(List<StrictModeLog> logs) {
        for (StrictModeLog log : logs) {
            for (ViolationType type : this.values) {
                ViolationTypeInfo info = ViolationTypeInfo.convert(type);
                if (!info.detector.detect(log)) continue;
                return type;
            }
        }
        return null;
    }

    private void log(String message) {
        if (this.notifierConfig.isDebugMode()) {
            Log.d((String)TAG, (String)message);
        }
    }

    private void error(String message) {
        if (this.notifierConfig.isDebugMode()) {
            Log.e((String)TAG, (String)message);
        }
    }

    static {
        TAG = THREAD_NAME = LogWatchService.class.getSimpleName();
        EXCEPTION_KEY = "System.err";
    }
}

