/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier;

import com.nshmura.strictmodenotifier.StrictModeLog;
import com.nshmura.strictmodenotifier.detector.ClassInstanceLimitDetector;
import com.nshmura.strictmodenotifier.detector.CleartextNetworkDetector;
import com.nshmura.strictmodenotifier.detector.CustomSlowCallDetector;
import com.nshmura.strictmodenotifier.detector.Detector;
import com.nshmura.strictmodenotifier.detector.FileUriExposureDetector;
import com.nshmura.strictmodenotifier.detector.LeakedClosableObjectsDetector;
import com.nshmura.strictmodenotifier.detector.NetworkDetector;
import com.nshmura.strictmodenotifier.detector.ResourceMismatchDetector;

public enum ViolationType {
    CUSTOM_SLOW_CALL("Custom Slow Call", 11, new CustomSlowCallDetector()),
    NETWORK("Network", 9, new NetworkDetector()),
    RESOURCE_MISMATCHES("Resource Mismatches", 23, new ResourceMismatchDetector()),
    CLASS_INSTANCE_LIMIT("Class Instance Limit", 11, new ClassInstanceLimitDetector()),
    CLEARTEXT_NETWORK("Cleartext Network", 23, new CleartextNetworkDetector()),
    FILE_URI_EXPOSURE("File Uri Exposure", 18, new FileUriExposureDetector()),
    LEAKED_CLOSABLE_OBJECTS("Leaked Closable Objects", 11, new LeakedClosableObjectsDetector()),
    ACTIVITY_LEAKS("Activity Leaks", 11, null),
    LEAKED_REGISTRATION_OBJECTS("Leaked Registration_Objects", 16, null),
    LEAKED_SQL_LITE_OBJECTS("Leaked Sql Lite Objects", 9, null);

    public final String name;
    public final int minSdkVersion;
    public final Detector detector;

    private ViolationType(String name, int minSdkVersion, Detector detector) {
        this.name = name;
        this.minSdkVersion = minSdkVersion;
        this.detector = detector != null ? detector : new Detector(){

            @Override
            public boolean detect(StrictModeLog log) {
                return false;
            }
        };
    }

    public String violationName() {
        return this.name + " Violation";
    }
}

