/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.StyleSpan;
import android.view.MenuItem;
import android.widget.TextView;
import com.nshmura.strictmodenotifier.R;
import com.nshmura.strictmodenotifier.ReportActivityUtils;
import com.nshmura.strictmodenotifier.StrictModeViolation;
import java.io.Serializable;

public class StrictModeReportDetailActivity
extends Activity {
    private static final String EXTRA_REPORT = "EXTRA_REPORT";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.strictmode_notifier_activity_report_detail);
        StrictModeViolation report = (StrictModeViolation)this.getIntent().getSerializableExtra(EXTRA_REPORT);
        TextView stackTreace = (TextView)this.findViewById(R.id.__stacktrace_text);
        String stacktraceText = report.getStacktraceText();
        SpannableString span = new SpannableString((CharSequence)stacktraceText);
        this.setColor((Spannable)span, stacktraceText, this.getPackageName(), -1);
        stackTreace.setText((CharSequence)span);
        if (report.violationType != null) {
            ReportActivityUtils.setTitle(this, report.violationType.violationName());
            ReportActivityUtils.setDisplayHomeAsUpEnabled(this, true);
        }
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
            }
        }
        return super.onMenuItemSelected(featureId, item);
    }

    public static void start(Context context, StrictModeViolation report) {
        context.startActivity(StrictModeReportDetailActivity.createIntent(context, report));
    }

    public static Intent createIntent(Context context, StrictModeViolation report) {
        Intent intent = new Intent(context, StrictModeReportDetailActivity.class);
        intent.putExtra(EXTRA_REPORT, (Serializable)report);
        return intent;
    }

    public void setColor(Spannable span, String stacktraceText, String hilight, int color) {
        int index;
        int length = hilight.length();
        int start = 0;
        while ((index = stacktraceText.indexOf(hilight, start)) >= 0) {
            span.setSpan((Object)new StyleSpan(1), index, index + length, 18);
            span.setSpan((Object)new ForegroundColorSpan(color), index, index + length, 18);
            start = index + length;
        }
    }
}

