/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier.internal;

import com.nshmura.strictmodenotifier.internal.StrictModeLog;
import com.nshmura.strictmodenotifier.internal.detector.ClassInstanceLimitDetector;
import com.nshmura.strictmodenotifier.internal.detector.CleartextNetworkDetector;
import com.nshmura.strictmodenotifier.internal.detector.CustomSlowCallDetector;
import com.nshmura.strictmodenotifier.internal.detector.Detector;
import com.nshmura.strictmodenotifier.internal.detector.FileUriExposureDetector;
import com.nshmura.strictmodenotifier.internal.detector.LeakedClosableObjectsDetector;
import com.nshmura.strictmodenotifier.internal.detector.NetworkDetector;
import com.nshmura.strictmodenotifier.internal.detector.ResourceMismatchDetector;

public enum ViolationType {
    Custom_Slow_Call(11, new CustomSlowCallDetector()),
    Network(9, new NetworkDetector()),
    Resource_Mismatches(23, new ResourceMismatchDetector()),
    Class_Instance_Limit(11, new ClassInstanceLimitDetector()),
    Cleartext_Network(23, new CleartextNetworkDetector()),
    File_Uri_Exposure(18, new FileUriExposureDetector()),
    Leaked_Closable_Objects(11, new LeakedClosableObjectsDetector()),
    Activity_Leaks(11, null),
    Leaked_Registration_Objects(16, null),
    Leaked_Sql_Lite_Objects(9, null);

    public final int minSdkVersion;
    public final Detector detector;

    private ViolationType(int minSdkVersion, Detector detector) {
        this.minSdkVersion = minSdkVersion;
        this.detector = detector != null ? detector : new Detector(){

            @Override
            public boolean detect(StrictModeLog log) {
                return false;
            }
        };
    }

    public String violationName() {
        return this.name().replace("_", "") + " Violation";
    }
}

