/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier.internal;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.nshmura.strictmodenotifier.R;
import com.nshmura.strictmodenotifier.internal.ReportActivityUtils;
import com.nshmura.strictmodenotifier.internal.ReportAdapter;
import com.nshmura.strictmodenotifier.internal.ReportStore;
import com.nshmura.strictmodenotifier.internal.StrictModeReport;
import com.nshmura.strictmodenotifier.internal.StrictModeReportDetailActivity;
import java.io.Serializable;
import java.util.ArrayList;

public class StrictModeReportActivity
extends Activity {
    private static final String EXTRA_REPORT = "EXTRA_REPORT";
    private ReportAdapter adapter;
    private ReportStore reportStore;

    protected void onCreate(Bundle savedInstanceState) {
        StrictModeReport report;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.strictmode_notifier_activity_report);
        ReportActivityUtils.setTitle(this, this.getString(R.string.strictmode_notifier_title, new Object[]{this.getPackageName()}));
        this.adapter = new ReportAdapter(this);
        ListView listView = (ListView)this.findViewById(R.id.__list_view);
        listView.setAdapter((ListAdapter)this.adapter);
        this.reportStore = new ReportStore((Context)this);
        ArrayList<StrictModeReport> reports = this.reportStore.getAll();
        this.adapter.addAll(reports);
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                StrictModeReport report = StrictModeReportActivity.this.adapter.getItem(position);
                StrictModeReportDetailActivity.start((Context)StrictModeReportActivity.this, report);
            }
        });
        this.findViewById(R.id.__delete_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                StrictModeReportActivity.this.reportStore.clear();
                StrictModeReportActivity.this.adapter.clear();
                StrictModeReportActivity.this.adapter.notifyDataSetChanged();
            }
        });
        if (savedInstanceState == null && (report = (StrictModeReport)this.getIntent().getSerializableExtra(EXTRA_REPORT)) != null) {
            StrictModeReportDetailActivity.start((Context)this, report);
        }
    }

    public static Intent createIntent(Context context, StrictModeReport report) {
        Intent intent = new Intent(context, StrictModeReportActivity.class);
        intent.putExtra(EXTRA_REPORT, (Serializable)report);
        return intent;
    }

    public static PendingIntent createPendingIntent(Context context, StrictModeReport report) {
        Intent intent = StrictModeReportActivity.createIntent(context, report);
        intent.setFlags(0x14000000);
        return PendingIntent.getActivity((Context)context, (int)1, (Intent)intent, (int)0x8000000);
    }
}

