/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier.internal;

import android.content.Context;
import android.text.format.DateUtils;
import com.nshmura.strictmodenotifier.internal.ViolationType;
import java.io.Serializable;
import java.util.ArrayList;

class StrictModeReport
implements Serializable {
    public final ViolationType violationType;
    public final String note;
    public final String logKey;
    public final ArrayList<String> stacktreace;
    public final long time;

    public StrictModeReport(ViolationType violationType, String note, String logKey, ArrayList<String> stacktreace, long time) {
        this.violationType = violationType;
        this.note = note;
        this.logKey = logKey;
        this.stacktreace = stacktreace;
        this.time = time;
    }

    public String getDateText(Context context) {
        return DateUtils.formatDateTime((Context)context, (long)this.time, (int)17);
    }

    public String getStacktraceText() {
        StringBuilder builder = new StringBuilder();
        for (String line : this.stacktreace) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(line);
        }
        return builder.toString();
    }
}

