/*
 * Decompiled with CFR 0.152.
 */
package com.nshmura.strictmodenotifier.internal;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;
import com.nshmura.strictmodenotifier.R;
import com.nshmura.strictmodenotifier.internal.ReportStore;
import com.nshmura.strictmodenotifier.internal.StrictModeLog;
import com.nshmura.strictmodenotifier.internal.StrictModeNotifierInternals;
import com.nshmura.strictmodenotifier.internal.StrictModeReport;
import com.nshmura.strictmodenotifier.internal.StrictModeReportActivity;
import com.nshmura.strictmodenotifier.internal.ViolationType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class LogWatchService
extends Service {
    private static final String THREAD_NAME;
    private static final String TAG;
    private static final String LOGCAT_COMMAND = "logcat -v time -s StrictMode:* System.err:*";
    private static final String PARSE_REGEXP = "(StrictMode|System.err)(\\([ 0-9]+\\))?:";
    private static final CharSequence EXCEPTION_KEY;
    private static final long NOTIFICATION_DELY = 2000L;
    private static final long LOG_DELY = 1000L;
    private static final long ERROR_SLEEP = 1000L;
    private static final int MAX_ERROR_COUNT = 3;
    private Process proc;
    private int errorCount;
    private final ReportStore reportStore;
    private List<StrictModeLog> logs = new ArrayList<StrictModeLog>();
    private Timer timer = null;
    private ViolationType[] values = ViolationType.values();

    public LogWatchService() {
        this.reportStore = new ReportStore((Context)this);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogWatchService.this.readLoop();
            }
        }, THREAD_NAME).start();
        return 1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)TAG, (String)"onDestroy");
        if (this.proc != null) {
            this.proc.destroy();
            this.proc = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readLoop() {
        Log.d((String)TAG, (String)"start readLoop");
        BufferedReader reader = null;
        try {
            Runtime.getRuntime().exec("logcat -c");
            this.proc = Runtime.getRuntime().exec(LOGCAT_COMMAND);
            reader = new BufferedReader(new InputStreamReader(this.proc.getInputStream()), 1024);
            while (true) {
                String line;
                if ((line = reader.readLine()) != null && line.length() != 0) {
                    Log.d((String)TAG, (String)line);
                    StrictModeLog log = this.parseLine(line);
                    if (log == null) continue;
                    this.storeLog(log);
                    this.startReportTimer();
                    continue;
                }
                this.sleep();
                ++this.errorCount;
                if (this.errorCount > 3) break;
            }
            this.error("error limit exceeded");
        }
        catch (IOException e) {
            this.error(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        Log.d((String)TAG, (String)"readLoop end");
        this.stopSelf();
    }

    private StrictModeLog parseLine(String line) {
        String[] split = line.split(PARSE_REGEXP);
        if (split.length < 2) {
            return null;
        }
        if (split[1].equals("null")) {
            return null;
        }
        return new StrictModeLog(split[0], split[1], System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLog(StrictModeLog log) {
        LogWatchService logWatchService = this;
        synchronized (logWatchService) {
            this.logs.add(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReportTimer() {
        LogWatchService logWatchService = this;
        synchronized (logWatchService) {
            if (this.timer != null) {
                return;
            }
            this.timer = new Timer(true);
        }
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LogWatchService logWatchService = LogWatchService.this;
                synchronized (logWatchService) {
                    int count = LogWatchService.this.logs.size();
                    boolean prevIsAt = false;
                    long lastReadTime = 0L;
                    ArrayList<StrictModeLog> targets = new ArrayList<StrictModeLog>();
                    for (int i = 0; i < count; ++i) {
                        StrictModeLog log = (StrictModeLog)LogWatchService.this.logs.get(i);
                        boolean isAt = log.isAt();
                        if (!isAt && prevIsAt && targets.size() > 0) {
                            LogWatchService.this.reportLog(targets);
                            targets.clear();
                        }
                        prevIsAt = isAt;
                        targets.add(log);
                        lastReadTime = log.time;
                    }
                    if (targets.size() > 0 && System.currentTimeMillis() - lastReadTime >= 1000L) {
                        LogWatchService.this.reportLog(targets);
                        targets.clear();
                    }
                    LogWatchService.this.timer = null;
                    if (targets.size() > 0) {
                        LogWatchService.this.logs = targets;
                        LogWatchService.this.startReportTimer();
                    } else {
                        LogWatchService.this.logs.clear();
                    }
                }
            }
        }, 2000L);
    }

    private void reportLog(List<StrictModeLog> logs) {
        ArrayList<String> stacktreace = new ArrayList<String>(logs.size());
        String title = "";
        String logKey = "";
        long time = 0L;
        for (StrictModeLog log : logs) {
            if (TextUtils.isEmpty((CharSequence)title)) {
                title = log.message;
                logKey = log.tag;
                time = log.time;
                continue;
            }
            stacktreace.add(log.message);
        }
        ViolationType violationType = this.getViolationType(logs);
        if (violationType == null && logKey.contains(EXCEPTION_KEY)) {
            return;
        }
        StrictModeReport report = new StrictModeReport(violationType, title, logKey, stacktreace, time);
        try {
            this.reportStore.append(report);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String notificationTitle = report.violationType != null ? report.violationType.violationName() : this.getString(R.string.strictmode_notifier_title);
        StrictModeNotifierInternals.showNotification((Context)this, notificationTitle, this.getString(R.string.strictmode_notifier_more_detail), StrictModeReportActivity.createPendingIntent((Context)this, report));
    }

    private ViolationType getViolationType(List<StrictModeLog> logs) {
        for (StrictModeLog log : logs) {
            for (ViolationType type : this.values) {
                if (!type.detector.detect(log)) continue;
                return type;
            }
        }
        return null;
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void error(String message) {
        Log.e((String)TAG, (String)message);
    }

    static {
        TAG = THREAD_NAME = LogWatchService.class.getSimpleName();
        EXCEPTION_KEY = "System.err";
    }
}

