// auto-generated by sbt-boilerplate
/*
 * Copyright 2015 Nicolas Rinaudo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package kantan.csv

/** Provides [[RowEncoder]] instance construction methods. */
@SuppressWarnings(Array("org.wartremover.warts.OptionPartial"))
trait GeneratedRowEncoders {
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> RowEncoder.encoder((is: Ints) => (is.i1)).encode(Ints(1))
    * res0: Seq[String] = List(1)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`#
    */
  def encoder[C, A1: CellEncoder](f: C => A1): RowEncoder[C] =
    RowEncoder.from(c => List(CellEncoder[A1].encode(f(c))))

  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> RowEncoder.encoder(0, 1)((is: Ints) => (is.i1, is.i2)).encode(Ints(1, 2))
    * res1: Seq[String] = Vector(1, 2)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder](i1: Int, i2: Int)(f: C => Tuple2[A1, A2]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](2)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2)((is: Ints) => (is.i1, is.i2, is.i3)).encode(Ints(1, 2, 3))
    * res2: Seq[String] = Vector(1, 2, 3)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder](i1: Int, i2: Int, i3: Int)(f: C => Tuple3[A1, A2, A3]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](3)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3)((is: Ints) => (is.i1, is.i2, is.i3, is.i4)).encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = Vector(1, 2, 3, 4)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int)(f: C => Tuple4[A1, A2, A3, A4]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](4)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5)).encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = Vector(1, 2, 3, 4, 5)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)(f: C => Tuple5[A1, A2, A3, A4, A5]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](5)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6)).encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = Vector(1, 2, 3, 4, 5, 6)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)(f: C => Tuple6[A1, A2, A3, A4, A5, A6]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](6)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7)).encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)(f: C => Tuple7[A1, A2, A3, A4, A5, A6, A7]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](7)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)(f: C => Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](8)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)(f: C => Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](9)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)(f: C => Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](10)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)(f: C => Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](11)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)(f: C => Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](12)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)(f: C => Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](13)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)(f: C => Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](14)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)(f: C => Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](15)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)(f: C => Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](16)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest(i16) = CellEncoder[A16].encode(e._16)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)(f: C => Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](17)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest(i16) = CellEncoder[A16].encode(e._16)
      dest(i17) = CellEncoder[A17].encode(e._17)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)(f: C => Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](18)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest(i16) = CellEncoder[A16].encode(e._16)
      dest(i17) = CellEncoder[A17].encode(e._17)
      dest(i18) = CellEncoder[A18].encode(e._18)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)(f: C => Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](19)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest(i16) = CellEncoder[A16].encode(e._16)
      dest(i17) = CellEncoder[A17].encode(e._17)
      dest(i18) = CellEncoder[A18].encode(e._18)
      dest(i19) = CellEncoder[A19].encode(e._19)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)(f: C => Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](20)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest(i16) = CellEncoder[A16].encode(e._16)
      dest(i17) = CellEncoder[A17].encode(e._17)
      dest(i18) = CellEncoder[A18].encode(e._18)
      dest(i19) = CellEncoder[A19].encode(e._19)
      dest(i20) = CellEncoder[A20].encode(e._20)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)(f: C => Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](21)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest(i16) = CellEncoder[A16].encode(e._16)
      dest(i17) = CellEncoder[A17].encode(e._17)
      dest(i18) = CellEncoder[A18].encode(e._18)
      dest(i19) = CellEncoder[A19].encode(e._19)
      dest(i20) = CellEncoder[A20].encode(e._20)
      dest(i21) = CellEncoder[A21].encode(e._21)
      dest.toVector
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> RowEncoder.encoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21, is.i22)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    * }}}
    *
    * @param f encoding function.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f`
    * @param i22 index of the cell that should be passed as parameter number 22 of `f`
    */
  def encoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder, A22: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)(f: C => Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)
      val dest = new Array[String](22)

      dest(i1) = CellEncoder[A1].encode(e._1)
      dest(i2) = CellEncoder[A2].encode(e._2)
      dest(i3) = CellEncoder[A3].encode(e._3)
      dest(i4) = CellEncoder[A4].encode(e._4)
      dest(i5) = CellEncoder[A5].encode(e._5)
      dest(i6) = CellEncoder[A6].encode(e._6)
      dest(i7) = CellEncoder[A7].encode(e._7)
      dest(i8) = CellEncoder[A8].encode(e._8)
      dest(i9) = CellEncoder[A9].encode(e._9)
      dest(i10) = CellEncoder[A10].encode(e._10)
      dest(i11) = CellEncoder[A11].encode(e._11)
      dest(i12) = CellEncoder[A12].encode(e._12)
      dest(i13) = CellEncoder[A13].encode(e._13)
      dest(i14) = CellEncoder[A14].encode(e._14)
      dest(i15) = CellEncoder[A15].encode(e._15)
      dest(i16) = CellEncoder[A16].encode(e._16)
      dest(i17) = CellEncoder[A17].encode(e._17)
      dest(i18) = CellEncoder[A18].encode(e._18)
      dest(i19) = CellEncoder[A19].encode(e._19)
      dest(i20) = CellEncoder[A20].encode(e._20)
      dest(i21) = CellEncoder[A21].encode(e._21)
      dest(i22) = CellEncoder[A22].encode(e._22)
      dest.toVector
    }

  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1)).encode(Ints(1))
    * res0: Seq[String] = List(1)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder](f: C => A1): RowEncoder[C] =
    encoder(f)

  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2)).encode(Ints(1, 2))
    * res1: Seq[String] = Vector(1, 2)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder](f: C => Tuple2[A1, A2]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3)).encode(Ints(1, 2, 3))
    * res2: Seq[String] = Vector(1, 2, 3)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder](f: C => Tuple3[A1, A2, A3]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4)).encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = Vector(1, 2, 3, 4)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder](f: C => Tuple4[A1, A2, A3, A4]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5)).encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = Vector(1, 2, 3, 4, 5)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder](f: C => Tuple5[A1, A2, A3, A4, A5]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6)).encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = Vector(1, 2, 3, 4, 5, 6)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder](f: C => Tuple6[A1, A2, A3, A4, A5, A6]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7)).encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder](f: C => Tuple7[A1, A2, A3, A4, A5, A6, A7]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder](f: C => Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder](f: C => Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder](f: C => Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder](f: C => Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder](f: C => Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder](f: C => Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder](f: C => Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder](f: C => Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder](f: C => Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15) ,CellEncoder[A16].encode(e._16))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder](f: C => Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15) ,CellEncoder[A16].encode(e._16) ,CellEncoder[A17].encode(e._17))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder](f: C => Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15) ,CellEncoder[A16].encode(e._16) ,CellEncoder[A17].encode(e._17) ,CellEncoder[A18].encode(e._18))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder](f: C => Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15) ,CellEncoder[A16].encode(e._16) ,CellEncoder[A17].encode(e._17) ,CellEncoder[A18].encode(e._18) ,CellEncoder[A19].encode(e._19))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder](f: C => Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15) ,CellEncoder[A16].encode(e._16) ,CellEncoder[A17].encode(e._17) ,CellEncoder[A18].encode(e._18) ,CellEncoder[A19].encode(e._19) ,CellEncoder[A20].encode(e._20))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder](f: C => Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15) ,CellEncoder[A16].encode(e._16) ,CellEncoder[A17].encode(e._17) ,CellEncoder[A18].encode(e._18) ,CellEncoder[A19].encode(e._19) ,CellEncoder[A20].encode(e._20) ,CellEncoder[A21].encode(e._21))
    }
  /** Creates a new [[RowEncoder]] from the specified function.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> RowEncoder.ordered((is: Ints) => (is.i1, is.i2, is.i3, is.i4, is.i5, is.i6, is.i7, is.i8, is.i9, is.i10, is.i11, is.i12, is.i13, is.i14, is.i15, is.i16, is.i17, is.i18, is.i19, is.i20, is.i21, is.i22)).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    * }}}
    *
    */
  def ordered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder, A22: CellEncoder](f: C => Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]): RowEncoder[C] =
    RowEncoder.from { c =>
      val e = f(c)

      Vector(CellEncoder[A1].encode(e._1) ,CellEncoder[A2].encode(e._2) ,CellEncoder[A3].encode(e._3) ,CellEncoder[A4].encode(e._4) ,CellEncoder[A5].encode(e._5) ,CellEncoder[A6].encode(e._6) ,CellEncoder[A7].encode(e._7) ,CellEncoder[A8].encode(e._8) ,CellEncoder[A9].encode(e._9) ,CellEncoder[A10].encode(e._10) ,CellEncoder[A11].encode(e._11) ,CellEncoder[A12].encode(e._12) ,CellEncoder[A13].encode(e._13) ,CellEncoder[A14].encode(e._14) ,CellEncoder[A15].encode(e._15) ,CellEncoder[A16].encode(e._16) ,CellEncoder[A17].encode(e._17) ,CellEncoder[A18].encode(e._18) ,CellEncoder[A19].encode(e._19) ,CellEncoder[A20].encode(e._20) ,CellEncoder[A21].encode(e._21) ,CellEncoder[A22].encode(e._22))
    }

  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder1` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> RowEncoder.caseEncoder(Ints.unapply _).encode(Ints(1))
    * res0: Seq[String] = List(1)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`#
    */  def caseEncoder[C, A1: CellEncoder](f: C => Option[A1]): RowEncoder[C] =
    encoder(f andThen (_.get))

  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder2` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1)(Ints.unapply _).encode(Ints(1, 2))
    * res1: Seq[String] = Vector(1, 2)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder](i1: Int, i2: Int)(f: C => Option[Tuple2[A1, A2]]): RowEncoder[C] =
      encoder(i1, i2)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder3` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2)(Ints.unapply _).encode(Ints(1, 2, 3))
    * res2: Seq[String] = Vector(1, 2, 3)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder](i1: Int, i2: Int, i3: Int)(f: C => Option[Tuple3[A1, A2, A3]]): RowEncoder[C] =
      encoder(i1, i2, i3)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder4` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3)(Ints.unapply _).encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = Vector(1, 2, 3, 4)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int)(f: C => Option[Tuple4[A1, A2, A3, A4]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder5` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = Vector(1, 2, 3, 4, 5)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)(f: C => Option[Tuple5[A1, A2, A3, A4, A5]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder6` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = Vector(1, 2, 3, 4, 5, 6)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)(f: C => Option[Tuple6[A1, A2, A3, A4, A5, A6]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder7` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)(f: C => Option[Tuple7[A1, A2, A3, A4, A5, A6, A7]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder8` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)(f: C => Option[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder9` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)(f: C => Option[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder10` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)(f: C => Option[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder11` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)(f: C => Option[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder12` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)(f: C => Option[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder13` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)(f: C => Option[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder14` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)(f: C => Option[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder15` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)(f: C => Option[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder16` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)(f: C => Option[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder17` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)(f: C => Option[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder18` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)(f: C => Option[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder19` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)(f: C => Option[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder20` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)(f: C => Option[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder21` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)(f: C => Option[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21)(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * None`, which allows `caseEncoder22` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> RowEncoder.caseEncoder(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    * }}}
    *
    * @param f encoding method, intended to be a case class' `unapply` method.
    * @param i1 index of the cell that should be passed as parameter number 1 of `f`
    * @param i2 index of the cell that should be passed as parameter number 2 of `f`
    * @param i3 index of the cell that should be passed as parameter number 3 of `f`
    * @param i4 index of the cell that should be passed as parameter number 4 of `f`
    * @param i5 index of the cell that should be passed as parameter number 5 of `f`
    * @param i6 index of the cell that should be passed as parameter number 6 of `f`
    * @param i7 index of the cell that should be passed as parameter number 7 of `f`
    * @param i8 index of the cell that should be passed as parameter number 8 of `f`
    * @param i9 index of the cell that should be passed as parameter number 9 of `f`
    * @param i10 index of the cell that should be passed as parameter number 10 of `f`
    * @param i11 index of the cell that should be passed as parameter number 11 of `f`
    * @param i12 index of the cell that should be passed as parameter number 12 of `f`
    * @param i13 index of the cell that should be passed as parameter number 13 of `f`
    * @param i14 index of the cell that should be passed as parameter number 14 of `f`
    * @param i15 index of the cell that should be passed as parameter number 15 of `f`
    * @param i16 index of the cell that should be passed as parameter number 16 of `f`
    * @param i17 index of the cell that should be passed as parameter number 17 of `f`
    * @param i18 index of the cell that should be passed as parameter number 18 of `f`
    * @param i19 index of the cell that should be passed as parameter number 19 of `f`
    * @param i20 index of the cell that should be passed as parameter number 20 of `f`
    * @param i21 index of the cell that should be passed as parameter number 21 of `f`
    * @param i22 index of the cell that should be passed as parameter number 22 of `f`
    */
    def caseEncoder[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder, A22: CellEncoder](i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)(f: C => Option[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]]): RowEncoder[C] =
      encoder(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22)(f andThen (_.get))

  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1))
    * res0: Seq[String] = List(1)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
  def caseOrdered[C, A1: CellEncoder](f: C => Option[A1]): RowEncoder[C] =
    encoder(f andThen (_.get))

  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2))
    * res1: Seq[String] = Vector(1, 2)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder](f: C => Option[Tuple2[A1, A2]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3))
    * res2: Seq[String] = Vector(1, 2, 3)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder](f: C => Option[Tuple3[A1, A2, A3]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4))
    * res3: Seq[String] = Vector(1, 2, 3, 4)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder](f: C => Option[Tuple4[A1, A2, A3, A4]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5))
    * res4: Seq[String] = Vector(1, 2, 3, 4, 5)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder](f: C => Option[Tuple5[A1, A2, A3, A4, A5]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6))
    * res5: Seq[String] = Vector(1, 2, 3, 4, 5, 6)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder](f: C => Option[Tuple6[A1, A2, A3, A4, A5, A6]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7))
    * res6: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder](f: C => Option[Tuple7[A1, A2, A3, A4, A5, A6, A7]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8))
    * res7: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder](f: C => Option[Tuple8[A1, A2, A3, A4, A5, A6, A7, A8]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9))
    * res8: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder](f: C => Option[Tuple9[A1, A2, A3, A4, A5, A6, A7, A8, A9]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10))
    * res9: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder](f: C => Option[Tuple10[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11))
    * res10: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder](f: C => Option[Tuple11[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))
    * res11: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder](f: C => Option[Tuple12[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))
    * res12: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder](f: C => Option[Tuple13[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14))
    * res13: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder](f: C => Option[Tuple14[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15))
    * res14: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder](f: C => Option[Tuple15[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16))
    * res15: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder](f: C => Option[Tuple16[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17))
    * res16: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder](f: C => Option[Tuple17[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18))
    * res17: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder](f: C => Option[Tuple18[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19))
    * res18: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder](f: C => Option[Tuple19[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20))
    * res19: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder](f: C => Option[Tuple20[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21))
    * res20: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder](f: C => Option[Tuple21[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21]]): RowEncoder[C] =
      ordered(f andThen (_.get))
  /** Creates a new [[RowEncoder]] from the specified `unapply` method of a case class' companion object.
    *
    * This is meant for case classes and is unsafe for any other type: a case class' `unapply` method never returns
    * `None`, which allows `caseOrdered` to call `get` on the return value.
    *
    * For example:
    * {{{
    * scala> case class Ints(i1: Int, i2: Int, i3: Int, i4: Int, i5: Int, i6: Int, i7: Int, i8: Int, i9: Int, i10: Int, i11: Int, i12: Int, i13: Int, i14: Int, i15: Int, i16: Int, i17: Int, i18: Int, i19: Int, i20: Int, i21: Int, i22: Int)
    *
    * scala> RowEncoder.caseOrdered(Ints.unapply _).encode(Ints(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22))
    * res21: Seq[String] = Vector(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22)
    * }}}
    *
    * Consider using the `generics` kantan.csv module instead: it can automatically derive instances for this use case.
    */
    def caseOrdered[C, A1: CellEncoder, A2: CellEncoder, A3: CellEncoder, A4: CellEncoder, A5: CellEncoder, A6: CellEncoder, A7: CellEncoder, A8: CellEncoder, A9: CellEncoder, A10: CellEncoder, A11: CellEncoder, A12: CellEncoder, A13: CellEncoder, A14: CellEncoder, A15: CellEncoder, A16: CellEncoder, A17: CellEncoder, A18: CellEncoder, A19: CellEncoder, A20: CellEncoder, A21: CellEncoder, A22: CellEncoder](f: C => Option[Tuple22[A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15, A16, A17, A18, A19, A20, A21, A22]]): RowEncoder[C] =
      ordered(f andThen (_.get))
}
