/*
 * Decompiled with CFR 0.152.
 */
package com.noveogroup.debugdrawer;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public final class BuildConfigDto {
    private final String buildSource;
    private final String buildDate;
    private final String buildFlavor;
    private final String buildType;

    BuildConfigDto(Class buildConfigClass) {
        List<Field> fields = Arrays.asList(buildConfigClass.getDeclaredFields());
        this.buildSource = this.findByName(fields, "BUILD_SOURCE");
        this.buildDate = this.findByName(fields, "BUILD_DATE");
        this.buildFlavor = this.findByName(fields, "FLAVOR");
        this.buildType = this.findByName(fields, "BUILD_TYPE");
    }

    BuildConfigDto(String buildSource, String buildDate, String buildFlavor, String buildType) {
        this.buildSource = buildSource;
        this.buildDate = buildDate;
        this.buildFlavor = buildFlavor;
        this.buildType = buildType;
    }

    public String getBuildSource() {
        return this.buildSource;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public String getBuildFlavor() {
        return this.buildFlavor;
    }

    public String getBuildType() {
        return this.buildType;
    }

    private String findByName(List<Field> fields, String name) {
        try {
            for (Field field : fields) {
                if (!field.getName().equals(name)) continue;
                return (String)field.get(null);
            }
        }
        catch (IllegalAccessException error) {
            throw new IllegalArgumentException("Can't get field " + name, error);
        }
        throw new IllegalArgumentException("Can't find field " + name);
    }
}

