/*
 * Decompiled with CFR 0.152.
 */
package com.noveogroup.debugdrawer;

import android.text.TextUtils;
import com.noveogroup.debugdrawer.ConfigParam;
import com.noveogroup.debugdrawer.ConfigParamBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public final class Selector
extends ConfigParam<String> {
    final List<String> values;

    Selector(String name, String initialValue, String defaultValue, List<String> values) {
        super(name, (Object)initialValue, (Object)defaultValue);
        this.values = values;
    }

    public static SelectorBuilder builder(String name) {
        return new SelectorBuilder(name);
    }

    public List<String> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Selector selector = (Selector)((Object)o);
        return this.values != null ? this.values.equals(selector.values) : selector.values == null;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
        return result;
    }

    public static class SelectorBuilder
    extends ConfigParamBuilder<String, SelectorBuilder> {
        private final List<String> values = new ArrayList<String>();

        public SelectorBuilder(String name) {
            super(name);
        }

        private static String checkValue(String checkValue, List<String> values) {
            for (String value : values) {
                if (!TextUtils.equals((CharSequence)checkValue, (CharSequence)value)) continue;
                return checkValue;
            }
            throw new IllegalArgumentException("value not in list");
        }

        public SelectorBuilder addValue(String value) {
            this.values.add(value);
            return this.getThis();
        }

        public SelectorBuilder addValues(String ... values) {
            this.values.addAll(Arrays.asList(values));
            return this.getThis();
        }

        public SelectorBuilder getThis() {
            return this;
        }

        String resolveIfNull() {
            return this.values.get(0);
        }

        public Selector build() {
            super.build();
            return new Selector(this.name, SelectorBuilder.checkValue((String)this.initialValue, this.values), SelectorBuilder.checkValue((String)this.releaseValue, this.values), new ArrayList<String>(new LinkedHashSet<String>(this.values)));
        }
    }
}

