/*
 * Decompiled with CFR 0.152.
 */
package com.noveogroup.debugdrawer;

import com.noveogroup.debugdrawer.SupportDebugModule;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;

final class Utils {
    private static final Set<String> MODULES = new TreeSet<String>();
    private static boolean debug;

    private Utils() {
    }

    static void registerModule(SupportDebugModule debugModule) {
        String name = debugModule.getClass().getName();
        if (debug && !MODULES.contains(name)) {
            MODULES.add(name);
            Utils.log(debugModule.logger, debugModule.getDebugInfo(), new Object[0]);
        }
    }

    static void enableDebug() {
        debug = true;
    }

    @SafeVarargs
    static <T> T firstNonNull(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return object;
        }
        throw new NullPointerException("None of set non null");
    }

    static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    static void log(Logger logger, String message, Object ... args) {
        if (debug) {
            logger.debug(message, args);
        }
    }

    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }
}

