/*
 * Decompiled with CFR 0.152.
 */
package com.novasa.touchscaler;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.os.Build;
import android.util.SizeF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import androidx.core.view.ViewCompat;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FlingAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import com.novasa.touchscaler.ExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 l2\u00020\u0001:\u0006lmnopqB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010J\u001a\u00020KH\u0002J\u000e\u0010L\u001a\u00020K2\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020KH\u0002J\b\u0010P\u001a\u00020KH\u0002J\b\u0010Q\u001a\u00020KH\u0002J \u0010R\u001a\u00020\f2\u0006\u0010S\u001a\u00020\f2\u0006\u0010T\u001a\u00020\f2\u0006\u0010U\u001a\u00020\fH\u0002J \u0010R\u001a\u00020\u00122\u0006\u0010S\u001a\u00020\u00122\u0006\u0010T\u001a\u00020\u00122\u0006\u0010U\u001a\u00020\u0012H\u0002J\b\u0010V\u001a\u00020KH\u0002J<\u0010W\u001a\u00020\u001e2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00030Y2\u0006\u0010T\u001a\u00020\u00122\u0006\u0010U\u001a\u00020\u00122\u0006\u0010S\u001a\u00020\u00122\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020K0[H\u0002J\u0018\u0010\\\u001a\u00020K2\u0006\u0010]\u001a\u00020\u00122\u0006\u0010^\u001a\u00020\u0012H\u0002J\u0018\u0010_\u001a\u00020\f2\u0006\u0010`\u001a\u00020\f2\u0006\u0010a\u001a\u00020\u0012H\u0002J\b\u0010b\u001a\u00020KH\u0002J\b\u0010c\u001a\u00020KH\u0002J\u0018\u0010d\u001a\u00020$2\u0006\u0010S\u001a\u00020\u00032\u0006\u0010e\u001a\u00020fH\u0016J\b\u0010g\u001a\u00020KH\u0002J\u0010\u0010g\u001a\u00020K2\u0006\u0010M\u001a\u00020NH\u0002J\u0018\u0010a\u001a\u00020K2\u0006\u0010h\u001a\u00020\u00122\u0006\u0010`\u001a\u00020\fH\u0002J\u0018\u0010i\u001a\u00020\f2\u0006\u0010D\u001a\u00020\f2\u0006\u0010a\u001a\u00020\u0012H\u0002J\u0006\u0010M\u001a\u00020NJ\b\u0010j\u001a\u00020KH\u0002J\b\u0010k\u001a\u00020KH\u0002R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u000f\"\u0004\b\u001a\u0010\u0011R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010 \u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010\u0011R\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010%R$\u0010'\u001a\u00020&2\u0006\u0010\u0005\u001a\u00020&@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001c\u00102\u001a\u0004\u0018\u000103X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u000e\u00108\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020;X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010<\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0015\"\u0004\b>\u0010\u0017R\u001a\u0010?\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0015\"\u0004\bA\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u000e\u0010D\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010G\u001a\u0004\u0018\u00010HX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006r"}, d2={"Lcom/novasa/touchscaler/TouchScaler;", "Landroid/view/View$OnTouchListener;", "targetView", "Landroid/view/View;", "(Landroid/view/View;)V", "value", "Landroid/util/SizeF;", "contentSize", "getContentSize", "()Landroid/util/SizeF;", "setContentSize", "(Landroid/util/SizeF;)V", "Landroid/graphics/PointF;", "currentFocusPoint", "getCurrentFocusPoint", "()Landroid/graphics/PointF;", "setCurrentFocusPoint", "(Landroid/graphics/PointF;)V", "", "currentScale", "getCurrentScale", "()F", "setCurrentScale", "(F)V", "currentTranslation", "getCurrentTranslation", "setCurrentTranslation", "flingDetector", "Landroid/view/GestureDetector;", "flingX", "Landroidx/dynamicanimation/animation/FlingAnimation;", "flingY", "focusPointOffset", "getFocusPointOffset", "setFocusPointOffset", "isFlinging", "", "()Z", "Lcom/novasa/touchscaler/TouchScaler$Mode;", "mode", "getMode", "()Lcom/novasa/touchscaler/TouchScaler$Mode;", "setMode", "(Lcom/novasa/touchscaler/TouchScaler$Mode;)V", "onChangeListener", "Lcom/novasa/touchscaler/TouchScaler$OnChangeListener;", "getOnChangeListener", "()Lcom/novasa/touchscaler/TouchScaler$OnChangeListener;", "setOnChangeListener", "(Lcom/novasa/touchscaler/TouchScaler$OnChangeListener;)V", "onModeChangeListener", "Lcom/novasa/touchscaler/TouchScaler$OnModeChangeListener;", "getOnModeChangeListener", "()Lcom/novasa/touchscaler/TouchScaler$OnModeChangeListener;", "setOnModeChangeListener", "(Lcom/novasa/touchscaler/TouchScaler$OnModeChangeListener;)V", "prevEventPosition", "prevScaleFocus", "scaleDetector", "Landroid/view/ScaleGestureDetector;", "scaleMax", "getScaleMax", "setScaleMax", "scaleMin", "getScaleMin", "setScaleMin", "getTargetView", "()Landroid/view/View;", "translation", "translationMax", "translationMin", "updateAnimator", "Lcom/novasa/touchscaler/TouchScaler$UpdateAnimator;", "viewSize", "applyTranslation", "", "applyUpdate", "update", "Lcom/novasa/touchscaler/TouchScaler$Update;", "cancelAnimations", "cancelFling", "cancelUpdate", "clamp", "v", "min", "max", "clampTranslation", "createFlingAnimation", "property", "Landroidx/dynamicanimation/animation/FloatPropertyCompat;", "onEnd", "Lkotlin/Function0;", "fling", "vx", "vy", "focusPointToTranslation", "focus", "scale", "notifyChange", "onFlingEnded", "onTouch", "event", "Landroid/view/MotionEvent;", "onUpdateEnd", "factor", "translationToFocusPoint", "updateSize", "updateTranslationBoundaries", "Companion", "Mode", "OnChangeListener", "OnModeChangeListener", "Update", "UpdateAnimator", "touchscaler_release"})
public final class TouchScaler
implements View.OnTouchListener {
    @NotNull
    private SizeF contentSize;
    private SizeF viewSize;
    @NotNull
    private Mode mode;
    @NotNull
    private PointF focusPointOffset;
    @Nullable
    private OnChangeListener onChangeListener;
    @Nullable
    private OnModeChangeListener onModeChangeListener;
    private PointF prevEventPosition;
    private final PointF translation;
    private final PointF translationMin;
    private final PointF translationMax;
    private float scaleMin;
    private float scaleMax;
    private PointF prevScaleFocus;
    private final ScaleGestureDetector scaleDetector;
    private FlingAnimation flingX;
    private FlingAnimation flingY;
    private final GestureDetector flingDetector;
    private UpdateAnimator updateAnimator;
    @NotNull
    private final View targetView;
    private static final String TAG = "TouchScaler";
    private static final float DEFAULT_SCALE_MIN = 1.0f;
    private static final float DEFAULT_SCALE_MAX = 3.0f;
    private static final long DEFAULT_ANIMATION_DURATION = 300L;
    private static final DecelerateInterpolator DEFAULT_INTERPOLATOR;
    private static final SizeF SIZE_NONE;
    private static final PointF ORIGIN;
    public static final Companion Companion;

    @NotNull
    public final SizeF getContentSize() {
        return this.contentSize;
    }

    public final void setContentSize(@NotNull SizeF value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.contentSize = new SizeF(value.getWidth(), value.getHeight());
        this.updateSize();
    }

    private final void updateSize() {
        if (this.contentSize.getWidth() == 0.0f || this.contentSize.getHeight() == 0.0f) {
            View $this$doOnLayout$iv = this.targetView;
            boolean $i$f$doOnLayout = false;
            if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
                View it = $this$doOnLayout$iv;
                boolean bl = false;
                this.setContentSize(new SizeF((float)this.getTargetView().getWidth(), (float)this.getTargetView().getHeight()));
            } else {
                View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
                boolean $i$f$doOnNextLayout = false;
                $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
                    final /* synthetic */ TouchScaler this$0;
                    {
                        this.this$0 = touchScaler;
                    }

                    public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                        View it = view;
                        boolean bl = false;
                        View it2 = it;
                        boolean bl2 = false;
                        this.this$0.setContentSize(new SizeF((float)this.this$0.getTargetView().getWidth(), (float)this.this$0.getTargetView().getHeight()));
                    }
                });
            }
            return;
        }
        View $this$doOnLayout$iv = this.targetView;
        boolean $i$f$doOnLayout = false;
        boolean it = false;
        View $this$apply = $this$doOnLayout$iv;
        boolean bl = false;
        ViewGroup.LayoutParams lp = $this$apply.getLayoutParams();
        lp.width = MathKt.roundToInt((float)this.contentSize.getWidth());
        lp.height = MathKt.roundToInt((float)this.contentSize.getHeight());
        $this$apply.setLayoutParams(lp);
        $this$doOnLayout$iv = this.targetView;
        $i$f$doOnLayout = false;
        if (ViewCompat.isLaidOut((View)$this$doOnLayout$iv) && !$this$doOnLayout$iv.isLayoutRequested()) {
            SizeF sizeF;
            View it2 = $this$doOnLayout$iv;
            boolean bl2 = false;
            TouchScaler touchScaler = this;
            ViewParent viewParent = this.getTargetView().getParent();
            if (!(viewParent instanceof View)) {
                viewParent = null;
            }
            View view = (View)viewParent;
            if (view != null) {
                View view2 = view;
                TouchScaler touchScaler2 = touchScaler;
                boolean bl3 = false;
                boolean bl4 = false;
                View parent = view2;
                boolean bl5 = false;
                SizeF sizeF2 = new SizeF((float)parent.getWidth(), (float)parent.getHeight());
                touchScaler = touchScaler2;
                sizeF = sizeF2;
            } else {
                sizeF = new SizeF(0.0f, 0.0f);
            }
            touchScaler.viewSize = sizeF;
            this.updateTranslationBoundaries();
            this.setCurrentTranslation(this.focusPointToTranslation(new PointF(this.getContentSize().getWidth() * 0.5f, this.getContentSize().getHeight() * 0.5f), this.getCurrentScale()));
        } else {
            View $this$doOnNextLayout$iv$iv = $this$doOnLayout$iv;
            boolean $i$f$doOnNextLayout = false;
            $this$doOnNextLayout$iv$iv.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
                final /* synthetic */ TouchScaler this$0;
                {
                    this.this$0 = touchScaler;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    SizeF sizeF;
                    Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                    view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    View it = view;
                    boolean bl = false;
                    View it2 = it;
                    boolean bl2 = false;
                    TouchScaler touchScaler = this.this$0;
                    ViewParent viewParent = this.this$0.getTargetView().getParent();
                    if (!(viewParent instanceof View)) {
                        viewParent = null;
                    }
                    View view2 = (View)viewParent;
                    if (view2 != null) {
                        View view3 = view2;
                        TouchScaler touchScaler2 = touchScaler;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        View parent = view3;
                        boolean bl5 = false;
                        SizeF sizeF2 = new SizeF((float)parent.getWidth(), (float)parent.getHeight());
                        touchScaler = touchScaler2;
                        sizeF = sizeF2;
                    } else {
                        sizeF = new SizeF(0.0f, 0.0f);
                    }
                    TouchScaler.access$setViewSize$p(touchScaler, sizeF);
                    TouchScaler.access$updateTranslationBoundaries(this.this$0);
                    TouchScaler.access$setCurrentTranslation$p(this.this$0, TouchScaler.access$focusPointToTranslation(this.this$0, new PointF(this.this$0.getContentSize().getWidth() * 0.5f, this.this$0.getContentSize().getHeight() * 0.5f), this.this$0.getCurrentScale()));
                }
            });
        }
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    private final void setMode(Mode value) {
        block1: {
            if (value == this.mode) break block1;
            this.mode = value;
            OnModeChangeListener onModeChangeListener = this.onModeChangeListener;
            if (onModeChangeListener != null) {
                onModeChangeListener.onTouchScalerModeChange(this, value);
            }
        }
    }

    @NotNull
    public final PointF getFocusPointOffset() {
        return this.focusPointOffset;
    }

    public final void setFocusPointOffset(@NotNull PointF value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.mode != Mode.ANIMATE) {
            PointF focusPoint = this.getCurrentFocusPoint();
            this.focusPointOffset = value;
            this.setCurrentFocusPoint(focusPoint);
        } else {
            this.focusPointOffset = value;
        }
    }

    @NotNull
    public final PointF getCurrentFocusPoint() {
        return this.translationToFocusPoint(this.getCurrentTranslation(), this.getCurrentScale());
    }

    private final void setCurrentFocusPoint(PointF value) {
        this.setCurrentTranslation(this.focusPointToTranslation(value, this.getCurrentScale()));
    }

    @Nullable
    public final OnChangeListener getOnChangeListener() {
        return this.onChangeListener;
    }

    public final void setOnChangeListener(@Nullable OnChangeListener onChangeListener) {
        this.onChangeListener = onChangeListener;
    }

    @Nullable
    public final OnModeChangeListener getOnModeChangeListener() {
        return this.onModeChangeListener;
    }

    public final void setOnModeChangeListener(@Nullable OnModeChangeListener onModeChangeListener) {
        this.onModeChangeListener = onModeChangeListener;
    }

    private final void notifyChange() {
        block0: {
            OnChangeListener onChangeListener = this.onChangeListener;
            if (onChangeListener == null) break block0;
            onChangeListener.onTouchScalerChange(this);
        }
    }

    private final void cancelAnimations() {
        this.cancelUpdate();
        this.cancelFling();
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getPointerCount() > 2) {
            this.setMode(Mode.NONE);
            v.getParent().requestDisallowInterceptTouchEvent(false);
            return false;
        }
        int action = event.getActionMasked();
        PointF eventPosition = new PointF(event.getRawX(), event.getRawY());
        switch (action) {
            case 0: {
                v.getParent().requestDisallowInterceptTouchEvent(true);
                this.setMode(Mode.DRAG);
                this.cancelAnimations();
                break;
            }
            case 5: {
                this.setMode(Mode.ZOOM);
                break;
            }
            case 2: {
                if (this.mode != Mode.DRAG) break;
                float f = eventPosition.x;
                PointF pointF = this.prevEventPosition;
                if (pointF == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"prevEventPosition");
                }
                this.translation.x = f - pointF.x;
                float f2 = eventPosition.y;
                PointF pointF2 = this.prevEventPosition;
                if (pointF2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"prevEventPosition");
                }
                this.translation.y = f2 - pointF2.y;
                break;
            }
            case 6: {
                this.setMode(Mode.DRAG);
                this.prevScaleFocus = null;
                int index = event.getActionIndex() ^ 1;
                if (index == 0) break;
                if (Build.VERSION.SDK_INT >= 29) {
                    eventPosition.x = event.getRawX(index);
                    eventPosition.y = event.getRawY(index);
                    break;
                }
                int[] location = new int[2];
                v.getLocationOnScreen(location);
                eventPosition.x = event.getX(index) + (float)location[0];
                eventPosition.y = event.getY(index) + (float)location[1];
            }
        }
        this.scaleDetector.onTouchEvent(event);
        this.flingDetector.onTouchEvent(event);
        if (this.mode != Mode.NONE) {
            this.applyTranslation();
        }
        switch (action) {
            case 1: 
            case 3: {
                if (!this.isFlinging()) {
                    this.setMode(Mode.NONE);
                }
                v.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        this.prevEventPosition = eventPosition;
        return true;
    }

    @NotNull
    public final PointF getCurrentTranslation() {
        return new PointF(this.targetView.getX(), this.targetView.getY());
    }

    private final void setCurrentTranslation(PointF value) {
        View view = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        View $this$run = view;
        boolean bl3 = false;
        $this$run.setX(value.x);
        $this$run.setY(value.y);
    }

    private final void updateTranslationBoundaries() {
        this.translationMin.x = -this.contentSize.getWidth() * this.getCurrentScale() + this.viewSize.getWidth();
        this.translationMin.y = -this.contentSize.getHeight() * this.getCurrentScale() + this.viewSize.getHeight();
        this.translationMax.x = 0.0f;
        this.translationMax.y = 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyTranslation() {
        void p$iv;
        void $this$plus$iv;
        View view = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        TouchScaler touchScaler = this;
        PointF pointF = touchScaler.getCurrentTranslation();
        PointF pointF2 = this.translation;
        TouchScaler touchScaler2 = touchScaler;
        boolean $i$f$plus = false;
        PointF pointF3 = new PointF($this$plus$iv.x, $this$plus$iv.y);
        boolean bl4 = false;
        boolean bl5 = false;
        PointF $this$apply$iv = pointF3;
        boolean bl6 = false;
        $this$apply$iv.offset(p$iv.x, p$iv.y);
        PointF pointF4 = pointF3;
        touchScaler2.setCurrentTranslation(pointF4);
        this.clampTranslation();
        this.notifyChange();
        this.translation.x = 0.0f;
        this.translation.y = 0.0f;
    }

    private final void clampTranslation() {
        this.setCurrentTranslation(this.clamp(this.getCurrentTranslation(), this.translationMin, this.translationMax));
    }

    public final float getScaleMin() {
        return this.scaleMin;
    }

    public final void setScaleMin(float f) {
        this.scaleMin = f;
    }

    public final float getScaleMax() {
        return this.scaleMax;
    }

    public final void setScaleMax(float f) {
        this.scaleMax = f;
    }

    public final float getCurrentScale() {
        return this.targetView.getScaleX();
    }

    public final void setCurrentScale(float value) {
        View view = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        $this$apply.setScaleX(value);
        $this$apply.setScaleY(value);
        this.updateTranslationBoundaries();
    }

    private final void scale(float factor, PointF focus) {
        PointF pointF;
        float scaled;
        float s1;
        block5: {
            block4: {
                float s0 = this.getCurrentScale();
                s1 = this.clamp(s0 * factor, this.scaleMin, this.scaleMax);
                scaled = s1 / s0 - 1.0f;
                pointF = this.prevScaleFocus;
                if (pointF == null) break block4;
                PointF pointF2 = pointF;
                boolean bl = false;
                boolean bl2 = false;
                PointF it = pointF2;
                boolean bl3 = false;
                pointF = ExtensionsKt.minus(focus, it);
                if (pointF != null) break block5;
            }
            pointF = ORIGIN;
        }
        PointF dFocus = pointF;
        PointF currentTranslation = this.getCurrentTranslation();
        this.translation.x = (currentTranslation.x - focus.x) * scaled + dFocus.x;
        this.translation.y = (currentTranslation.y - focus.y) * scaled + dFocus.y;
        if (s1 != this.getCurrentScale()) {
            this.setCurrentScale(s1);
        }
        this.prevScaleFocus = focus;
    }

    private final boolean isFlinging() {
        return this.flingX != null || this.flingY != null;
    }

    private final void fling(float vx, float vy) {
        this.setMode(Mode.FLING);
        DynamicAnimation.ViewProperty viewProperty = DynamicAnimation.X;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewProperty, (String)"DynamicAnimation.X");
        this.flingX = this.createFlingAnimation((FloatPropertyCompat<View>)((FloatPropertyCompat)viewProperty), this.translationMin.x, this.translationMax.x, vx, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TouchScaler this$0;

            public final void invoke() {
                TouchScaler.access$setFlingX$p(this.this$0, null);
            }
            {
                this.this$0 = touchScaler;
                super(0);
            }
        }));
        DynamicAnimation.ViewProperty viewProperty2 = DynamicAnimation.Y;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewProperty2, (String)"DynamicAnimation.Y");
        this.flingY = this.createFlingAnimation((FloatPropertyCompat<View>)((FloatPropertyCompat)viewProperty2), this.translationMin.y, this.translationMax.y, vy, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TouchScaler this$0;

            public final void invoke() {
                TouchScaler.access$setFlingY$p(this.this$0, null);
            }
            {
                this.this$0 = touchScaler;
                super(0);
            }
        }));
    }

    private final FlingAnimation createFlingAnimation(FloatPropertyCompat<View> property, float min, float max, float v, Function0<Unit> onEnd) {
        FlingAnimation flingAnimation = new FlingAnimation((Object)this.targetView, property);
        boolean bl = false;
        boolean bl2 = false;
        FlingAnimation $this$apply = flingAnimation;
        boolean bl3 = false;
        $this$apply.setMinValue(min);
        $this$apply.setMaxValue(max);
        $this$apply.setStartVelocity(v);
        $this$apply.setFriction(1.1f);
        $this$apply.addEndListener(new DynamicAnimation.OnAnimationEndListener(this, min, max, v, onEnd){
            final /* synthetic */ TouchScaler this$0;
            final /* synthetic */ float $min$inlined;
            final /* synthetic */ float $max$inlined;
            final /* synthetic */ float $v$inlined;
            final /* synthetic */ Function0 $onEnd$inlined;
            {
                this.this$0 = touchScaler;
                this.$min$inlined = f;
                this.$max$inlined = f2;
                this.$v$inlined = f3;
                this.$onEnd$inlined = function0;
            }

            public final void onAnimationEnd(DynamicAnimation<DynamicAnimation<?>> $noName_0, boolean $noName_1, float $noName_2, float $noName_3) {
                this.$onEnd$inlined.invoke();
                TouchScaler.access$onFlingEnded(this.this$0);
            }
        });
        $this$apply.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(this, min, max, v, onEnd){
            final /* synthetic */ TouchScaler this$0;
            final /* synthetic */ float $min$inlined;
            final /* synthetic */ float $max$inlined;
            final /* synthetic */ float $v$inlined;
            final /* synthetic */ Function0 $onEnd$inlined;
            {
                this.this$0 = touchScaler;
                this.$min$inlined = f;
                this.$max$inlined = f2;
                this.$v$inlined = f3;
                this.$onEnd$inlined = function0;
            }

            public final void onAnimationUpdate(DynamicAnimation<DynamicAnimation<?>> $noName_0, float $noName_1, float $noName_2) {
                TouchScaler.access$notifyChange(this.this$0);
            }
        });
        $this$apply.start();
        return flingAnimation;
    }

    private final void cancelFling() {
        block1: {
            Unit $this$run;
            boolean bl;
            boolean bl2;
            Unit unit;
            FlingAnimation flingAnimation = this.flingX;
            if (flingAnimation != null) {
                flingAnimation.cancel();
                unit = Unit.INSTANCE;
                bl2 = false;
                bl = false;
                $this$run = unit;
                boolean bl3 = false;
                this.flingX = null;
                this.onFlingEnded();
            }
            FlingAnimation flingAnimation2 = this.flingY;
            if (flingAnimation2 == null) break block1;
            flingAnimation2.cancel();
            unit = Unit.INSTANCE;
            bl2 = false;
            bl = false;
            $this$run = unit;
            boolean bl4 = false;
            this.flingY = null;
            this.onFlingEnded();
        }
    }

    private final void onFlingEnded() {
        if (this.isFlinging() && this.mode == Mode.FLING) {
            this.setMode(Mode.NONE);
        }
    }

    @NotNull
    public final Update update() {
        Update update = new Update();
        boolean bl = false;
        boolean bl2 = false;
        Update it = update;
        boolean bl3 = false;
        this.targetView.post(new Runnable(it, this){
            final /* synthetic */ Update $it;
            final /* synthetic */ TouchScaler this$0;
            {
                this.$it = update;
                this.this$0 = touchScaler;
            }

            public final void run() {
                this.this$0.applyUpdate(this.$it);
            }
        });
        return update;
    }

    public final void applyUpdate(@NotNull Update update) {
        boolean bl;
        long duration;
        PointF pointF;
        Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
        this.cancelFling();
        Float f = update.getScale$touchscaler_release();
        float s1 = f != null ? f.floatValue() : this.getCurrentScale();
        PointF pointF2 = update.getPosition$touchscaler_release();
        if (pointF2 != null) {
            PointF pointF3 = pointF2;
            boolean bl2 = false;
            boolean bl3 = false;
            PointF it = pointF3;
            boolean bl4 = false;
            PointF pointF4 = new PointF(it.x, it.y);
            boolean bl5 = false;
            boolean bl6 = false;
            PointF p12 = pointF4;
            boolean bl7 = false;
            if (update.getRelative$touchscaler_release()) {
                ExtensionsKt.timesAssign(p12, this.contentSize);
            }
            this.focusPointToTranslation(p12, s1);
            pointF = pointF4;
        } else {
            pointF = null;
        }
        PointF p1 = pointF;
        Long l = update.getDuration$touchscaler_release();
        long l2 = duration = l != null ? l : 0L;
        if (duration > 0L) {
            UpdateAnimator updateAnimator;
            UpdateAnimator updateAnimator2 = new UpdateAnimator();
            TouchScaler touchScaler = this;
            boolean bl8 = false;
            bl = false;
            UpdateAnimator $this$apply = updateAnimator2;
            boolean bl9 = false;
            $this$apply.setDuration(duration);
            TimeInterpolator timeInterpolator = update.getInterpolator$touchscaler_release();
            if (timeInterpolator == null) {
                timeInterpolator = (TimeInterpolator)DEFAULT_INTERPOLATOR;
            }
            $this$apply.setInterpolator(timeInterpolator);
            Long l3 = update.getDelay$touchscaler_release();
            if (l3 != null) {
                Long l4 = l3;
                boolean p12 = false;
                boolean bl10 = false;
                long delay = ((Number)l4).longValue();
                boolean bl11 = false;
                $this$apply.setStartDelay(delay);
            }
            float s0 = this.getCurrentScale();
            PointF p0 = this.getCurrentFocusPoint();
            $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(s0, p0, this, duration, update, s1, p1){
                final /* synthetic */ float $s0;
                final /* synthetic */ PointF $p0;
                final /* synthetic */ TouchScaler this$0;
                final /* synthetic */ long $duration$inlined;
                final /* synthetic */ Update $update$inlined;
                final /* synthetic */ float $s1$inlined;
                final /* synthetic */ PointF $p1$inlined;
                {
                    this.$s0 = f;
                    this.$p0 = pointF;
                    this.this$0 = touchScaler;
                    this.$duration$inlined = l;
                    this.$update$inlined = update;
                    this.$s1$inlined = f2;
                    this.$p1$inlined = pointF2;
                }

                public final void onAnimationUpdate(ValueAnimator animator) {
                    ValueAnimator valueAnimator = animator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
                    float f = valueAnimator.getAnimatedFraction();
                    float s = f * (this.$s1$inlined - this.$s0) + this.$s0;
                    if (this.$s1$inlined != this.$s0) {
                        this.this$0.setCurrentScale(s);
                    }
                    PointF pointF = this.$p1$inlined;
                    if (pointF != null) {
                        PointF pointF2 = pointF;
                        boolean bl = false;
                        boolean bl2 = false;
                        PointF p1 = pointF2;
                        boolean bl3 = false;
                        PointF pointF3 = new PointF();
                        boolean bl4 = false;
                        boolean bl5 = false;
                        PointF $this$apply = pointF3;
                        boolean bl6 = false;
                        $this$apply.x = f * (p1.x - this.$p0.x) + this.$p0.x;
                        $this$apply.y = f * (p1.y - this.$p0.y) + this.$p0.y;
                        PointF p = pointF3;
                        TouchScaler.access$setCurrentTranslation$p(this.this$0, TouchScaler.access$focusPointToTranslation(this.this$0, p, s));
                    }
                    TouchScaler.access$clampTranslation(this.this$0);
                    TouchScaler.access$notifyChange(this.this$0);
                }
            });
            $this$apply.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, duration, update, s1, p1){
                final /* synthetic */ TouchScaler this$0;
                final /* synthetic */ long $duration$inlined;
                final /* synthetic */ Update $update$inlined;
                final /* synthetic */ float $s1$inlined;
                final /* synthetic */ PointF $p1$inlined;
                {
                    this.this$0 = touchScaler;
                    this.$duration$inlined = l;
                    this.$update$inlined = update;
                    this.$s1$inlined = f;
                    this.$p1$inlined = pointF;
                }

                public void onAnimationStart(@NotNull Animator animation) {
                    Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                    TouchScaler.access$setMode$p(this.this$0, Mode.ANIMATE);
                }

                public void onAnimationEnd(@NotNull Animator animation) {
                    block2: {
                        Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                        TouchScaler.access$setUpdateAnimator$p(this.this$0, null);
                        Animator animator = animation;
                        if (!(animator instanceof UpdateAnimator)) {
                            animator = null;
                        }
                        UpdateAnimator updateAnimator = (UpdateAnimator)animator;
                        if (updateAnimator == null) break block2;
                        UpdateAnimator updateAnimator2 = updateAnimator;
                        boolean bl = false;
                        boolean bl2 = false;
                        UpdateAnimator it = updateAnimator2;
                        boolean bl3 = false;
                        if (!it.isCancelled()) {
                            TouchScaler.access$onUpdateEnd(this.this$0, this.$update$inlined);
                        }
                    }
                }
            });
            $this$apply.start();
            touchScaler.updateAnimator = updateAnimator = updateAnimator2;
        } else {
            if (s1 != this.getCurrentScale()) {
                this.setCurrentScale(s1);
            }
            PointF pointF5 = p1;
            if (pointF5 != null) {
                PointF pointF6 = pointF5;
                boolean bl12 = false;
                bl = false;
                PointF it = pointF6;
                boolean bl13 = false;
                this.setCurrentTranslation(this.focusPointToTranslation(it, this.getCurrentScale()));
            }
            this.clampTranslation();
            this.notifyChange();
            this.onUpdateEnd(update);
        }
    }

    private final void onUpdateEnd(Update update) {
        Update update2 = update.getNext$touchscaler_release();
        if (update2 != null) {
            Update update3 = update2;
            boolean bl = false;
            boolean bl2 = false;
            Update next = update3;
            boolean bl3 = false;
            this.applyUpdate(next);
        } else {
            this.onUpdateEnd();
        }
    }

    private final void onUpdateEnd() {
        if (this.mode == Mode.ANIMATE) {
            this.setMode(Mode.NONE);
        }
    }

    private final void cancelUpdate() {
        UpdateAnimator updateAnimator = this.updateAnimator;
        if (updateAnimator != null) {
            updateAnimator.cancel();
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            boolean bl3 = false;
            this.updateAnimator = null;
        }
        this.onUpdateEnd();
    }

    private final PointF clamp(PointF v, PointF min, PointF max) {
        float f;
        float f2;
        float f3 = v.x;
        float f4 = min.x;
        boolean bl = false;
        f3 = f2 = Math.max(f3, f4);
        f4 = max.x;
        bl = false;
        f2 = Math.min(f3, f4);
        f3 = v.y;
        f4 = min.y;
        bl = false;
        f3 = f = Math.max(f3, f4);
        f4 = max.y;
        bl = false;
        float f5 = f = Math.min(f3, f4);
        float f6 = f2;
        return new PointF(f6, f5);
    }

    private final float clamp(float v, float min, float max) {
        boolean bl = false;
        float f = Math.max(v, min);
        boolean bl2 = false;
        return Math.min(f, max);
    }

    private final PointF focusPointToTranslation(PointF focus, float scale) {
        PointF pointF = new PointF();
        boolean bl = false;
        boolean bl2 = false;
        PointF $this$apply = pointF;
        boolean bl3 = false;
        $this$apply.x = -focus.x * scale + this.focusPointOffset.x * this.viewSize.getWidth();
        $this$apply.y = -focus.y * scale + this.focusPointOffset.y * this.viewSize.getHeight();
        return pointF;
    }

    private final PointF translationToFocusPoint(PointF translation, float scale) {
        PointF pointF = new PointF();
        boolean bl = false;
        boolean bl2 = false;
        PointF $this$apply = pointF;
        boolean bl3 = false;
        $this$apply.x = -(translation.x - this.focusPointOffset.x * this.viewSize.getWidth()) / scale;
        $this$apply.y = -(translation.y - this.focusPointOffset.y * this.viewSize.getHeight()) / scale;
        return pointF;
    }

    @NotNull
    public final View getTargetView() {
        return this.targetView;
    }

    public TouchScaler(@NotNull View targetView) {
        Intrinsics.checkParameterIsNotNull((Object)targetView, (String)"targetView");
        this.targetView = targetView;
        this.contentSize = SIZE_NONE;
        this.viewSize = SIZE_NONE;
        View view = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        $this$apply.setPivotX(0.0f);
        $this$apply.setPivotY(0.0f);
        ViewParent viewParent = $this$apply.getParent();
        if (!(viewParent instanceof ViewGroup)) {
            viewParent = null;
        }
        ViewGroup viewGroup = (ViewGroup)viewParent;
        if (viewGroup != null) {
            viewGroup.setClipChildren(false);
        }
        this.updateSize();
        this.mode = Mode.NONE;
        this.focusPointOffset = new PointF(0.5f, 0.5f);
        this.translation = new PointF();
        this.translationMin = new PointF();
        this.translationMax = new PointF();
        this.scaleMin = 1.0f;
        this.scaleMax = 3.0f;
        this.scaleDetector = new ScaleGestureDetector(this.targetView.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(this){
            final /* synthetic */ TouchScaler this$0;

            public boolean onScale(@NotNull ScaleGestureDetector d) {
                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                TouchScaler.access$scale(this.this$0, d.getScaleFactor(), new PointF(d.getFocusX(), d.getFocusY()));
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.flingDetector = new GestureDetector(this.targetView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ TouchScaler this$0;

            public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float vx, float vy) {
                Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
                TouchScaler.access$fling(this.this$0, vx, vy);
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    static {
        Companion = new Companion(null);
        DEFAULT_INTERPOLATOR = new DecelerateInterpolator();
        SIZE_NONE = new SizeF(0.0f, 0.0f);
        ORIGIN = new PointF();
    }

    public static final /* synthetic */ SizeF access$getViewSize$p(TouchScaler $this) {
        return $this.viewSize;
    }

    public static final /* synthetic */ PointF access$getCurrentTranslation$p(TouchScaler $this) {
        return $this.getCurrentTranslation();
    }

    public static final /* synthetic */ FlingAnimation access$getFlingX$p(TouchScaler $this) {
        return $this.flingX;
    }

    public static final /* synthetic */ void access$setFlingX$p(TouchScaler $this, FlingAnimation flingAnimation) {
        $this.flingX = flingAnimation;
    }

    public static final /* synthetic */ FlingAnimation access$getFlingY$p(TouchScaler $this) {
        return $this.flingY;
    }

    public static final /* synthetic */ void access$setFlingY$p(TouchScaler $this, FlingAnimation flingAnimation) {
        $this.flingY = flingAnimation;
    }

    public static final /* synthetic */ void access$onFlingEnded(TouchScaler $this) {
        $this.onFlingEnded();
    }

    public static final /* synthetic */ void access$notifyChange(TouchScaler $this) {
        $this.notifyChange();
    }

    public static final /* synthetic */ void access$clampTranslation(TouchScaler $this) {
        $this.clampTranslation();
    }

    public static final /* synthetic */ Mode access$getMode$p(TouchScaler $this) {
        return $this.mode;
    }

    public static final /* synthetic */ void access$setMode$p(TouchScaler $this, Mode mode) {
        $this.setMode(mode);
    }

    public static final /* synthetic */ UpdateAnimator access$getUpdateAnimator$p(TouchScaler $this) {
        return $this.updateAnimator;
    }

    public static final /* synthetic */ void access$setUpdateAnimator$p(TouchScaler $this, UpdateAnimator updateAnimator) {
        $this.updateAnimator = updateAnimator;
    }

    public static final /* synthetic */ void access$onUpdateEnd(TouchScaler $this, Update update) {
        $this.onUpdateEnd(update);
    }

    public static final /* synthetic */ void access$scale(TouchScaler $this, float factor, PointF focus) {
        $this.scale(factor, focus);
    }

    public static final /* synthetic */ void access$fling(TouchScaler $this, float vx, float vy) {
        $this.fling(vx, vy);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/novasa/touchscaler/TouchScaler$OnChangeListener;", "", "onTouchScalerChange", "", "scaler", "Lcom/novasa/touchscaler/TouchScaler;", "touchscaler_release"})
    public static interface OnChangeListener {
        public void onTouchScalerChange(@NotNull TouchScaler var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/novasa/touchscaler/TouchScaler$OnModeChangeListener;", "", "onTouchScalerModeChange", "", "scaler", "Lcom/novasa/touchscaler/TouchScaler;", "mode", "Lcom/novasa/touchscaler/TouchScaler$Mode;", "touchscaler_release"})
    public static interface OnModeChangeListener {
        public void onTouchScalerModeChange(@NotNull TouchScaler var1, @NotNull Mode var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/novasa/touchscaler/TouchScaler$Mode;", "", "(Ljava/lang/String;I)V", "NONE", "DRAG", "ZOOM", "FLING", "ANIMATE", "touchscaler_release"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NONE;
        public static final /* enum */ Mode DRAG;
        public static final /* enum */ Mode ZOOM;
        public static final /* enum */ Mode FLING;
        public static final /* enum */ Mode ANIMATE;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[5];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = NONE = new Mode();
            modeArray[1] = DRAG = new Mode();
            modeArray[2] = ZOOM = new Mode();
            modeArray[3] = FLING = new Mode();
            modeArray[4] = ANIMATE = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u001fJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020%J\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\b\u00102\u001a\u000203H\u0016R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\u0006\"\u0004\b\f\u0010\bR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001e\u0010$\u001a\u0004\u0018\u00010%X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)\u00a8\u00064"}, d2={"Lcom/novasa/touchscaler/TouchScaler$Update;", "", "()V", "delay", "", "getDelay$touchscaler_release", "()Ljava/lang/Long;", "setDelay$touchscaler_release", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "duration", "getDuration$touchscaler_release", "setDuration$touchscaler_release", "interpolator", "Landroid/animation/TimeInterpolator;", "getInterpolator$touchscaler_release", "()Landroid/animation/TimeInterpolator;", "setInterpolator$touchscaler_release", "(Landroid/animation/TimeInterpolator;)V", "next", "getNext$touchscaler_release", "()Lcom/novasa/touchscaler/TouchScaler$Update;", "setNext$touchscaler_release", "(Lcom/novasa/touchscaler/TouchScaler$Update;)V", "position", "Landroid/graphics/PointF;", "getPosition$touchscaler_release", "()Landroid/graphics/PointF;", "setPosition$touchscaler_release", "(Landroid/graphics/PointF;)V", "relative", "", "getRelative$touchscaler_release", "()Z", "setRelative$touchscaler_release", "(Z)V", "scale", "", "getScale$touchscaler_release", "()Ljava/lang/Float;", "setScale$touchscaler_release", "(Ljava/lang/Float;)V", "Ljava/lang/Float;", "animate", "interp", "update", "noAnimation", "x", "y", "reset", "toString", "", "touchscaler_release"})
    public static final class Update {
        @Nullable
        private /* synthetic */ PointF position;
        private /* synthetic */ boolean relative;
        @Nullable
        private /* synthetic */ Float scale;
        @Nullable
        private /* synthetic */ Long duration;
        @Nullable
        private /* synthetic */ Long delay;
        @Nullable
        private /* synthetic */ TimeInterpolator interpolator;
        @Nullable
        private /* synthetic */ Update next;

        @Nullable
        public final PointF getPosition$touchscaler_release() {
            return this.position;
        }

        public final void setPosition$touchscaler_release(@Nullable PointF pointF) {
            this.position = pointF;
        }

        public final boolean getRelative$touchscaler_release() {
            return this.relative;
        }

        public final void setRelative$touchscaler_release(boolean bl) {
            this.relative = bl;
        }

        @Nullable
        public final Float getScale$touchscaler_release() {
            return this.scale;
        }

        public final void setScale$touchscaler_release(@Nullable Float f) {
            this.scale = f;
        }

        @Nullable
        public final Long getDuration$touchscaler_release() {
            return this.duration;
        }

        public final void setDuration$touchscaler_release(@Nullable Long l) {
            this.duration = l;
        }

        @Nullable
        public final Long getDelay$touchscaler_release() {
            return this.delay;
        }

        public final void setDelay$touchscaler_release(@Nullable Long l) {
            this.delay = l;
        }

        @Nullable
        public final TimeInterpolator getInterpolator$touchscaler_release() {
            return this.interpolator;
        }

        public final void setInterpolator$touchscaler_release(@Nullable TimeInterpolator timeInterpolator) {
            this.interpolator = timeInterpolator;
        }

        @Nullable
        public final Update getNext$touchscaler_release() {
            return this.next;
        }

        public final void setNext$touchscaler_release(@Nullable Update update) {
            this.next = update;
        }

        @NotNull
        public final Update position(@NotNull PointF position) {
            Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
            Update update = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update;
            boolean bl3 = false;
            $this$apply.position = position;
            return update;
        }

        @NotNull
        public final Update position(float x, float y) {
            return this.position(new PointF(x, y));
        }

        @NotNull
        public final Update relative() {
            Update update = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update;
            boolean bl3 = false;
            $this$apply.relative = true;
            return update;
        }

        @NotNull
        public final Update scale(float scale) {
            Update update = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update;
            boolean bl3 = false;
            $this$apply.scale = Float.valueOf(scale);
            return update;
        }

        @NotNull
        public final Update duration(long duration) {
            Update update = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update;
            boolean bl3 = false;
            $this$apply.duration = duration;
            return update;
        }

        @NotNull
        public final Update delay(long delay) {
            Update update = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update;
            boolean bl3 = false;
            $this$apply.delay = delay;
            return update;
        }

        @NotNull
        public final Update interp(@NotNull TimeInterpolator interpolator) {
            Intrinsics.checkParameterIsNotNull((Object)interpolator, (String)"interpolator");
            Update update = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update;
            boolean bl3 = false;
            $this$apply.interpolator = interpolator;
            return update;
        }

        @NotNull
        public final Update animate(boolean animate) {
            Long l;
            Update update = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update;
            boolean bl3 = false;
            if (animate) {
                l = $this$apply.duration;
                if (l == null) {
                    l = 300L;
                }
            } else {
                l = null;
            }
            $this$apply.duration = l;
            return update;
        }

        @NotNull
        public final Update noAnimation() {
            return this.animate(false);
        }

        @NotNull
        public final Update reset() {
            return this.position(0.5f, 0.5f).relative().scale(1.0f);
        }

        @NotNull
        public final Update next() {
            Update update = new Update();
            boolean bl = false;
            boolean bl2 = false;
            Update it = update;
            boolean bl3 = false;
            this.next = it;
            return update;
        }

        @NotNull
        public final Update next(@NotNull Update update) {
            Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
            Update update2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Update $this$apply = update2;
            boolean bl3 = false;
            $this$apply.next = update;
            return update2;
        }

        @NotNull
        public String toString() {
            return "Update(position=" + this.position + ", scale=" + this.scale + ", duration=" + this.duration + ", next?=" + (this.next != null) + ')';
        }

        public Update() {
            this.duration = 300L;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0003\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/novasa/touchscaler/TouchScaler$UpdateAnimator;", "Landroid/animation/ValueAnimator;", "()V", "isCancelled", "", "()Z", "setCancelled", "(Z)V", "cancel", "", "touchscaler_release"})
    private static final class UpdateAnimator
    extends ValueAnimator {
        private boolean isCancelled;

        public final boolean isCancelled() {
            return this.isCancelled;
        }

        public final void setCancelled(boolean bl) {
            this.isCancelled = bl;
        }

        public void cancel() {
            this.isCancelled = true;
            super.cancel();
        }

        public UpdateAnimator() {
            this.setFloatValues(new float[]{0.0f, 1.0f});
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/novasa/touchscaler/TouchScaler$Companion;", "", "()V", "DEFAULT_ANIMATION_DURATION", "", "DEFAULT_INTERPOLATOR", "Landroid/view/animation/DecelerateInterpolator;", "DEFAULT_SCALE_MAX", "", "DEFAULT_SCALE_MIN", "ORIGIN", "Landroid/graphics/PointF;", "SIZE_NONE", "Landroid/util/SizeF;", "TAG", "", "touchscaler_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

