/*
 * Decompiled with CFR 0.152.
 */
package com.novasa.touchscaler;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.os.Build;
import android.util.Log;
import android.util.SizeF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FlingAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 F2\u00020\u0001:\u0002FGB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020/H\u0002J \u00101\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001bH\u0002J\b\u00105\u001a\u00020/H\u0002J.\u00106\u001a\u00020\u000f2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u0003082\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u001bH\u0002J\u0018\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u001bH\u0002J\u0018\u0010<\u001a\u00020=2\u0006\u00102\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?H\u0016J\u0006\u0010@\u001a\u00020/J\b\u0010A\u001a\u00020/H\u0002J\u0016\u0010\u001a\u001a\u00020/2\u0006\u0010B\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020\u0018J\u0012\u0010D\u001a\u00020/2\b\b\u0002\u0010E\u001a\u00020=H\u0002R&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010 \"\u0004\b%\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/novasa/touchscaler/TouchScaler;", "Landroid/view/View$OnTouchListener;", "targetView", "Landroid/view/View;", "(Landroid/view/View;)V", "value", "Landroid/util/SizeF;", "contentSize", "getContentSize", "()Landroid/util/SizeF;", "setContentSize", "(Landroid/util/SizeF;)V", "flingDetector", "Landroid/view/GestureDetector;", "flingX", "Landroidx/dynamicanimation/animation/FlingAnimation;", "flingY", "<set-?>", "Lcom/novasa/touchscaler/TouchScaler$Mode;", "mode", "getMode", "()Lcom/novasa/touchscaler/TouchScaler$Mode;", "overflowSize", "prevEventPosition", "Landroid/graphics/PointF;", "prevFocus", "scale", "", "scaleDetector", "Landroid/view/ScaleGestureDetector;", "scaleMax", "getScaleMax", "()F", "setScaleMax", "(F)V", "scaleMin", "getScaleMin", "setScaleMin", "getTargetView", "()Landroid/view/View;", "translation", "translationMax", "translationMin", "valueAnimator", "Landroid/animation/ValueAnimator;", "viewSize", "applyScaleAndTranslation", "", "cancelAnimations", "clamp", "v", "min", "max", "clampTranslation", "createFlingAnimation", "property", "Landroidx/dynamicanimation/animation/FloatPropertyCompat;", "fling", "vx", "vy", "onTouch", "", "event", "Landroid/view/MotionEvent;", "reset", "resetAnimated", "factor", "focus", "updateSizes", "force", "Companion", "Mode", "touchscaler_release"})
public final class TouchScaler
implements View.OnTouchListener {
    @NotNull
    private SizeF contentSize;
    private SizeF viewSize;
    private SizeF overflowSize;
    @NotNull
    private Mode mode;
    private PointF prevEventPosition;
    private final PointF translation;
    private final PointF translationMin;
    private final PointF translationMax;
    private float scaleMin;
    private float scaleMax;
    private float scale;
    private PointF prevFocus;
    private final ScaleGestureDetector scaleDetector;
    private final GestureDetector flingDetector;
    private FlingAnimation flingX;
    private FlingAnimation flingY;
    private ValueAnimator valueAnimator;
    @NotNull
    private final View targetView;
    private static final String TAG = "TouchScaler";
    private static final float DEFAULT_SCALE_MIN = 1.0f;
    private static final float DEFAULT_SCALE_MAX = 3.0f;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SizeF getContentSize() {
        if (this.contentSize.getWidth() == 0.0f || this.contentSize.getHeight() == 0.0f) {
            this.contentSize = new SizeF((float)this.targetView.getWidth(), (float)this.targetView.getHeight());
        }
        return this.contentSize;
    }

    public final void setContentSize(@NotNull SizeF value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.contentSize = new SizeF(value.getWidth(), value.getHeight());
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    public final float getScaleMin() {
        return this.scaleMin;
    }

    public final void setScaleMin(float f) {
        this.scaleMin = f;
    }

    public final float getScaleMax() {
        return this.scaleMax;
    }

    public final void setScaleMax(float f) {
        this.scaleMax = f;
    }

    public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)v, (String)"v");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getPointerCount() > 2) {
            this.mode = Mode.NONE;
            v.getParent().requestDisallowInterceptTouchEvent(false);
            return false;
        }
        PointF eventPosition = new PointF(event.getRawX(), event.getRawY());
        switch (event.getActionMasked()) {
            case 0: {
                this.cancelAnimations();
                v.getParent().requestDisallowInterceptTouchEvent(true);
                this.mode = Mode.DRAG;
                break;
            }
            case 5: {
                this.mode = Mode.ZOOM;
                break;
            }
            case 2: {
                if (this.mode != Mode.DRAG) break;
                float f = eventPosition.x;
                PointF pointF = this.prevEventPosition;
                if (pointF == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"prevEventPosition");
                }
                this.translation.x = f - pointF.x;
                float f2 = eventPosition.y;
                PointF pointF2 = this.prevEventPosition;
                if (pointF2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"prevEventPosition");
                }
                this.translation.y = f2 - pointF2.y;
                break;
            }
            case 6: {
                this.mode = Mode.DRAG;
                this.prevFocus = null;
                int index = event.getActionIndex() ^ 1;
                if (index == 0) break;
                if (Build.VERSION.SDK_INT >= 29) {
                    eventPosition.x = event.getRawX(index);
                    eventPosition.y = event.getRawY(index);
                    break;
                }
                int[] location = new int[2];
                v.getLocationOnScreen(location);
                eventPosition.x = event.getX(index) + (float)location[0];
                eventPosition.y = event.getY(index) + (float)location[1];
                break;
            }
            case 1: 
            case 3: {
                this.mode = Mode.NONE;
                v.getParent().requestDisallowInterceptTouchEvent(false);
            }
        }
        TouchScaler.updateSizes$default(this, false, 1, null);
        this.scaleDetector.onTouchEvent(event);
        this.flingDetector.onTouchEvent(event);
        if (this.mode != Mode.NONE) {
            this.applyScaleAndTranslation();
        }
        this.prevEventPosition = eventPosition;
        return true;
    }

    public final void scale(float factor, @NotNull PointF focus) {
        Intrinsics.checkParameterIsNotNull((Object)focus, (String)"focus");
        float prevScale = this.scale;
        this.scale *= factor;
        this.scale = this.clamp(this.scale, this.scaleMin, this.scaleMax);
        if (this.scale != prevScale) {
            float scaled = factor - 1.0f;
            this.translation.x = (this.targetView.getTranslationX() - focus.x) * scaled - this.overflowSize.getWidth() * scaled;
            this.translation.y = (this.targetView.getTranslationY() - focus.y) * scaled - this.overflowSize.getHeight() * scaled;
        }
        this.prevFocus = focus;
    }

    private final void fling(float vx, float vy) {
        DynamicAnimation.ViewProperty viewProperty = DynamicAnimation.TRANSLATION_X;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewProperty, (String)"DynamicAnimation.TRANSLATION_X");
        this.flingX = this.createFlingAnimation((FloatPropertyCompat<View>)((FloatPropertyCompat)viewProperty), this.translationMin.x, this.translationMax.x, vx);
        DynamicAnimation.ViewProperty viewProperty2 = DynamicAnimation.TRANSLATION_Y;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewProperty2, (String)"DynamicAnimation.TRANSLATION_Y");
        this.flingY = this.createFlingAnimation((FloatPropertyCompat<View>)((FloatPropertyCompat)viewProperty2), this.translationMin.y, this.translationMax.y, vy);
    }

    private final FlingAnimation createFlingAnimation(FloatPropertyCompat<View> property, float min, float max, float v) {
        FlingAnimation flingAnimation = new FlingAnimation((Object)this.targetView, property);
        boolean bl = false;
        boolean bl2 = false;
        FlingAnimation $this$apply = flingAnimation;
        boolean bl3 = false;
        $this$apply.setMinValue(min);
        $this$apply.setMaxValue(max);
        $this$apply.setStartVelocity(v);
        $this$apply.setFriction(1.1f);
        $this$apply.start();
        return flingAnimation;
    }

    private final void updateSizes(boolean force) {
        if (force || this.viewSize.getWidth() == 0.0f || this.viewSize.getHeight() == 0.0f) {
            SizeF sizeF;
            TouchScaler touchScaler = this;
            ViewParent viewParent = this.targetView.getParent();
            if (!(viewParent instanceof View)) {
                viewParent = null;
            }
            View view = (View)viewParent;
            if (view != null) {
                View view2 = view;
                TouchScaler touchScaler2 = touchScaler;
                boolean bl = false;
                boolean bl2 = false;
                View it = view2;
                boolean bl3 = false;
                SizeF sizeF2 = new SizeF((float)it.getWidth(), (float)it.getHeight());
                touchScaler = touchScaler2;
                sizeF = sizeF2;
            } else {
                sizeF = touchScaler.viewSize = new SizeF(0.0f, 0.0f);
            }
        }
        if (force || this.overflowSize.getWidth() == 0.0f || this.overflowSize.getHeight() == 0.0f) {
            this.overflowSize = new SizeF((this.getContentSize().getWidth() - this.viewSize.getWidth()) * 0.5f, (this.getContentSize().getHeight() - this.viewSize.getHeight()) * 0.5f);
        }
        this.translationMin.x = -(this.overflowSize.getWidth() + this.getContentSize().getWidth() * (this.scale - 1.0f));
        this.translationMin.y = -(this.overflowSize.getHeight() + this.getContentSize().getHeight() * (this.scale - 1.0f));
        this.translationMax.x = this.overflowSize.getWidth();
        this.translationMax.y = this.overflowSize.getHeight();
    }

    static /* synthetic */ void updateSizes$default(TouchScaler touchScaler, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        touchScaler.updateSizes(bl);
    }

    public final void applyScaleAndTranslation() {
        View view = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        $this$apply.setPivotX(-this.overflowSize.getWidth());
        $this$apply.setPivotY(-this.overflowSize.getHeight());
        View view2 = $this$apply;
        view2.setTranslationX(view2.getTranslationX() + this.translation.x);
        View view3 = $this$apply;
        view3.setTranslationY(view3.getTranslationY() + this.translation.y);
        this.clampTranslation();
        $this$apply.setScaleX(this.scale);
        $this$apply.setScaleY(this.scale);
        Log.d((String)TAG, (String)("Scale: " + this.scale + ", translation: [" + this.translation + "] -> [" + $this$apply.getTranslationX() + ", " + $this$apply.getTranslationY() + "], pivot: [" + $this$apply.getPivotX() + ", " + $this$apply.getPivotY() + "], content: " + this.getContentSize() + ", overflow: " + this.overflowSize));
        this.translation.x = 0.0f;
        this.translation.y = 0.0f;
    }

    private final void clampTranslation() {
        View view = this.targetView;
        boolean bl = false;
        boolean bl2 = false;
        View $this$apply = view;
        boolean bl3 = false;
        $this$apply.setTranslationX(this.clamp($this$apply.getTranslationX(), this.translationMin.x, this.translationMax.x));
        $this$apply.setTranslationY(this.clamp($this$apply.getTranslationY(), this.translationMin.y, this.translationMax.y));
    }

    private final void cancelAnimations() {
        this.targetView.animate().cancel();
        FlingAnimation flingAnimation = this.flingX;
        if (flingAnimation != null) {
            flingAnimation.cancel();
        }
        this.flingX = null;
        FlingAnimation flingAnimation2 = this.flingY;
        if (flingAnimation2 != null) {
            flingAnimation2.cancel();
        }
        this.flingY = null;
    }

    public final void reset() {
        this.resetAnimated();
    }

    private final void resetAnimated() {
        ValueAnimator valueAnimator;
        ValueAnimator valueAnimator2 = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        TouchScaler touchScaler = this;
        boolean bl = false;
        boolean bl2 = false;
        ValueAnimator $this$apply = valueAnimator2;
        boolean bl3 = false;
        $this$apply.setDuration(200L);
        $this$apply.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        float s0 = this.scale;
        float s1 = 1.0f;
        float x0 = this.targetView.getTranslationX();
        float y0 = this.targetView.getTranslationY();
        $this$apply.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(s1, s0, x0, y0, this){
            final /* synthetic */ float $s1;
            final /* synthetic */ float $s0;
            final /* synthetic */ float $x0;
            final /* synthetic */ float $y0;
            final /* synthetic */ TouchScaler this$0;
            {
                this.$s1 = f;
                this.$s0 = f2;
                this.$x0 = f3;
                this.$y0 = f4;
                this.this$0 = touchScaler;
            }

            public final void onAnimationUpdate(ValueAnimator animator) {
                ValueAnimator valueAnimator = animator;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
                float f = valueAnimator.getAnimatedFraction();
                TouchScaler.access$setScale$p(this.this$0, f * (this.$s1 - this.$s0) + this.$s0);
                this.this$0.applyScaleAndTranslation();
                this.this$0.getTargetView().setTranslationX((1.0f - f) * this.$x0);
                this.this$0.getTargetView().setTranslationY((1.0f - f) * this.$y0);
                TouchScaler.access$clampTranslation(this.this$0);
            }
        });
        $this$apply.start();
        touchScaler.valueAnimator = valueAnimator = valueAnimator2;
    }

    private final float clamp(float v, float min, float max) {
        boolean bl = false;
        float f = Math.max(v, min);
        boolean bl2 = false;
        return Math.min(f, max);
    }

    @NotNull
    public final View getTargetView() {
        return this.targetView;
    }

    public TouchScaler(@NotNull View targetView) {
        Intrinsics.checkParameterIsNotNull((Object)targetView, (String)"targetView");
        this.targetView = targetView;
        ViewParent viewParent = this.targetView.getParent();
        if (!(viewParent instanceof ViewGroup)) {
            viewParent = null;
        }
        ViewGroup viewGroup = (ViewGroup)viewParent;
        if (viewGroup != null) {
            ViewGroup viewGroup2 = viewGroup;
            boolean bl = false;
            boolean bl2 = false;
            ViewGroup it = viewGroup2;
            boolean bl3 = false;
            it.setClipChildren(false);
        }
        this.contentSize = new SizeF(0.0f, 0.0f);
        this.viewSize = new SizeF(0.0f, 0.0f);
        this.overflowSize = new SizeF(0.0f, 0.0f);
        this.mode = Mode.NONE;
        this.translation = new PointF();
        this.translationMin = new PointF();
        this.translationMax = new PointF();
        this.scaleMin = 1.0f;
        this.scaleMax = 3.0f;
        this.scale = 1.0f;
        this.scaleDetector = new ScaleGestureDetector(this.targetView.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(this){
            final /* synthetic */ TouchScaler this$0;

            public boolean onScale(@NotNull ScaleGestureDetector d) {
                Intrinsics.checkParameterIsNotNull((Object)d, (String)"d");
                this.this$0.scale(d.getScaleFactor(), new PointF(d.getFocusX(), d.getFocusY()));
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
        this.flingDetector = new GestureDetector(this.targetView.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(this){
            final /* synthetic */ TouchScaler this$0;

            public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float vx, float vy) {
                Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
                TouchScaler.access$fling(this.this$0, vx, vy);
                return true;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public static final /* synthetic */ float access$getScale$p(TouchScaler $this) {
        return $this.scale;
    }

    public static final /* synthetic */ void access$setScale$p(TouchScaler $this, float f) {
        $this.scale = f;
    }

    public static final /* synthetic */ void access$clampTranslation(TouchScaler $this) {
        $this.clampTranslation();
    }

    public static final /* synthetic */ void access$fling(TouchScaler $this, float vx, float vy) {
        $this.fling(vx, vy);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/novasa/touchscaler/TouchScaler$Mode;", "", "(Ljava/lang/String;I)V", "NONE", "DRAG", "ZOOM", "touchscaler_release"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode NONE;
        public static final /* enum */ Mode DRAG;
        public static final /* enum */ Mode ZOOM;
        private static final /* synthetic */ Mode[] $VALUES;

        static {
            Mode[] modeArray = new Mode[3];
            Mode[] modeArray2 = modeArray;
            modeArray[0] = NONE = new Mode();
            modeArray[1] = DRAG = new Mode();
            modeArray[2] = ZOOM = new Mode();
            $VALUES = modeArray;
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String string) {
            return Enum.valueOf(Mode.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/novasa/touchscaler/TouchScaler$Companion;", "", "()V", "DEFAULT_SCALE_MAX", "", "DEFAULT_SCALE_MIN", "TAG", "", "touchscaler_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

