package com.novasa.monkeywrench.finder

import com.novasa.monkeywrench.schematic.Schematic

/** Finds [Match]es in the input, that the [Schematic] is applied to. */
abstract class Finder {

    internal fun findMatches(input: CharSequence): Output = find(input).also { output ->
        if (inputChange(output.matches)) {
            val sb = StringBuilder()
            var i0 = 0
            for (match in output.matches) {
                sb.append(input.subSequence(i0, match.p0))
                sb.append(match.output)
                i0 = match.p0 + match.input.length
            }
            sb.append(input.subSequence(i0, input.length - 1))
            output.nextInput = sb.toString()
        }
    }

    private fun inputChange(matches: List<Match>): Boolean = matches.any {
        it.input != it.output
    }

    protected abstract fun find(input: CharSequence): Output

    data class Output(val matches: List<Match>, var nextInput: CharSequence)
}