/*
 * Decompiled with CFR 0.152.
 */
package com.novasa.monkeywrench;

import android.graphics.Paint;
import android.graphics.Typeface;
import android.net.Uri;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.CharacterStyle;
import android.text.style.ClickableSpan;
import android.text.style.TypefaceSpan;
import android.view.View;
import android.widget.TextView;
import com.novasa.monkeywrench.MonkeyWrench;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0012\u0018\u0000 -2\u00020\u0001:\f+,-./0123456B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\r\u001a\u00020\u0000\"\b\b\u0000\u0010\u000e*\u00020\u000b2\u0006\u0010\u000f\u001a\u0002H\u000e2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J'\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013J\u001f\u0010\u001c\u001a\u00020\u00002\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013J3\u0010\u001d\u001a\u00020\u00002\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00120\u00112\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013JP\u0010!\u001a\u00020\u00002*\u0010\"\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$0#\"\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\u0010&J'\u0010'\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u001b2\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013J/\u0010\u001a\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u00032\u0017\u0010\u0010\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\b\u0013J\b\u0010*\u001a\u00020\u001bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench;", "", "input", "", "(Ljava/lang/CharSequence;)V", "builder", "Landroid/text/SpannableStringBuilder;", "getInput", "()Ljava/lang/CharSequence;", "spans", "Ljava/util/ArrayList;", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "Lkotlin/collections/ArrayList;", "addWrench", "T", "span", "setup", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;Lkotlin/jvm/functions/Function1;)Lcom/novasa/monkeywrench/MonkeyWrench;", "doTheThing", "doTheThingUnto", "textView", "Landroid/widget/TextView;", "html", "tag", "", "htmlBold", "htmlLink", "onClick", "Landroid/net/Uri;", "Lcom/novasa/monkeywrench/MonkeyWrench$ClickWrench;", "interval", "intervals", "", "Lkotlin/Pair;", "", "([Lkotlin/Pair;Lkotlin/jvm/functions/Function1;)Lcom/novasa/monkeywrench/MonkeyWrench;", "regex", "open", "close", "toString", "ClickSpan", "ClickWrench", "Companion", "CustomTypefaceSpan", "Finder", "HrefFinder", "HrefInterval", "Interval", "IntervalFinder", "RegexFinder", "TagFinder", "Wrench", "monkeywrench_release"})
public final class MonkeyWrench {
    private final SpannableStringBuilder builder;
    private final ArrayList<Wrench> spans;
    @NotNull
    private final CharSequence input;
    private static final int COLOR_UNDEFINED = 1;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final <T extends Wrench> MonkeyWrench addWrench(@NotNull T span, @NotNull Function1<? super T, Unit> setup) {
        Intrinsics.checkParameterIsNotNull(span, (String)"span");
        Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
        setup.invoke(span);
        this.spans.add(span);
        return this;
    }

    @NotNull
    public final MonkeyWrench tag(@NotNull CharSequence open, @NotNull CharSequence close, @NotNull Function1<? super Wrench, Unit> setup) {
        Intrinsics.checkParameterIsNotNull((Object)open, (String)"open");
        Intrinsics.checkParameterIsNotNull((Object)close, (String)"close");
        Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
        Wrench wrench = new Wrench(new TagFinder(open, close));
        return this.addWrench(wrench, setup);
    }

    @NotNull
    public final MonkeyWrench html(@NotNull String tag, @NotNull Function1<? super Wrench, Unit> setup) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
        return this.tag('<' + tag + '>', "</" + tag + '>', setup);
    }

    @NotNull
    public final MonkeyWrench htmlBold(@NotNull Function1<? super Wrench, Unit> setup) {
        Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
        return this.html("b", setup);
    }

    @NotNull
    public final MonkeyWrench htmlLink(@NotNull Function1<? super Uri, Unit> onClick, @NotNull Function1<? super ClickWrench, Unit> setup) {
        Intrinsics.checkParameterIsNotNull(onClick, (String)"onClick");
        Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
        return this.addWrench((Wrench)new ClickWrench(onClick), setup);
    }

    @NotNull
    public final MonkeyWrench interval(@NotNull Pair<Integer, Integer>[] intervals, @NotNull Function1<? super Wrench, Unit> setup) {
        Intrinsics.checkParameterIsNotNull(intervals, (String)"intervals");
        Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
        Wrench wrench = new Wrench(new IntervalFinder(intervals));
        return this.addWrench(wrench, setup);
    }

    @NotNull
    public final MonkeyWrench regex(@NotNull String regex, @NotNull Function1<? super Wrench, Unit> setup) {
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
        Wrench wrench = new Wrench(new RegexFinder(regex));
        return this.addWrench(wrench, setup);
    }

    @NotNull
    public final CharSequence doTheThing() {
        ArrayList intervals = new ArrayList();
        Iterable $receiver$iv = this.spans;
        for (Object element$iv : $receiver$iv) {
            Wrench span = (Wrench)element$iv;
            boolean bl = false;
            intervals.addAll(span.createIntervals$monkeywrench_release(this.input));
        }
        CollectionsKt.sortWith((List)intervals, (Comparator)doTheThing.2.INSTANCE);
        int end = 0;
        for (Interval interval : intervals) {
            int start = interval.getP0() - interval.getOpenLength();
            if (start > end) {
                this.builder.append(this.input.subSequence(end, start));
            }
            int p0 = this.builder.length();
            this.builder.append(interval.getSequence());
            int p1 = this.builder.length();
            this.builder.setSpan((Object)interval.getSpan(), p0, p1, 33);
            end = interval.getP1() + interval.getCloseLength();
        }
        this.builder.append(this.input.subSequence(end, this.input.length()));
        return (CharSequence)this.builder;
    }

    public final void doTheThingUnto(@NotNull TextView textView) {
        Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        textView.setText(this.doTheThing());
        Iterable $receiver$iv = this.spans;
        for (Object element$iv : $receiver$iv) {
            Wrench span = (Wrench)element$iv;
            boolean bl = false;
            span.setupTextView(textView);
        }
    }

    @NotNull
    public String toString() {
        String string = this.builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final CharSequence getInput() {
        return this.input;
    }

    public MonkeyWrench(@NotNull CharSequence input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        this.input = input;
        this.builder = new SpannableStringBuilder();
        this.spans = new ArrayList();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020/H\u0016J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u00100\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0016J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00064"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "", "finder", "Lcom/novasa/monkeywrench/MonkeyWrench$Finder;", "(Lcom/novasa/monkeywrench/MonkeyWrench$Finder;)V", "bgColor", "", "getBgColor", "()I", "setBgColor", "(I)V", "color", "getColor", "setColor", "getFinder", "()Lcom/novasa/monkeywrench/MonkeyWrench$Finder;", "scale", "", "getScale", "()F", "setScale", "(F)V", "typeFace", "Landroid/graphics/Typeface;", "kotlin.jvm.PlatformType", "getTypeFace", "()Landroid/graphics/Typeface;", "setTypeFace", "(Landroid/graphics/Typeface;)V", "underline", "", "getUnderline", "()Z", "setUnderline", "(Z)V", "apply", "", "paint", "Landroid/graphics/Paint;", "backgroundColor", "createIntervals", "", "Lcom/novasa/monkeywrench/MonkeyWrench$Interval;", "input", "", "createIntervals$monkeywrench_release", "getSpan", "Landroid/text/style/CharacterStyle;", "setupTextView", "textView", "Landroid/widget/TextView;", "typeface", "monkeywrench_release"})
    public static class Wrench {
        private Typeface typeFace;
        private int color;
        private int bgColor;
        private float scale;
        private boolean underline;
        @NotNull
        private final Finder finder;

        protected final Typeface getTypeFace() {
            return this.typeFace;
        }

        protected final void setTypeFace(Typeface typeface) {
            this.typeFace = typeface;
        }

        protected final int getColor() {
            return this.color;
        }

        protected final void setColor(int n) {
            this.color = n;
        }

        protected final int getBgColor() {
            return this.bgColor;
        }

        protected final void setBgColor(int n) {
            this.bgColor = n;
        }

        protected final float getScale() {
            return this.scale;
        }

        protected final void setScale(float f) {
            this.scale = f;
        }

        protected final boolean getUnderline() {
            return this.underline;
        }

        protected final void setUnderline(boolean bl) {
            this.underline = bl;
        }

        @NotNull
        public final Wrench typeFace(@NotNull Typeface typeface) {
            Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
            this.typeFace = typeface;
            return this;
        }

        @NotNull
        public final Wrench color(int color) {
            this.color = color;
            return this;
        }

        @NotNull
        public final Wrench backgroundColor(int color) {
            this.bgColor = color;
            return this;
        }

        @NotNull
        public final Wrench scale(float scale) {
            this.scale = scale;
            return this;
        }

        @NotNull
        public final Wrench underline() {
            this.underline = true;
            return this;
        }

        @NotNull
        public CharacterStyle getSpan() {
            return (CharacterStyle)new CustomTypefaceSpan(this);
        }

        @NotNull
        public final List<Interval> createIntervals$monkeywrench_release(@NotNull CharSequence input) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            return this.finder.createIntervals(input, this);
        }

        public void apply(@NotNull Paint paint) {
            Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
            paint.setTypeface(this.typeFace);
            if (this.color != 1) {
                paint.setColor(this.color);
            }
            if (paint instanceof TextPaint && this.bgColor != 1) {
                ((TextPaint)paint).bgColor = this.bgColor;
            }
            if (this.scale != 1.0f) {
                paint.setTextSize(paint.getTextSize() * this.scale);
            }
            paint.setUnderlineText(this.underline);
        }

        public void setupTextView(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
        }

        @NotNull
        public final Finder getFinder() {
            return this.finder;
        }

        public Wrench(@NotNull Finder finder) {
            Intrinsics.checkParameterIsNotNull((Object)finder, (String)"finder");
            this.finder = finder;
            this.typeFace = Typeface.DEFAULT;
            this.color = 1;
            this.bgColor = 1;
            this.scale = 1.0f;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$ClickWrench;", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "onClick", "Lkotlin/Function1;", "Landroid/net/Uri;", "", "(Lkotlin/jvm/functions/Function1;)V", "getOnClick", "()Lkotlin/jvm/functions/Function1;", "setupTextView", "textView", "Landroid/widget/TextView;", "monkeywrench_release"})
    public static final class ClickWrench
    extends Wrench {
        @NotNull
        private final Function1<Uri, Unit> onClick;

        @Override
        public void setupTextView(@NotNull TextView textView) {
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
            textView.setMovementMethod(LinkMovementMethod.getInstance());
        }

        @NotNull
        public final Function1<Uri, Unit> getOnClick() {
            return this.onClick;
        }

        public ClickWrench(@NotNull Function1<? super Uri, Unit> onClick) {
            Intrinsics.checkParameterIsNotNull(onClick, (String)"onClick");
            super(new HrefFinder());
            this.onClick = onClick;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH&R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$Finder;", "", "()V", "closeLength", "", "getCloseLength", "()I", "openLength", "getOpenLength", "createIntervals", "", "Lcom/novasa/monkeywrench/MonkeyWrench$Interval;", "input", "", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "monkeywrench_release"})
    public static abstract class Finder {
        private final int openLength = 0;
        private final int closeLength = 0;

        public int getOpenLength() {
            return this.openLength;
        }

        public int getCloseLength() {
            return this.closeLength;
        }

        @NotNull
        public abstract List<Interval> createIntervals(@NotNull CharSequence var1, @NotNull Wrench var2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016J0\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$RegexFinder;", "Lcom/novasa/monkeywrench/MonkeyWrench$Finder;", "regex", "", "(Ljava/lang/String;)V", "outputGroupIndex", "", "getOutputGroupIndex", "()I", "setOutputGroupIndex", "(I)V", "getRegex", "()Ljava/lang/String;", "createIntervals", "", "Lcom/novasa/monkeywrench/MonkeyWrench$Interval;", "input", "", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "onMatch", "matcher", "Ljava/util/regex/Matcher;", "sequence", "p0", "p1", "monkeywrench_release"})
    public static class RegexFinder
    extends Finder {
        private int outputGroupIndex;
        @NotNull
        private final String regex;

        public int getOutputGroupIndex() {
            return this.outputGroupIndex;
        }

        public void setOutputGroupIndex(int n) {
            this.outputGroupIndex = n;
        }

        @Override
        @NotNull
        public List<Interval> createIntervals(@NotNull CharSequence input, @NotNull Wrench wrench) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            ArrayList<Interval> result = new ArrayList<Interval>();
            Matcher matcher = Pattern.compile(this.regex).matcher(input);
            while (matcher.find()) {
                Matcher matcher2 = matcher;
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher2, (String)"matcher");
                Interval interval = this.onMatch(wrench, matcher2);
                result.add(interval);
            }
            return result;
        }

        @NotNull
        public final Interval onMatch(@NotNull Wrench wrench, @NotNull Matcher matcher) {
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
            String sequence = matcher.group(this.getOutputGroupIndex());
            int p0 = matcher.start(this.getOutputGroupIndex());
            int p1 = matcher.end(this.getOutputGroupIndex());
            String string = sequence;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sequence");
            return this.onMatch(wrench, matcher, string, p0, p1);
        }

        @NotNull
        public Interval onMatch(@NotNull Wrench wrench, @NotNull Matcher matcher, @NotNull String sequence, int p0, int p1) {
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            return new Interval(wrench, sequence, p0, p1);
        }

        @NotNull
        protected final String getRegex() {
            return this.regex;
        }

        public RegexFinder(@NotNull String regex) {
            Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
            this.regex = regex;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$TagFinder;", "Lcom/novasa/monkeywrench/MonkeyWrench$RegexFinder;", "open", "", "close", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "closeLength", "", "getCloseLength", "()I", "openLength", "getOpenLength", "outputGroupIndex", "getOutputGroupIndex", "setOutputGroupIndex", "(I)V", "monkeywrench_release"})
    public static class TagFinder
    extends RegexFinder {
        private final int openLength;
        private final int closeLength;
        private int outputGroupIndex;

        @Override
        public int getOpenLength() {
            return this.openLength;
        }

        @Override
        public int getCloseLength() {
            return this.closeLength;
        }

        @Override
        public int getOutputGroupIndex() {
            return this.outputGroupIndex;
        }

        @Override
        public void setOutputGroupIndex(int n) {
            this.outputGroupIndex = n;
        }

        public TagFinder(@NotNull CharSequence open, @NotNull CharSequence close) {
            Intrinsics.checkParameterIsNotNull((Object)open, (String)"open");
            Intrinsics.checkParameterIsNotNull((Object)close, (String)"close");
            super(open + "(.*?)" + close);
            this.openLength = open.length();
            this.closeLength = close.length();
            this.outputGroupIndex = 1;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$HrefFinder;", "Lcom/novasa/monkeywrench/MonkeyWrench$TagFinder;", "()V", "outputGroupIndex", "", "getOutputGroupIndex", "()I", "setOutputGroupIndex", "(I)V", "onMatch", "Lcom/novasa/monkeywrench/MonkeyWrench$Interval;", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "matcher", "Ljava/util/regex/Matcher;", "sequence", "", "p0", "p1", "monkeywrench_release"})
    public static final class HrefFinder
    extends TagFinder {
        private int outputGroupIndex = 2;

        @Override
        public int getOutputGroupIndex() {
            return this.outputGroupIndex;
        }

        @Override
        public void setOutputGroupIndex(int n) {
            this.outputGroupIndex = n;
        }

        @Override
        @NotNull
        public Interval onMatch(@NotNull Wrench wrench, @NotNull Matcher matcher, @NotNull String sequence, int p0, int p1) {
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            String href = matcher.group(1);
            ClickWrench clickWrench = (ClickWrench)wrench;
            CharSequence charSequence = sequence;
            String string = href;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"href");
            return new HrefInterval(clickWrench, charSequence, p0, p1, string);
        }

        public HrefFinder() {
            super("<a href=(.*?)>", "</a>");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00040\u0003X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$IntervalFinder;", "Lcom/novasa/monkeywrench/MonkeyWrench$Finder;", "intervals", "", "Lkotlin/Pair;", "", "([Lkotlin/Pair;)V", "getIntervals", "()[Lkotlin/Pair;", "[Lkotlin/Pair;", "createIntervals", "", "Lcom/novasa/monkeywrench/MonkeyWrench$Interval;", "input", "", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "monkeywrench_release"})
    public static class IntervalFinder
    extends Finder {
        @NotNull
        private final Pair<Integer, Integer>[] intervals;

        @Override
        @NotNull
        public List<Interval> createIntervals(@NotNull CharSequence input, @NotNull Wrench wrench) {
            Pair<Integer, Integer>[] $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            ArrayList<Interval> result = new ArrayList<Interval>(this.intervals.length);
            Pair<Integer, Integer>[] pairArray = $receiver$iv = this.intervals;
            int n = pairArray.length;
            for (int i = 0; i < n; ++i) {
                Pair<Integer, Integer> element$iv;
                Pair<Integer, Integer> interval = element$iv = pairArray[i];
                boolean bl = false;
                int p0 = ((Number)interval.getFirst()).intValue();
                int p1 = ((Number)interval.getSecond()).intValue();
                if (p0 < 0 || p0 > p1 || p1 > input.length()) {
                    throw (Throwable)new IllegalArgumentException("Bad interval: " + p0 + " - " + p1 + ". Length was " + input.length() + '.');
                }
                CharSequence sequence = input.subSequence(p0, p1);
                result.add(new Interval(wrench, sequence, p0, p1));
            }
            return result;
        }

        @NotNull
        protected final Pair<Integer, Integer>[] getIntervals() {
            return this.intervals;
        }

        public IntervalFinder(@NotNull Pair<Integer, Integer>[] intervals) {
            Intrinsics.checkParameterIsNotNull(intervals, (String)"intervals");
            this.intervals = intervals;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0014\u0010\n\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$Interval;", "", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "sequence", "", "p0", "", "p1", "(Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;Ljava/lang/CharSequence;II)V", "closeLength", "getCloseLength", "()I", "openLength", "getOpenLength", "getP0", "getP1", "getSequence", "()Ljava/lang/CharSequence;", "getWrench", "()Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "getSpan", "Landroid/text/style/CharacterStyle;", "toString", "", "monkeywrench_release"})
    public static class Interval {
        private final int openLength;
        private final int closeLength;
        @NotNull
        private final Wrench wrench;
        @NotNull
        private final CharSequence sequence;
        private final int p0;
        private final int p1;

        public int getOpenLength() {
            return this.openLength;
        }

        public int getCloseLength() {
            return this.closeLength;
        }

        @NotNull
        public CharacterStyle getSpan() {
            return this.wrench.getSpan();
        }

        @NotNull
        public String toString() {
            return this.p0 + " - " + this.p1 + " (o: " + this.getOpenLength() + ", c: " + this.getCloseLength() + ')';
        }

        @NotNull
        public final Wrench getWrench() {
            return this.wrench;
        }

        @NotNull
        public final CharSequence getSequence() {
            return this.sequence;
        }

        public final int getP0() {
            return this.p0;
        }

        public final int getP1() {
            return this.p1;
        }

        public Interval(@NotNull Wrench wrench, @NotNull CharSequence sequence, int p0, int p1) {
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            this.wrench = wrench;
            this.sequence = sequence;
            this.p0 = p0;
            this.p1 = p1;
            this.openLength = this.wrench.getFinder().getOpenLength();
            this.closeLength = this.wrench.getFinder().getCloseLength();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\nH\u0016R\u0014\u0010\f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$HrefInterval;", "Lcom/novasa/monkeywrench/MonkeyWrench$Interval;", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$ClickWrench;", "sequence", "", "p0", "", "p1", "hrefString", "", "(Lcom/novasa/monkeywrench/MonkeyWrench$ClickWrench;Ljava/lang/CharSequence;IILjava/lang/String;)V", "openLength", "getOpenLength", "()I", "uri", "Landroid/net/Uri;", "getSpan", "Landroid/text/style/CharacterStyle;", "toString", "monkeywrench_release"})
    public static final class HrefInterval
    extends Interval {
        private final int openLength;
        private final Uri uri;

        @Override
        public int getOpenLength() {
            return this.openLength;
        }

        @Override
        @NotNull
        public CharacterStyle getSpan() {
            Wrench wrench = this.getWrench();
            if (wrench == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.novasa.monkeywrench.MonkeyWrench.ClickWrench");
            }
            return (CharacterStyle)new ClickSpan(this.uri, (ClickWrench)wrench);
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + " - " + this.uri;
        }

        public HrefInterval(@NotNull ClickWrench wrench, @NotNull CharSequence sequence, int p0, int p1, @NotNull String hrefString) {
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
            Intrinsics.checkParameterIsNotNull((Object)hrefString, (String)"hrefString");
            super(wrench, sequence, p0, p1);
            this.openLength = ("<a href=" + hrefString + '>').length();
            Uri uri = Uri.parse((String)StringsKt.trim((String)hrefString, (char[])new char[]{'\"', '\''}));
            Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(hrefString.trim('\"', '\\''))");
            this.uri = uri;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$CustomTypefaceSpan;", "Landroid/text/style/TypefaceSpan;", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;", "(Lcom/novasa/monkeywrench/MonkeyWrench$Wrench;)V", "updateDrawState", "", "ds", "Landroid/text/TextPaint;", "updateMeasureState", "paint", "monkeywrench_release"})
    private static final class CustomTypefaceSpan
    extends TypefaceSpan {
        private final Wrench wrench;

        public void updateDrawState(@NotNull TextPaint ds) {
            Intrinsics.checkParameterIsNotNull((Object)ds, (String)"ds");
            this.wrench.apply((Paint)ds);
        }

        public void updateMeasureState(@NotNull TextPaint paint) {
            Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
            this.wrench.apply((Paint)paint);
        }

        public CustomTypefaceSpan(@NotNull Wrench wrench) {
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            super("");
            this.wrench = wrench;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$ClickSpan;", "Landroid/text/style/ClickableSpan;", "uri", "Landroid/net/Uri;", "wrench", "Lcom/novasa/monkeywrench/MonkeyWrench$ClickWrench;", "(Landroid/net/Uri;Lcom/novasa/monkeywrench/MonkeyWrench$ClickWrench;)V", "getUri", "()Landroid/net/Uri;", "getWrench", "()Lcom/novasa/monkeywrench/MonkeyWrench$ClickWrench;", "onClick", "", "widget", "Landroid/view/View;", "updateDrawState", "ds", "Landroid/text/TextPaint;", "monkeywrench_release"})
    private static final class ClickSpan
    extends ClickableSpan {
        @NotNull
        private final Uri uri;
        @NotNull
        private final ClickWrench wrench;

        public void onClick(@NotNull View widget) {
            Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
            this.wrench.getOnClick().invoke((Object)this.uri);
        }

        public void updateDrawState(@NotNull TextPaint ds) {
            Intrinsics.checkParameterIsNotNull((Object)ds, (String)"ds");
            this.wrench.apply((Paint)ds);
        }

        @NotNull
        public final Uri getUri() {
            return this.uri;
        }

        @NotNull
        public final ClickWrench getWrench() {
            return this.wrench;
        }

        public ClickSpan(@NotNull Uri uri, @NotNull ClickWrench wrench) {
            Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
            Intrinsics.checkParameterIsNotNull((Object)wrench, (String)"wrench");
            this.uri = uri;
            this.wrench = wrench;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0002\b\u000eJ'\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/novasa/monkeywrench/MonkeyWrench$Companion;", "", "()V", "COLOR_UNDEFINED", "", "span", "", "input", "", "textView", "Landroid/widget/TextView;", "setup", "Lkotlin/Function1;", "Lcom/novasa/monkeywrench/MonkeyWrench;", "Lkotlin/ExtensionFunctionType;", "monkeywrench_release"})
    public static final class Companion {
        @NotNull
        public final CharSequence span(@NotNull CharSequence input, @NotNull Function1<? super MonkeyWrench, Unit> setup) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
            MonkeyWrench instance = new MonkeyWrench(input);
            setup.invoke((Object)instance);
            return instance.doTheThing();
        }

        public final void span(@NotNull CharSequence input, @NotNull TextView textView, @NotNull Function1<? super MonkeyWrench, Unit> setup) {
            Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
            Intrinsics.checkParameterIsNotNull((Object)textView, (String)"textView");
            Intrinsics.checkParameterIsNotNull(setup, (String)"setup");
            MonkeyWrench instance = new MonkeyWrench(input);
            setup.invoke((Object)instance);
            instance.doTheThingUnto(textView);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

