/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.universalimageloader.core.imageaware;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.assist.ViewScaleType;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;

public class NonViewAware
implements ImageAware {
    protected final String imageUri;
    protected final ImageSize imageSize;
    protected final ViewScaleType scaleType;

    public NonViewAware(ImageSize imageSize, ViewScaleType scaleType) {
        this(null, imageSize, scaleType);
    }

    public NonViewAware(String imageUri, ImageSize imageSize, ViewScaleType scaleType) {
        if (imageSize == null) {
            throw new IllegalArgumentException("imageSize must not be null");
        }
        if (scaleType == null) {
            throw new IllegalArgumentException("scaleType must not be null");
        }
        this.imageUri = imageUri;
        this.imageSize = imageSize;
        this.scaleType = scaleType;
    }

    @Override
    public int getWidth() {
        return this.imageSize.getWidth();
    }

    @Override
    public int getHeight() {
        return this.imageSize.getHeight();
    }

    @Override
    public ViewScaleType getScaleType() {
        return this.scaleType;
    }

    @Override
    public View getWrappedView() {
        return null;
    }

    @Override
    public boolean isCollected() {
        return false;
    }

    @Override
    public int getId() {
        return TextUtils.isEmpty((CharSequence)this.imageUri) ? super.hashCode() : this.imageUri.hashCode();
    }

    @Override
    public boolean setImageDrawable(Drawable drawable) {
        return true;
    }

    @Override
    public boolean setImageBitmap(Bitmap bitmap) {
        return true;
    }
}

