/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.jdbc;

import com.nordstrom.common.base.UncheckedThrow;
import com.nordstrom.common.jdbc.Param;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DatabaseUtils {
    private static final Pattern SPROC_PATTERN = Pattern.compile("([\\p{Alpha}_][\\p{Alpha}\\p{Digit}@$#_]*)(?:\\(([<>=](?:,\\s*[<>=])*)?(:)?\\))?");

    private DatabaseUtils() {
        throw new AssertionError((Object)"DatabaseUtils is a static utility class that cannot be instantiated");
    }

    public static int update(QueryAPI query, Object ... queryArgs) {
        Integer result = (Integer)DatabaseUtils.executeQuery(null, query, queryArgs);
        return result != null ? result : -1;
    }

    public static int getInt(QueryAPI query, Object ... queryArgs) {
        return DatabaseUtils.requireResult(Integer.class, query, queryArgs);
    }

    public static String getString(QueryAPI query, Object ... queryArgs) {
        return DatabaseUtils.requireResult(String.class, query, queryArgs);
    }

    private static <T> T requireResult(Class<T> resultType, QueryAPI query, Object ... queryArgs) {
        T result = DatabaseUtils.executeQuery(resultType, query, queryArgs);
        if (result != null) {
            return result;
        }
        StringBuilder message = new StringBuilder("No result from specified query: ").append(query.getEnum().name());
        String[] argNames = query.getArgNames();
        for (int i = 0; i < argNames.length; ++i) {
            message.append("\n").append(argNames[i]).append(": ").append(queryArgs[i]);
        }
        throw new IllegalStateException(message.toString());
    }

    public static ResultPackage getResultPackage(QueryAPI query, Object ... queryArgs) {
        return DatabaseUtils.executeQuery(ResultPackage.class, query, queryArgs);
    }

    private static <T> T executeQuery(Class<T> resultType, QueryAPI query, Object ... queryArgs) {
        int actualCount = queryArgs.length;
        int expectCount = query.getArgNames().length;
        if (actualCount != expectCount) {
            String message = expectCount == 0 ? "No arguments expected for " + query.getEnum().name() : String.format("Incorrect argument count for %s%s: expect: %d; actual: %d", query.getEnum().name(), Arrays.toString(query.getArgNames()), expectCount, actualCount);
            throw new IllegalArgumentException(message);
        }
        return DatabaseUtils.executeQuery(resultType, query.getConnection(), query.getQueryStr(), queryArgs);
    }

    public static <T> T executeQuery(Class<T> resultType, String connectionStr, String queryStr, Object ... params) {
        try {
            Connection connection = DatabaseUtils.getConnection(connectionStr);
            PreparedStatement statement = connection.prepareStatement(queryStr);
            for (int i = 0; i < params.length; ++i) {
                statement.setObject(i + 1, params[i]);
            }
            return DatabaseUtils.executeStatement(resultType, connection, statement);
        }
        catch (SQLException e) {
            throw UncheckedThrow.throwUnchecked(e);
        }
    }

    public static int getInt(SProcAPI sproc, Object ... params) {
        return DatabaseUtils.requireResult(Integer.class, sproc, params);
    }

    public static String getString(SProcAPI sproc, Object ... params) {
        return DatabaseUtils.requireResult(String.class, sproc, params);
    }

    private static <T> T requireResult(Class<T> resultType, SProcAPI sproc, Object ... params) {
        int i;
        T result = DatabaseUtils.executeStoredProcedure(resultType, sproc, params);
        if (result != null) {
            return result;
        }
        StringBuilder message = new StringBuilder("No result from specified stored procedure: ").append(sproc.getEnum().name());
        int argType = 0;
        int[] argTypes = sproc.getArgTypes();
        for (i = 0; i < argTypes.length; ++i) {
            argType = argTypes[i];
            message.append("\nparam ").append(i).append(": (type ").append(argType).append(") ").append(params[i]);
        }
        while (i < params.length) {
            message.append("\nparam ").append(i).append(": (type ").append(argType).append(") ").append(params[i]);
            ++i;
        }
        throw new IllegalStateException(message.toString());
    }

    public static ResultPackage getResultPackage(SProcAPI sproc, Object ... params) {
        return DatabaseUtils.executeStoredProcedure(ResultPackage.class, sproc, params);
    }

    public static <T> T executeStoredProcedure(Class<T> resultType, SProcAPI sproc, Object ... params) {
        int i;
        Objects.requireNonNull(resultType, "[resultType] argument must be non-null");
        String[] args = new String[]{};
        String sprocName = null;
        boolean hasVarArgs = false;
        int[] argTypes = sproc.getArgTypes();
        String signature = sproc.getSignature();
        Matcher matcher = SPROC_PATTERN.matcher(signature);
        String message = null;
        if (matcher.matches()) {
            sprocName = matcher.group(1);
            boolean bl = hasVarArgs = matcher.group(3) != null;
            if (matcher.group(2) != null) {
                args = matcher.group(2).split(",\\s");
            } else if (hasVarArgs) {
                message = String.format("VarArgs indicated with no placeholder in signature for %s: %s", sproc.getEnum().name(), signature);
            }
        } else {
            message = String.format("Unsupported stored procedure signature for %s: %s", sproc.getEnum().name(), signature);
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        int argsCount = args.length;
        int typesCount = argTypes.length;
        int parmsCount = params.length;
        int minCount = typesCount;
        if (argsCount != typesCount) {
            message = String.format("Signature argument count differs from declared type count for %s%s: signature: %d; declared: %d", sproc.getEnum().name(), Arrays.toString(argTypes), argsCount, typesCount);
        } else if (hasVarArgs) {
            if (parmsCount < --minCount) {
                message = String.format("Insufficient arguments count for %s%s: minimum: %d; actual: %d", sproc.getEnum().name(), Arrays.toString(argTypes), minCount, parmsCount);
            }
        } else if (parmsCount != typesCount) {
            message = typesCount == 0 ? "No arguments expected for " + sproc.getEnum().name() : String.format("Incorrect arguments count for %s%s: expect: %d; actual: %d", sproc.getEnum().name(), Arrays.toString(argTypes), typesCount, parmsCount);
        }
        if (message != null) {
            throw new IllegalArgumentException(message);
        }
        Param[] parmArray = Param.array(parmsCount);
        for (i = 0; i < minCount; ++i) {
            Param.Mode mode = Param.Mode.fromChar(args[i].charAt(0));
            parmArray[i] = Param.create(mode, argTypes[i], params[i]);
        }
        if (i < parmsCount) {
            int argType = argTypes[i];
            Param.Mode mode = Param.Mode.fromChar(args[i].charAt(0));
            do {
                parmArray[i] = Param.create(mode, argType, params[i]);
            } while (++i < parmsCount);
        }
        return DatabaseUtils.executeStoredProcedure(resultType, sproc.getConnection(), sprocName, parmArray);
    }

    public static <T> T executeStoredProcedure(Class<T> resultType, String connectionStr, String sprocName, Param ... params) {
        Objects.requireNonNull(resultType, "[resultType] argument must be non-null");
        StringBuilder sprocStr = new StringBuilder("{call ").append(sprocName).append("(");
        String placeholder = "?";
        for (int i = 0; i < params.length; ++i) {
            sprocStr.append(placeholder);
            placeholder = ",?";
        }
        sprocStr.append(")}");
        try {
            Connection connection = DatabaseUtils.getConnection(connectionStr);
            CallableStatement statement = connection.prepareCall(sprocStr.toString());
            for (int i = 0; i < params.length; ++i) {
                params[i].set(statement, i + 1);
            }
            return DatabaseUtils.executeStatement(resultType, connection, statement);
        }
        catch (SQLException e) {
            throw UncheckedThrow.throwUnchecked(e);
        }
    }

    private static <T> T executeStatement(Class<T> resultType, Connection connection, PreparedStatement statement) {
        Object result = null;
        boolean failed = false;
        ResultSet resultSet = null;
        try {
            if (resultType == null) {
                result = statement.executeUpdate();
            } else if (statement instanceof CallableStatement) {
                if (statement.execute()) {
                    resultSet = statement.getResultSet();
                }
                result = resultType == ResultPackage.class ? new ResultPackage(connection, statement, resultSet) : (resultType == Integer.class ? Integer.valueOf(((CallableStatement)statement).getInt(1)) : (resultType == String.class ? ((CallableStatement)statement).getString(1) : ((CallableStatement)statement).getObject(1)));
            } else {
                resultSet = statement.executeQuery();
                result = resultType == ResultPackage.class ? new ResultPackage(connection, statement, resultSet) : (resultType == Integer.class ? Integer.valueOf(resultSet.next() ? resultSet.getInt(1) : -1) : (resultType == String.class ? (resultSet.next() ? resultSet.getString(1) : null) : (resultSet.next() ? resultSet.getObject(1, resultType) : null)));
            }
        }
        catch (SQLException e) {
            failed = true;
            throw UncheckedThrow.throwUnchecked(e);
        }
        finally {
            if (failed || resultType != ResultPackage.class) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
                if (connection != null) {
                    try {
                        connection.commit();
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        return (T)result;
    }

    private static Connection getConnection(String connectionString) {
        try {
            return DriverManager.getConnection(connectionString);
        }
        catch (SQLException e) {
            throw UncheckedThrow.throwUnchecked(e);
        }
    }

    static {
        Iterator<Driver> iterator = ServiceLoader.load(Driver.class).iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    public static class ResultPackage
    implements AutoCloseable {
        private Connection connection;
        private PreparedStatement statement;
        private ResultSet resultSet;

        private ResultPackage(Connection connection, PreparedStatement statement, ResultSet resultSet) {
            this.connection = connection;
            this.statement = statement;
            this.resultSet = resultSet;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public PreparedStatement getStatement() {
            return this.statement;
        }

        public CallableStatement getCallable() {
            if (this.statement instanceof CallableStatement) {
                return (CallableStatement)this.statement;
            }
            throw new UnsupportedOperationException("The statement of this package is not a CallableStatement");
        }

        public ResultSet getResultSet() {
            if (this.resultSet != null) {
                return this.resultSet;
            }
            throw new IllegalStateException("The result set in this package has been closed");
        }

        @Override
        public void close() {
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                    this.resultSet = null;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                    this.statement = null;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.commit();
                    this.connection.close();
                    this.connection = null;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public static interface SProcAPI {
        public String getSignature();

        public int[] getArgTypes();

        public String getConnection();

        public Enum<? extends SProcAPI> getEnum();
    }

    public static interface QueryAPI {
        public String getQueryStr();

        public String[] getArgNames();

        public String getConnection();

        public Enum<? extends QueryAPI> getEnum();
    }
}

