/*
 * Decompiled with CFR 0.152.
 */
package com.nordstrom.common.file;

import com.nordstrom.common.file.OSInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VolumeInfo {
    static final boolean IS_WINDOWS = OSInfo.getDefault().getType() == OSInfo.OSType.WINDOWS;

    private VolumeInfo() {
        throw new AssertionError((Object)"VolumeInfo is a static utility class that cannot be instantiated");
    }

    public static Map<String, VolumeProps> getVolumeProps() throws IOException {
        Process mountProcess;
        if (IS_WINDOWS) {
            String[] cmd = new String[]{"sh", "-c", "mount | grep noumount"};
            mountProcess = Runtime.getRuntime().exec(cmd);
        } else {
            mountProcess = Runtime.getRuntime().exec("mount");
        }
        return VolumeInfo.getVolumeProps(mountProcess.getInputStream());
    }

    public static Map<String, VolumeProps> getVolumeProps(InputStream is) throws IOException {
        HashMap<String, VolumeProps> propsList = new HashMap<String, VolumeProps>();
        Pattern template = Pattern.compile("(.+) on (.+) type (.+) \\((.+)\\)");
        InputStreamReader isr = new InputStreamReader(is);
        try (BufferedReader mountOutput = new BufferedReader(isr);){
            String line;
            while (null != (line = mountOutput.readLine())) {
                String[] opts;
                String type;
                String file;
                String spec;
                VolumeProps props;
                Matcher matcher = template.matcher(line);
                if (!matcher.matches() || (props = new VolumeProps(spec = matcher.group(1), file = matcher.group(2), type = matcher.group(3), opts = matcher.group(4).split(","))).size <= 0L) continue;
                propsList.put(spec, props);
            }
        }
        return propsList;
    }

    public static class VolumeProps {
        String file;
        String type;
        String[] opts;
        private final long size;
        private long free;

        VolumeProps(String spec, String file, String type, String ... opts) {
            this.file = IS_WINDOWS ? spec : file;
            this.type = type;
            this.opts = opts;
            File f = new File(this.file);
            this.size = f.getTotalSpace();
            this.free = f.getFreeSpace();
        }

        public String getFile() {
            return this.file;
        }

        public String getType() {
            return this.type;
        }

        public String[] getOpts() {
            return this.opts;
        }

        public long getSize() {
            return this.size;
        }

        public long getFree() {
            return this.free;
        }
    }
}

