package com.noisyz.bindlibrary.wrappers.view.simple.text;

import android.text.InputType;
import android.widget.TextView;

/**
 * Created by Oleg on 18.03.2016.
 */
public class DoubleTextWrapper extends BaseTextWrapper<Double> {

    @Override
    public void addListeners(TextView textView) {
        super.addListeners(textView);
        textView.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL | InputType.TYPE_NUMBER_FLAG_SIGNED);
    }

    @Override
    public void removeListeners(TextView textView) {
        textView.removeTextChangedListener(this);
    }

    @Override
    protected void bindByValueFromText(String text) {
        try {
            Double value = Double.parseDouble(text);
            bindObject(value);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }
}
