package com.noisyz.bindlibrary.wrappers.view.simple.text;

import android.text.InputType;
import android.widget.TextView;

/**
 * Created by Oleg on 18.03.2016.
 */
public class FloatTextWrapper extends BaseTextWrapper<Float>{

    @Override
    public void addListeners(TextView textView) {
        super.addListeners(textView);
        textView.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL | InputType.TYPE_NUMBER_FLAG_SIGNED);
    }

    @Override
    public void bindUI(Float aFloat, TextView textView) {
        if (aFloat != 0) {
            super.bindUI(aFloat, textView);
        }
    }

    @Override
    protected void bindByValueFromText(String text) {
        try {
            Float value = Float.parseFloat(text);
            bindObject(value);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }
}
