package com.noisyz.bindlibrary.base.impl.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;

import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import com.noisyz.bindlibrary.callback.layoutcallback.EmptyLayoutResourceProvider;
import com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by oleg on 06.09.16.
 */
public abstract class RecyclerBindAdapter<T> extends RecyclerView.Adapter<BindViewHolder<T>> {

    private List<T> itemList;
    private LayoutResourceProvider<T> layoutResourceProvider;
    private OnItemClickListener<T> onItemClickListener;
    private List<OnElementClickListenerWrapper<T>> elementsClickWrappers;

    public RecyclerBindAdapter(List<T> itemList, int layoutResID) {
        this(itemList, new EmptyLayoutResourceProvider<T>(layoutResID));
    }

    public RecyclerBindAdapter(List<T> itemList, final LayoutResourceProvider<T> mLayoutResourceProvider) {
        layoutResourceProvider = mLayoutResourceProvider;
        if (itemList == null) {
            itemList = new ArrayList<>();
        }
        this.itemList = itemList;
        elementsClickWrappers = new ArrayList<>();
    }

    public RecyclerBindAdapter<T> setOnElementClickListener(int elementId, OnElementClickListener<T> onClickListener) {
        elementsClickWrappers.add(new OnElementClickListenerWrapper<>(elementId, onClickListener));
        return this;
    }

    public RecyclerBindAdapter<T> setOnElementsClickListener(OnElementClickListener<T> onClickListener, int... elementIds) {
        elementsClickWrappers.add(new OnElementClickListenerWrapper<>(elementIds, onClickListener));
        return this;
    }

    public RecyclerBindAdapter<T> setOnItemClickListener(OnItemClickListener<T> onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        return this;
    }

    @Override
    public BindViewHolder<T> onCreateViewHolder(ViewGroup parent, int layoutId) {
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());
        return new BindViewHolder<>(inflater.inflate(layoutId, parent, false),
                initObjectViewBinder(null));
    }

    @Override
    public int getItemViewType(int position) {
        return layoutResourceProvider.getLayoutResourceID(getItem(position));
    }

    public void onBindViewHolder(BindViewHolder<T> holder, int position) {
        final T t = getItem(position);
        holder.bindView(t, onItemClickListener, elementsClickWrappers);
    }

    @Override
    public int getItemCount() {
        return itemList != null ? itemList.size() : 0;
    }

    public T getItem(int position) {
        return itemList != null ? itemList.get(position) : null;
    }

    public List<T> getItems() {
        return itemList;
    }

    public void setItems(List<T> items) {
        this.itemList = items;

        notifyDataSetChanged();
    }

    protected abstract ObjectViewBinder<T> initObjectViewBinder(T t);

}
