/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.classbuilder;

import com.noisyz.bindlibrary.StringUtils;
import com.noisyz.bindlibrary.classbuilder.base.Class;
import com.noisyz.bindlibrary.classbuilder.base.Constructor;
import com.noisyz.bindlibrary.classbuilder.base.Field;
import com.noisyz.bindlibrary.classbuilder.base.Method;
import java.util.ArrayList;
import java.util.List;

public class ObjectBinderPattern
extends Class {
    private List<String> properties = new ArrayList<String>();
    private String type;

    public ObjectBinderPattern(String type) {
        this.setPackageName("com.bindlibrary.generated");
        this.type = type;
    }

    private void setup() {
        String name = StringUtils.getShortType(this.type);
        this.setName(name + "ViewBinder");
        String objectViewBinderClass = "com.noisyz.bindlibrary.base.impl.ObjectViewBinder";
        this.addImport(objectViewBinderClass);
        this.addImport(this.type);
        this.addImport("java.util.List");
        this.addImport("java.util.ArrayList");
        this.addImport("com.noisyz.bindlibrary.property.abs.Property");
        this.addImport("com.noisyz.bindlibrary.models.key.Key");
        this.addImport("com.noisyz.bindlibrary.annotation.Type");
        this.setSuperClass(StringUtils.getShortType(objectViewBinderClass) + "<" + name + ">");
        this.initConstructor(this.type);
        this.initMethods();
    }

    private void initConstructor(String type) {
        Constructor constructor = this.buildEmptyConstructor();
        Field field = new Field().setTypeAndName(StringUtils.getShortType(type), StringUtils.getTypeAsVariable(type));
        constructor.addArgument(field);
        constructor.addBody("super(" + StringUtils.getTypeAsVariable(type) + ")");
        this.addConstructor(constructor);
    }

    private void initMethods() {
        Method method = new Method().setModifiers("protected").setReturnType("List<Property>").setName("getProperties").addAnnotation("Override");
        method.addBody("List<Property> properties = new ArrayList<>();");
        for (String property : this.properties) {
            method.addBody("properties.add(" + property + ")");
        }
        method.addBody("return properties");
        this.addMethod(method);
    }

    public ObjectBinderPattern addProperty(String property) {
        this.properties.add(property);
        return this;
    }

    @Override
    public String writeSource() {
        this.setup();
        return super.writeSource();
    }
}

