/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import com.noisyz.bindlibrary.base.UIBinder;
import com.noisyz.bindlibrary.property.abs.Property;
import com.noisyz.bindlibrary.wrappers.PropertyViewWrapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public abstract class ObjectViewBinder<T>
implements UIBinder<T>,
View.OnAttachStateChangeListener {
    private WeakReference<View> parentViewRef;
    private T t;
    private List<PropertyViewWrapper> propertyViewWrappers;

    public ObjectViewBinder(T t) {
        this.initBinders();
        this.setBindObject(t);
    }

    public ObjectViewBinder registerView(Activity activity) {
        View viewGroup = ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0);
        return this.registerView(viewGroup);
    }

    protected abstract List<Property> getProperties();

    protected void initBinders() {
        this.propertyViewWrappers = new ArrayList<PropertyViewWrapper>();
        for (Property property : this.getProperties()) {
            PropertyViewWrapper propertyViewWrapper = property.buildPropertyViewWrapper(this.t);
            if (propertyViewWrapper == null) continue;
            this.propertyViewWrappers.add(propertyViewWrapper);
        }
    }

    public ObjectViewBinder<T> registerView(View parentView) {
        this.parentViewRef = new WeakReference<View>(parentView);
        if (this.propertyViewWrappers != null) {
            for (PropertyViewWrapper propertyViewWrapper : this.propertyViewWrappers) {
                propertyViewWrapper.registerView((ViewGroup)parentView);
            }
        }
        return this;
    }

    public void clearEmptyBinders() {
        if (this.propertyViewWrappers != null) {
            ArrayList<PropertyViewWrapper> emptyWrappers = new ArrayList<PropertyViewWrapper>();
            for (PropertyViewWrapper propertyViewWrapper : this.propertyViewWrappers) {
                if (!propertyViewWrapper.isEmpty()) continue;
                emptyWrappers.add(propertyViewWrapper);
            }
            this.propertyViewWrappers.removeAll(emptyWrappers);
        }
    }

    public View getViewParent() {
        return this.parentViewRef != null ? (View)this.parentViewRef.get() : null;
    }

    public ObjectViewBinder<T> setOnElementClick(int elementId, View.OnClickListener onClickListener) {
        View child;
        View parentView = this.getViewParent();
        if (parentView != null && (child = parentView.findViewById(elementId)) != null) {
            child.setOnClickListener(onClickListener);
        }
        return this;
    }

    public ObjectViewBinder setOnElementsClick(View.OnClickListener onClickListener, int ... elementsId) {
        for (int elementId : elementsId) {
            this.setOnElementClick(elementId, onClickListener);
        }
        return this;
    }

    @Override
    public void bindUI() {
        if (this.getBindObject() != null && this.propertyViewWrappers != null) {
            for (PropertyViewWrapper propertyViewWrapper : this.propertyViewWrappers) {
                propertyViewWrapper.bindUI();
            }
        }
    }

    @Override
    public void setBindObject(T t) {
        this.t = t;
        if (this.propertyViewWrappers != null) {
            for (PropertyViewWrapper propertyViewWrapper : this.propertyViewWrappers) {
                propertyViewWrapper.setBindObject(t);
            }
        }
    }

    @Override
    public T getBindObject() {
        return this.t;
    }

    @Override
    public void release() {
        if (this.parentViewRef != null) {
            this.parentViewRef.clear();
            this.parentViewRef = null;
        }
    }

    public void onViewAttachedToWindow(View view) {
    }

    public void onViewDetachedFromWindow(View view) {
        this.release();
    }
}

