/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.base.impl.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.noisyz.bindlibrary.base.impl.ObjectViewBinder;
import com.noisyz.bindlibrary.base.impl.adapter.BindViewHolder;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListener;
import com.noisyz.bindlibrary.callback.clickevent.OnElementClickListenerWrapper;
import com.noisyz.bindlibrary.callback.clickevent.OnItemClickListener;
import com.noisyz.bindlibrary.callback.layoutcallback.EmptyLayoutResourceProvider;
import com.noisyz.bindlibrary.callback.layoutcallback.LayoutResourceProvider;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclerBindAdapter<T>
extends RecyclerView.Adapter<BindViewHolder<T>> {
    private List<T> itemList;
    private LayoutResourceProvider<T> layoutResourceProvider;
    private OnItemClickListener<T> onItemClickListener;
    private List<OnElementClickListenerWrapper<T>> elementsClickWrappers;

    public RecyclerBindAdapter(List<T> itemList, int layoutResID) {
        this(itemList, new EmptyLayoutResourceProvider(layoutResID));
    }

    public RecyclerBindAdapter(List<T> itemList, LayoutResourceProvider<T> mLayoutResourceProvider) {
        this.layoutResourceProvider = mLayoutResourceProvider;
        if (itemList == null) {
            itemList = new ArrayList<T>();
        }
        this.itemList = itemList;
        this.elementsClickWrappers = new ArrayList<OnElementClickListenerWrapper<T>>();
    }

    public RecyclerBindAdapter<T> setOnElementClickListener(int elementId, OnElementClickListener<T> onClickListener) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper<T>(elementId, onClickListener));
        return this;
    }

    public RecyclerBindAdapter<T> setOnElementsClickListener(OnElementClickListener<T> onClickListener, int ... elementIds) {
        this.elementsClickWrappers.add(new OnElementClickListenerWrapper<T>(elementIds, onClickListener));
        return this;
    }

    public RecyclerBindAdapter<T> setOnItemClickListener(OnItemClickListener<T> onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
        return this;
    }

    public BindViewHolder<T> onCreateViewHolder(ViewGroup parent, int layoutId) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        return new BindViewHolder<Object>(inflater.inflate(layoutId, parent, false), this.initObjectViewBinder(null));
    }

    public int getItemViewType(int position) {
        return this.layoutResourceProvider.getLayoutResourceID(this.getItem(position));
    }

    public void onBindViewHolder(BindViewHolder<T> holder, int position) {
        T t = this.getItem(position);
        holder.bindView(t, this.onItemClickListener, this.elementsClickWrappers);
    }

    public int getItemCount() {
        return this.itemList != null ? this.itemList.size() : 0;
    }

    public T getItem(int position) {
        return this.itemList != null ? (T)this.itemList.get(position) : null;
    }

    public List<T> getItems() {
        return this.itemList;
    }

    public void setItems(List<T> items) {
        this.itemList = items;
        this.notifyDataSetChanged();
    }

    protected abstract ObjectViewBinder<T> initObjectViewBinder(T var1);
}

