/*
 * Decompiled with CFR 0.152.
 */
package com.noisyz.bindlibrary.classbuilder;

import com.noisyz.bindlibrary.StringUtils;
import com.noisyz.bindlibrary.classbuilder.base.Class;
import com.noisyz.bindlibrary.classbuilder.base.Constructor;
import com.noisyz.bindlibrary.classbuilder.base.Field;
import com.noisyz.bindlibrary.classbuilder.base.Method;

public class ObjectBinderPattern
extends Class {
    public ObjectBinderPattern(String type) {
        this.setPackageName("com.bindlibrary.generated");
        this.setup(type);
    }

    private void setup(String type) {
        String name = StringUtils.getShortType(type);
        this.setName(name + "ViewBinder");
        String objectViewBinderClass = "com.noisyz.bindlibrary.base.impl.ObjectViewBinder";
        this.addImport(objectViewBinderClass);
        this.addImport(type);
        this.addImport("java.util.List");
        this.addImport("java.util.ArrayList");
        this.addImport("com.noisyz.bindlibrary.property.abs.Property");
        this.addImport("com.noisyz.bindlibrary.models.key.Key");
        this.addImport("com.noisyz.bindlibrary.annotation.Type");
        this.setSuperClass(StringUtils.getShortType(objectViewBinderClass) + "<" + name + ">");
        this.initConstructor(type);
        this.initFields();
        this.initMethods();
    }

    private void initConstructor(String type) {
        Constructor constructor = this.buildEmptyConstructor();
        Field field = new Field().setTypeAndName(StringUtils.getShortType(type), StringUtils.getTypeAsVariable(type));
        constructor.addArgument(field);
        constructor.addBody("super(" + StringUtils.getTypeAsVariable(type) + ")");
        this.addConstructor(constructor);
    }

    private void initFields() {
        Field field = new Field().setTypeAndName("List<Property>", "properties").setInitializer("new ArrayList<>()").setModifiers("private static final");
        this.addField(field);
    }

    private void initMethods() {
        Method method = new Method().setModifiers("protected").setReturnType("List<Property>").setName("getProperties").addBody("return properties").addAnnotation("Override");
        this.addMethod(method);
    }

    public ObjectBinderPattern addProperty(String property) {
        this.addStaticInitializerLine("properties.add(" + property + ")");
        return this;
    }
}

