package com.noisyz.bindlibrary.wrappers.view.simple.text;

import android.text.InputType;
import android.widget.TextView;

/**
 * Created by Oleg on 18.03.2016.
 */
public class IntegerTextWrapper extends BaseTextWrapper<Integer> {

    @Override
    public void addListeners(TextView textView) {
        super.addListeners(textView);
        textView.setInputType(InputType.TYPE_CLASS_NUMBER);
    }


    @Override
    protected void bindByValueFromText(String text) {
        try {
            Integer value = Integer.valueOf(text);
            bindObject(value);
        } catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void bindUI(Integer integer, TextView textView) {
        if (integer != 0)
            super.bindUI(integer, textView);
    }
}
